/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.List;
import java.util.stream.IntStream;
import org.apache.iceberg.spark.IcebergSpark;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPartitionedWritesAsSelect
extends SparkTestBaseWithCatalog {
    private final String targetTable = this.tableName("target_table");

    @Before
    public void createTables() {
        this.sql("CREATE TABLE %s (id bigint, data string, category string, ts timestamp) USING iceberg", this.tableName);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        this.sql("DROP TABLE IF EXISTS %s", this.targetTable);
    }

    @Test
    public void testInsertAsSelectAppend() {
        this.insertData(3);
        List<Object[]> expected = this.currentData();
        this.sql("CREATE TABLE %s (id bigint, data string, category string, ts timestamp)USING iceberg PARTITIONED BY (days(ts), category)", this.targetTable);
        this.sql("INSERT INTO %s SELECT id, data, category, ts FROM %s ORDER BY ts,category", this.targetTable, this.tableName);
        Assert.assertEquals((String)"Should have 15 rows after insert", (Object)15L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.targetTable));
        this.assertEquals("Row data should match expected", expected, this.sql("SELECT * FROM %s ORDER BY id", this.targetTable));
    }

    @Test
    public void testInsertAsSelectWithBucket() {
        this.insertData(3);
        List<Object[]> expected = this.currentData();
        this.sql("CREATE TABLE %s (id bigint, data string, category string, ts timestamp)USING iceberg PARTITIONED BY (bucket(8, data))", this.targetTable);
        IcebergSpark.registerBucketUDF((SparkSession)spark, (String)"iceberg_bucket8", (DataType)DataTypes.StringType, (int)8);
        this.sql("INSERT INTO %s SELECT id, data, category, ts FROM %s ORDER BY iceberg_bucket8(data)", this.targetTable, this.tableName);
        Assert.assertEquals((String)"Should have 15 rows after insert", (Object)15L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.targetTable));
        this.assertEquals("Row data should match expected", expected, this.sql("SELECT * FROM %s ORDER BY id", this.targetTable));
    }

    @Test
    public void testInsertAsSelectWithTruncate() {
        this.insertData(3);
        List<Object[]> expected = this.currentData();
        this.sql("CREATE TABLE %s (id bigint, data string, category string, ts timestamp)USING iceberg PARTITIONED BY (truncate(data, 4), truncate(id, 4))", this.targetTable);
        IcebergSpark.registerTruncateUDF((SparkSession)spark, (String)"iceberg_truncate_string4", (DataType)DataTypes.StringType, (int)4);
        IcebergSpark.registerTruncateUDF((SparkSession)spark, (String)"iceberg_truncate_long4", (DataType)DataTypes.LongType, (int)4);
        this.sql("INSERT INTO %s SELECT id, data, category, ts FROM %s ORDER BY iceberg_truncate_string4(data),iceberg_truncate_long4(id)", this.targetTable, this.tableName);
        Assert.assertEquals((String)"Should have 15 rows after insert", (Object)15L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.targetTable));
        this.assertEquals("Row data should match expected", expected, this.sql("SELECT * FROM %s ORDER BY id", this.targetTable));
    }

    private void insertData(int repeatCounter) {
        IntStream.range(0, repeatCounter).forEach(i -> this.sql("INSERT INTO %s VALUES (13, '1', 'bgd16', timestamp('2021-11-10 11:20:10')),(21, '2', 'bgd13', timestamp('2021-11-10 11:20:10')), (12, '3', 'bgd14', timestamp('2021-11-10 11:20:10')),(222, '3', 'bgd15', timestamp('2021-11-10 11:20:10')),(45, '4', 'bgd16', timestamp('2021-11-10 11:20:10'))", this.tableName));
    }

    private List<Object[]> currentData() {
        return this.rowsToJava(spark.sql("SELECT * FROM " + this.tableName + " order by id").collectAsList());
    }
}

