/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.apache.iceberg.relocated.com.google.common.io.BaseEncoding;
import org.apache.iceberg.spark.SparkTestBaseWithCatalog;
import org.apache.spark.sql.AnalysisException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestSparkTruncateFunction
extends SparkTestBaseWithCatalog {
    @Before
    public void useCatalog() {
        this.sql("USE %s", this.catalogName);
    }

    @Test
    public void testTruncateTinyInt() {
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 0Y)", new Object[0]));
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 1Y)", new Object[0]));
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 5Y)", new Object[0]));
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 9Y)", new Object[0]));
        Assert.assertEquals((Object)10, (Object)this.scalarSql("SELECT system.truncate(10, 10Y)", new Object[0]));
        Assert.assertEquals((Object)10, (Object)this.scalarSql("SELECT system.truncate(10, 11Y)", new Object[0]));
        Assert.assertEquals((Object)-10, (Object)this.scalarSql("SELECT system.truncate(10, -1Y)", new Object[0]));
        Assert.assertEquals((Object)-10, (Object)this.scalarSql("SELECT system.truncate(10, -5Y)", new Object[0]));
        Assert.assertEquals((Object)-10, (Object)this.scalarSql("SELECT system.truncate(10, -10Y)", new Object[0]));
        Assert.assertEquals((Object)-20, (Object)this.scalarSql("SELECT system.truncate(10, -11Y)", new Object[0]));
        Assert.assertEquals((Object)-2, (Object)this.scalarSql("SELECT system.truncate(2, -1Y)", new Object[0]));
        Assert.assertNull((String)"Null input should return null", (Object)this.scalarSql("SELECT system.truncate(2, CAST(null AS tinyint))", new Object[0]));
    }

    @Test
    public void testTruncateSmallInt() {
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 0S)", new Object[0]));
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 1S)", new Object[0]));
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 5S)", new Object[0]));
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 9S)", new Object[0]));
        Assert.assertEquals((Object)10, (Object)this.scalarSql("SELECT system.truncate(10, 10S)", new Object[0]));
        Assert.assertEquals((Object)10, (Object)this.scalarSql("SELECT system.truncate(10, 11S)", new Object[0]));
        Assert.assertEquals((Object)-10, (Object)this.scalarSql("SELECT system.truncate(10, -1S)", new Object[0]));
        Assert.assertEquals((Object)-10, (Object)this.scalarSql("SELECT system.truncate(10, -5S)", new Object[0]));
        Assert.assertEquals((Object)-10, (Object)this.scalarSql("SELECT system.truncate(10, -10S)", new Object[0]));
        Assert.assertEquals((Object)-20, (Object)this.scalarSql("SELECT system.truncate(10, -11S)", new Object[0]));
        Assert.assertEquals((Object)-2, (Object)this.scalarSql("SELECT system.truncate(2, -1S)", new Object[0]));
        Assert.assertNull((String)"Null input should return null", (Object)this.scalarSql("SELECT system.truncate(2, CAST(null AS smallint))", new Object[0]));
    }

    @Test
    public void testTruncateInt() {
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 0)", new Object[0]));
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 1)", new Object[0]));
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 5)", new Object[0]));
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(10, 9)", new Object[0]));
        Assert.assertEquals((Object)10, (Object)this.scalarSql("SELECT system.truncate(10, 10)", new Object[0]));
        Assert.assertEquals((Object)10, (Object)this.scalarSql("SELECT system.truncate(10, 11)", new Object[0]));
        Assert.assertEquals((Object)-10, (Object)this.scalarSql("SELECT system.truncate(10, -1)", new Object[0]));
        Assert.assertEquals((Object)-10, (Object)this.scalarSql("SELECT system.truncate(10, -5)", new Object[0]));
        Assert.assertEquals((Object)-10, (Object)this.scalarSql("SELECT system.truncate(10, -10)", new Object[0]));
        Assert.assertEquals((Object)-20, (Object)this.scalarSql("SELECT system.truncate(10, -11)", new Object[0]));
        Assert.assertEquals((Object)-2, (Object)this.scalarSql("SELECT system.truncate(2, -1)", new Object[0]));
        Assert.assertEquals((Object)0, (Object)this.scalarSql("SELECT system.truncate(300, 1)", new Object[0]));
        Assert.assertNull((String)"Null input should return null", (Object)this.scalarSql("SELECT system.truncate(2, CAST(null AS int))", new Object[0]));
    }

    @Test
    public void testTruncateBigInt() {
        Assert.assertEquals((Object)0L, (Object)this.scalarSql("SELECT system.truncate(10, 0L)", new Object[0]));
        Assert.assertEquals((Object)0L, (Object)this.scalarSql("SELECT system.truncate(10, 1L)", new Object[0]));
        Assert.assertEquals((Object)0L, (Object)this.scalarSql("SELECT system.truncate(10, 5L)", new Object[0]));
        Assert.assertEquals((Object)0L, (Object)this.scalarSql("SELECT system.truncate(10, 9L)", new Object[0]));
        Assert.assertEquals((Object)10L, (Object)this.scalarSql("SELECT system.truncate(10, 10L)", new Object[0]));
        Assert.assertEquals((Object)10L, (Object)this.scalarSql("SELECT system.truncate(10, 11L)", new Object[0]));
        Assert.assertEquals((Object)-10L, (Object)this.scalarSql("SELECT system.truncate(10, -1L)", new Object[0]));
        Assert.assertEquals((Object)-10L, (Object)this.scalarSql("SELECT system.truncate(10, -5L)", new Object[0]));
        Assert.assertEquals((Object)-10L, (Object)this.scalarSql("SELECT system.truncate(10, -10L)", new Object[0]));
        Assert.assertEquals((Object)-20L, (Object)this.scalarSql("SELECT system.truncate(10, -11L)", new Object[0]));
        Assert.assertEquals((Object)-2L, (Object)this.scalarSql("SELECT system.truncate(2, -1L)", new Object[0]));
        Assert.assertNull((String)"Null input should return null", (Object)this.scalarSql("SELECT system.truncate(2, CAST(null AS bigint))", new Object[0]));
    }

    @Test
    public void testTruncateDecimal() {
        Assert.assertEquals((Object)new BigDecimal("12.30"), (Object)this.scalarSql("SELECT system.truncate(10, CAST(%s as DECIMAL(9, 2)))", "12.34"));
        Assert.assertEquals((Object)new BigDecimal("12.30"), (Object)this.scalarSql("SELECT system.truncate(10, CAST(%s as DECIMAL(9, 2)))", "12.30"));
        Assert.assertEquals((Object)new BigDecimal("12.290"), (Object)this.scalarSql("SELECT system.truncate(10, CAST(%s as DECIMAL(9, 3)))", "12.299"));
        Assert.assertEquals((Object)new BigDecimal("0.03"), (Object)this.scalarSql("SELECT system.truncate(3, CAST(%s as DECIMAL(5, 2)))", "0.05"));
        Assert.assertEquals((Object)new BigDecimal("0.00"), (Object)this.scalarSql("SELECT system.truncate(10, CAST(%s as DECIMAL(9, 2)))", "0.05"));
        Assert.assertEquals((Object)new BigDecimal("-0.10"), (Object)this.scalarSql("SELECT system.truncate(10, CAST(%s as DECIMAL(9, 2)))", "-0.05"));
        Assert.assertEquals((String)"Implicit decimal scale and precision should be allowed", (Object)new BigDecimal("12345.3480"), (Object)this.scalarSql("SELECT system.truncate(10, 12345.3482)", new Object[0]));
        BigDecimal truncatedDecimal = (BigDecimal)this.scalarSql("SELECT system.truncate(10, CAST(%s as DECIMAL(6, 4)))", "-0.05");
        Assert.assertEquals((String)"Truncating a decimal should return a decimal with the same scale", (long)4L, (long)truncatedDecimal.scale());
        Assert.assertEquals((String)"Truncating a decimal should return a decimal with the correct scale", (Object)BigDecimal.valueOf(-500L, 4), (Object)truncatedDecimal);
        Assert.assertNull((String)"Null input should return null", (Object)this.scalarSql("SELECT system.truncate(2, CAST(null AS decimal))", new Object[0]));
    }

    @Test
    public void testTruncateString() {
        Assert.assertEquals((String)"Should system.truncate strings longer than length", (Object)"abcde", (Object)this.scalarSql("SELECT system.truncate(5, 'abcdefg')", new Object[0]));
        Assert.assertEquals((String)"Should not pad strings shorter than length", (Object)"abc", (Object)this.scalarSql("SELECT system.truncate(5, 'abc')", new Object[0]));
        Assert.assertEquals((String)"Should not alter strings equal to length", (Object)"abcde", (Object)this.scalarSql("SELECT system.truncate(5, 'abcde')", new Object[0]));
        Assert.assertEquals((String)"Strings with multibyte unicode characters should should truncate along codepoint boundaries", (Object)"\u30a4\u30ed", (Object)this.scalarSql("SELECT system.truncate(2, '\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8')", new Object[0]));
        Assert.assertEquals((String)"Strings with multibyte unicode characters should truncate along codepoint boundaries", (Object)"\u30a4\u30ed\u30cf", (Object)this.scalarSql("SELECT system.truncate(3, '\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8')", new Object[0]));
        Assert.assertEquals((String)"Strings with multibyte unicode characters should not alter input with fewer codepoints than width", (Object)"\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8", (Object)this.scalarSql("SELECT system.truncate(7, '\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8')", new Object[0]));
        String stringWithTwoCodePointsEachFourBytes = "\ud800\udc00\ud800\udc00";
        Assert.assertEquals((String)"String truncation on four byte codepoints should work as expected", (Object)"\ud800\udc00", (Object)this.scalarSql("SELECT system.truncate(1, '%s')", stringWithTwoCodePointsEachFourBytes));
        Assert.assertEquals((String)"Should handle three-byte UTF-8 characters appropriately", (Object)"\u6d4b", (Object)this.scalarSql("SELECT system.truncate(1, '\u6d4b\u8bd5')", new Object[0]));
        Assert.assertEquals((String)"Should handle three-byte UTF-8 characters mixed with two byte utf-8 characters", (Object)"\u6d4b\u8bd5ra", (Object)this.scalarSql("SELECT system.truncate(4, '\u6d4b\u8bd5raul\u8bd5\u6d4b')", new Object[0]));
        Assert.assertEquals((String)"Should not fail on the empty string", (Object)"", (Object)this.scalarSql("SELECT system.truncate(10, '')", new Object[0]));
        Assert.assertNull((String)"Null input should return null as output", (Object)this.scalarSql("SELECT system.truncate(3, CAST(null AS string))", new Object[0]));
        Assert.assertEquals((String)"Varchar should work like string", (Object)"\u6d4b\u8bd5ra", (Object)this.scalarSql("SELECT system.truncate(4, CAST('\u6d4b\u8bd5raul\u8bd5\u6d4b' AS varchar(8)))", new Object[0]));
        Assert.assertEquals((String)"Char should work like string", (Object)"\u6d4b\u8bd5ra", (Object)this.scalarSql("SELECT system.truncate(4, CAST('\u6d4b\u8bd5raul\u8bd5\u6d4b' AS char(8)))", new Object[0]));
    }

    @Test
    public void testTruncateBinary() {
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, (byte[])((byte[])this.scalarSql("SELECT system.truncate(10, X'0102030405060708090a0b0c0d0e0f')", new Object[0])));
        Assert.assertArrayEquals((String)"Should return the same input when value is equal to truncation width", (byte[])"abc".getBytes(StandardCharsets.UTF_8), (byte[])((byte[])this.scalarSql("SELECT system.truncate(3, %s)", this.asBytesLiteral("abcdefg"))));
        Assert.assertArrayEquals((String)"Should not truncate, pad, or trim the input when its length is less than the width", (byte[])"abc\u0000\u0000".getBytes(StandardCharsets.UTF_8), (byte[])((byte[])this.scalarSql("SELECT system.truncate(10, %s)", this.asBytesLiteral("abc\u0000\u0000"))));
        Assert.assertArrayEquals((String)"Should not pad the input when its length is equal to the width", (byte[])"abc".getBytes(StandardCharsets.UTF_8), (byte[])((byte[])this.scalarSql("SELECT system.truncate(3, %s)", this.asBytesLiteral("abc"))));
        Assert.assertArrayEquals((String)"Should handle three-byte UTF-8 characters appropriately", (byte[])"\u6d4b\u8bd5".getBytes(StandardCharsets.UTF_8), (byte[])((byte[])this.scalarSql("SELECT system.truncate(6, %s)", this.asBytesLiteral("\u6d4b\u8bd5_"))));
        Assert.assertNull((String)"Null input should return null as output", (Object)this.scalarSql("SELECT system.truncate(3, CAST(null AS binary))", new Object[0]));
    }

    @Test
    public void testTruncateUsingDataframeForWidthWithVaryingWidth() {
        long rumRows = 10L;
        long numNonZero = spark.range(rumRows).toDF(new String[]{"value"}).selectExpr(new String[]{"CAST(value + 1 AS INT) AS width", "value"}).selectExpr(new String[]{"system.truncate(width, value) as truncated_value"}).filter("truncated_value == 0").count();
        Assert.assertEquals((String)"A truncate function with variable widths should be usable on dataframe columns", (long)rumRows, (long)numNonZero);
    }

    @Test
    public void testWidthAcceptsShortAndByte() {
        Assert.assertEquals((String)"Short types should be usable for the width field", (Object)0L, (Object)this.scalarSql("SELECT system.truncate(5S, 1L)", new Object[0]));
        Assert.assertEquals((String)"Byte types should be allowed for the width field", (Object)0, (Object)this.scalarSql("SELECT system.truncate(5Y, 1)", new Object[0]));
    }

    @Test
    public void testWrongNumberOfArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate()", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (): Wrong number of inputs (expected width and value)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(1)", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (int): Wrong number of inputs (expected width and value)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(1, 1L, 1)", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (int, bigint, int): Wrong number of inputs (expected width and value)");
    }

    @Test
    public void testInvalidTypesCannotBeUsedForWidth() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(CAST('12.34' as DECIMAL(9, 2)), 10)", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (decimal(9,2), int): Expected truncation width to be tinyint, shortint or int");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate('5', 10)", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (string, int): Expected truncation width to be tinyint, shortint or int");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(INTERVAL '100-00' YEAR TO MONTH, 10)", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (interval year to month, int): Expected truncation width to be tinyint, shortint or int");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(CAST('11 23:4:0' AS INTERVAL DAY TO SECOND), 10)", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (interval day to second, int): Expected truncation width to be tinyint, shortint or int");
    }

    @Test
    public void testInvalidTypesForTruncationColumn() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(10, cast(12.3456 as float))", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (int, float): Expected truncation col to be tinyint, shortint, int, bigint, decimal, string, or binary");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(10, cast(12.3456 as double))", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (int, double): Expected truncation col to be tinyint, shortint, int, bigint, decimal, string, or binary");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(10, true)", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (int, boolean): Expected truncation col to be tinyint, shortint, int, bigint, decimal, string, or binary");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(10, map(1, 1))", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (int, map<int,int>): Expected truncation col to be tinyint, shortint, int, bigint, decimal, string, or binary");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(10, array(1L))", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (int, array<bigint>): Expected truncation col to be tinyint, shortint, int, bigint, decimal, string, or binary");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(10, INTERVAL '100-00' YEAR TO MONTH)", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (int, interval year to month): Expected truncation col to be tinyint, shortint, int, bigint, decimal, string, or binary");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.truncate(10, CAST('11 23:4:0' AS INTERVAL DAY TO SECOND))", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'truncate' cannot process input: (int, interval day to second): Expected truncation col to be tinyint, shortint, int, bigint, decimal, string, or binary");
    }

    @Test
    public void testMagicFunctionsResolveForTinyIntAndSmallIntWidths() {
        String tinyIntWidthExplain = (String)this.scalarSql("EXPLAIN EXTENDED SELECT system.truncate(1Y, 6)", new Object[0]);
        ((AbstractStringAssert)Assertions.assertThat((String)tinyIntWidthExplain).contains(new CharSequence[]{"cast(1 as int)"})).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.TruncateFunction$TruncateInt"});
        String smallIntWidth = (String)this.scalarSql("EXPLAIN EXTENDED SELECT system.truncate(5S, 6L)", new Object[0]);
        ((AbstractStringAssert)Assertions.assertThat((String)smallIntWidth).contains(new CharSequence[]{"cast(5 as int)"})).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.TruncateFunction$TruncateBigInt"});
    }

    @Test
    public void testThatMagicFunctionsAreInvoked() {
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED select system.truncate(5, 6Y)", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.TruncateFunction$TruncateTinyInt"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED select system.truncate(5, 6S)", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.TruncateFunction$TruncateSmallInt"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED select system.truncate(5, 6)", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.TruncateFunction$TruncateInt"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.truncate(5, 6L)", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.TruncateFunction$TruncateBigInt"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.truncate(5, 'abcdefg')", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.TruncateFunction$TruncateString"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.truncate(5, 12.34)", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.TruncateFunction$TruncateDecimal"});
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.truncate(4, X'0102030405060708')", new Object[0])).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class org.apache.iceberg.spark.functions.TruncateFunction$TruncateBinary"});
    }

    private String asBytesLiteral(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        return "X'" + BaseEncoding.base16().encode(bytes) + "'";
    }
}

