/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.SparkCatalogTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.functions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class UnpartitionedWritesTestBase
extends SparkCatalogTestBase {
    public UnpartitionedWritesTestBase(String catalogName, String implementation, Map<String, String> config) {
        super(catalogName, implementation, config);
    }

    @Before
    public void createTables() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, 'a'), (2, 'b'), (3, 'c')", this.tableName);
    }

    @After
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @Test
    public void testInsertAppend() {
        Assert.assertEquals((String)"Should have 3 rows", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget()));
        this.sql("INSERT INTO %s VALUES (4, 'd'), (5, 'e')", this.commitTarget());
        Assert.assertEquals((String)"Should have 5 rows after insert", (Object)5L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget()));
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @Test
    public void testInsertOverwrite() {
        Assert.assertEquals((String)"Should have 3 rows", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget()));
        this.sql("INSERT OVERWRITE %s VALUES (4, 'd'), (5, 'e')", this.commitTarget());
        Assert.assertEquals((String)"Should have 2 rows after overwrite", (Object)2L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget()));
        ImmutableList expected = ImmutableList.of((Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @Test
    public void testInsertAppendAtSnapshot() {
        Assume.assumeTrue((boolean)this.tableName.equals(this.commitTarget()));
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        String prefix = "snapshot_id_";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("INSERT INTO %s.%s VALUES (4, 'd'), (5, 'e')", this.tableName, prefix + snapshotId)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot write to table at a specific snapshot");
    }

    @Test
    public void testInsertOverwriteAtSnapshot() {
        Assume.assumeTrue((boolean)this.tableName.equals(this.commitTarget()));
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        String prefix = "snapshot_id_";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("INSERT OVERWRITE %s.%s VALUES (4, 'd'), (5, 'e')", this.tableName, prefix + snapshotId)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot write to table at a specific snapshot");
    }

    @Test
    public void testDataFrameV2Append() throws NoSuchTableException {
        Assert.assertEquals((String)"Should have 3 rows", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget()));
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.commitTarget()).append();
        Assert.assertEquals((String)"Should have 5 rows after insert", (Object)5L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget()));
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @Test
    public void testDataFrameV2DynamicOverwrite() throws NoSuchTableException {
        Assert.assertEquals((String)"Should have 3 rows", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget()));
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.commitTarget()).overwritePartitions();
        Assert.assertEquals((String)"Should have 2 rows after overwrite", (Object)2L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget()));
        ImmutableList expected = ImmutableList.of((Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @Test
    public void testDataFrameV2Overwrite() throws NoSuchTableException {
        Assert.assertEquals((String)"Should have 3 rows", (Object)3L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget()));
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.commitTarget()).overwrite(functions.col((String)"id").$less$eq((Object)3));
        Assert.assertEquals((String)"Should have 2 rows after overwrite", (Object)2L, (Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget()));
        ImmutableList expected = ImmutableList.of((Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }
}

