/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;

public final class TaskCheckHelper {
    private TaskCheckHelper() {
    }

    public static void assertEquals(ScanTaskGroup<FileScanTask> expected, ScanTaskGroup<FileScanTask> actual) {
        List<FileScanTask> expectedTasks = TaskCheckHelper.getFileScanTasksInFilePathOrder(expected);
        List<FileScanTask> actualTasks = TaskCheckHelper.getFileScanTasksInFilePathOrder(actual);
        ((ListAssert)Assertions.assertThat(actualTasks).as("The number of file scan tasks should match", new Object[0])).hasSameSizeAs(expectedTasks);
        for (int i = 0; i < expectedTasks.size(); ++i) {
            FileScanTask expectedTask = expectedTasks.get(i);
            FileScanTask actualTask = actualTasks.get(i);
            TaskCheckHelper.assertEquals(expectedTask, actualTask);
        }
    }

    public static void assertEquals(FileScanTask expected, FileScanTask actual) {
        TaskCheckHelper.assertEquals((DataFile)expected.file(), (DataFile)actual.file());
        ((ObjectAssert)Assertions.assertThat((Object)actual.spec()).as("PartitionSpec doesn't match", new Object[0])).isEqualTo((Object)expected.spec());
        ((AbstractLongAssert)Assertions.assertThat((long)actual.start()).as("starting position doesn't match", new Object[0])).isEqualTo(expected.start());
        ((AbstractLongAssert)Assertions.assertThat((long)actual.start()).as("the number of bytes to scan doesn't match", new Object[0])).isEqualTo(expected.start());
        ((AbstractStringAssert)Assertions.assertThat((String)actual.residual().toString()).as("Residual expression doesn't match", new Object[0])).isEqualTo(expected.residual().toString());
    }

    public static void assertEquals(DataFile expected, DataFile actual) {
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)actual.path()).as("Should match the serialized record path", new Object[0])).isEqualTo((Object)expected.path());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actual.format()).as("Should match the serialized record format", new Object[0])).isEqualTo((Object)expected.format());
        ((ObjectAssert)Assertions.assertThat((Object)actual.partition().get(0, Object.class)).as("Should match the serialized record partition", new Object[0])).isEqualTo(expected.partition().get(0, Object.class));
        ((AbstractLongAssert)Assertions.assertThat((long)actual.recordCount()).as("Should match the serialized record count", new Object[0])).isEqualTo(expected.recordCount());
        ((AbstractLongAssert)Assertions.assertThat((long)actual.fileSizeInBytes()).as("Should match the serialized record size", new Object[0])).isEqualTo(expected.fileSizeInBytes());
        ((MapAssert)Assertions.assertThat((Map)actual.valueCounts()).as("Should match the serialized record value counts", new Object[0])).isEqualTo((Object)expected.valueCounts());
        ((MapAssert)Assertions.assertThat((Map)actual.nullValueCounts()).as("Should match the serialized record null value counts", new Object[0])).isEqualTo((Object)expected.nullValueCounts());
        ((MapAssert)Assertions.assertThat((Map)actual.lowerBounds()).as("Should match the serialized record lower bounds", new Object[0])).isEqualTo((Object)expected.lowerBounds());
        ((MapAssert)Assertions.assertThat((Map)actual.upperBounds()).as("Should match the serialized record upper bounds", new Object[0])).isEqualTo((Object)expected.upperBounds());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actual.keyMetadata()).as("Should match the serialized record key metadata", new Object[0])).isEqualTo((Object)expected.keyMetadata());
        ((ListAssert)Assertions.assertThat((List)actual.splitOffsets()).as("Should match the serialized record offsets", new Object[0])).isEqualTo((Object)expected.splitOffsets());
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)actual.keyMetadata()).as("Should match the serialized record offsets", new Object[0])).isEqualTo((Object)expected.keyMetadata());
    }

    private static List<FileScanTask> getFileScanTasksInFilePathOrder(ScanTaskGroup<FileScanTask> taskGroup) {
        return taskGroup.tasks().stream().sorted(Comparator.comparing(o -> ((DataFile)o.file()).path().toString() + "##" + o.start())).collect(Collectors.toList());
    }
}

