/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.Map;
import org.apache.iceberg.KryoHelpers;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.hadoop.HadoopMetricsContext;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.junit.jupiter.api.Test;

public class TestHadoopMetricsContextSerialization {
    @Test
    public void testHadoopMetricsContextKryoSerialization() throws IOException {
        HadoopMetricsContext metricsContext = new HadoopMetricsContext("s3");
        metricsContext.initialize((Map)Maps.newHashMap());
        MetricsContext deserializedMetricContext = (MetricsContext)KryoHelpers.roundTripSerialize(metricsContext);
        deserializedMetricContext.counter("write.bytes", MetricsContext.Unit.BYTES).increment();
    }

    @Test
    public void testHadoopMetricsContextJavaSerialization() throws IOException, ClassNotFoundException {
        HadoopMetricsContext metricsContext = new HadoopMetricsContext("s3");
        metricsContext.initialize((Map)Maps.newHashMap());
        MetricsContext deserializedMetricContext = (MetricsContext)TestHelpers.roundTripSerialize((Object)metricsContext);
        deserializedMetricContext.counter("write.bytes", MetricsContext.Unit.BYTES).increment();
    }
}

