/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.KryoHelpers;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestTableSerialization {
    private static final HadoopTables TABLES = new HadoopTables();
    @Parameter
    private String isObjectStoreEnabled;
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"date", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"double", (Type)Types.DoubleType.get())});
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("date").build();
    private static final SortOrder SORT_ORDER = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("id")).build();
    @TempDir
    private Path temp;
    private Table table;

    @Parameters(name="isObjectStoreEnabled = {0}")
    public static List<String> parameters() {
        return Arrays.asList("true", "false");
    }

    @BeforeEach
    public void initTable() throws IOException {
        ImmutableMap props = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"write.object-storage.enabled", (Object)this.isObjectStoreEnabled);
        File tableLocation = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        Assertions.assertThat((boolean)tableLocation.delete()).isTrue();
        this.table = TABLES.create(SCHEMA, SPEC, SORT_ORDER, (Map)props, tableLocation.toString());
    }

    @TestTemplate
    public void testCloseSerializableTableKryoSerialization() throws Exception {
        for (Table tbl : this.tables()) {
            Table spyTable = (Table)Mockito.spy((Object)tbl);
            FileIO spyIO = (FileIO)Mockito.spy((Object)tbl.io());
            Mockito.when((Object)spyTable.io()).thenReturn((Object)spyIO);
            Table serializableTable = SerializableTableWithSize.copyOf((Table)spyTable);
            Table serializableTableCopy = (Table)Mockito.spy((Object)KryoHelpers.roundTripSerialize(serializableTable));
            FileIO spyFileIOCopy = (FileIO)Mockito.spy((Object)serializableTableCopy.io());
            Mockito.when((Object)serializableTableCopy.io()).thenReturn((Object)spyFileIOCopy);
            ((AutoCloseable)serializableTable).close();
            ((AutoCloseable)serializableTableCopy).close();
            ((FileIO)Mockito.verify((Object)spyIO, (VerificationMode)Mockito.never())).close();
            ((FileIO)Mockito.verify((Object)spyFileIOCopy, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @TestTemplate
    public void testCloseSerializableTableJavaSerialization() throws Exception {
        for (Table tbl : this.tables()) {
            Table spyTable = (Table)Mockito.spy((Object)tbl);
            FileIO spyIO = (FileIO)Mockito.spy((Object)tbl.io());
            Mockito.when((Object)spyTable.io()).thenReturn((Object)spyIO);
            Table serializableTable = SerializableTableWithSize.copyOf((Table)spyTable);
            Table serializableTableCopy = (Table)Mockito.spy((Object)((Table)TestHelpers.roundTripSerialize((Object)serializableTable)));
            FileIO spyFileIOCopy = (FileIO)Mockito.spy((Object)serializableTableCopy.io());
            Mockito.when((Object)serializableTableCopy.io()).thenReturn((Object)spyFileIOCopy);
            ((AutoCloseable)serializableTable).close();
            ((AutoCloseable)serializableTableCopy).close();
            ((FileIO)Mockito.verify((Object)spyIO, (VerificationMode)Mockito.never())).close();
            ((FileIO)Mockito.verify((Object)spyFileIOCopy, (VerificationMode)Mockito.times((int)1))).close();
        }
    }

    @TestTemplate
    public void testSerializableTableKryoSerialization() throws IOException {
        Table serializableTable = SerializableTableWithSize.copyOf((Table)this.table);
        TestHelpers.assertSerializedAndLoadedMetadata((Table)this.table, (Table)KryoHelpers.roundTripSerialize(serializableTable));
    }

    @TestTemplate
    public void testSerializableMetadataTableKryoSerialization() throws IOException {
        for (MetadataTableType type : MetadataTableType.values()) {
            TableOperations ops = ((HasTableOperations)this.table).operations();
            Table metadataTable = MetadataTableUtils.createMetadataTableInstance((TableOperations)ops, (String)this.table.name(), (String)"meta", (MetadataTableType)type);
            Table serializableMetadataTable = SerializableTableWithSize.copyOf((Table)metadataTable);
            TestHelpers.assertSerializedAndLoadedMetadata((Table)metadataTable, (Table)KryoHelpers.roundTripSerialize(serializableMetadataTable));
        }
    }

    @TestTemplate
    public void testSerializableTransactionTableKryoSerialization() throws IOException {
        Transaction txn = this.table.newTransaction();
        txn.updateProperties().set("k1", "v1").commit();
        Table txnTable = txn.table();
        Table serializableTxnTable = SerializableTableWithSize.copyOf((Table)txnTable);
        TestHelpers.assertSerializedMetadata((Table)txnTable, (Table)KryoHelpers.roundTripSerialize(serializableTxnTable));
    }

    private List<Table> tables() {
        ArrayList tables = Lists.newArrayList();
        tables.add(this.table);
        for (MetadataTableType type : MetadataTableType.values()) {
            Table metadataTable = MetadataTableUtils.createMetadataTableInstance((Table)this.table, (MetadataTableType)type);
            tables.add(metadataTable);
        }
        return tables;
    }
}

