/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.spark.sql.SparkSession;

public class SystemFunctionPushDownHelper {
    public static final Types.StructType STRUCT = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"ts", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)3, (String)"data", (Type)Types.StringType.get())});

    private SystemFunctionPushDownHelper() {
    }

    public static void createUnpartitionedTable(SparkSession spark, String tableName) {
        SystemFunctionPushDownHelper.sql(spark, "CREATE TABLE %s (id BIGINT, ts TIMESTAMP, data STRING) USING iceberg", tableName);
        SystemFunctionPushDownHelper.insertRecords(spark, tableName);
    }

    public static void createPartitionedTable(SparkSession spark, String tableName, String partitionCol) {
        SystemFunctionPushDownHelper.sql(spark, "CREATE TABLE %s (id BIGINT, ts TIMESTAMP, data STRING) USING iceberg PARTITIONED BY (%s)", tableName, partitionCol);
        SystemFunctionPushDownHelper.insertRecords(spark, tableName);
    }

    private static void insertRecords(SparkSession spark, String tableName) {
        SystemFunctionPushDownHelper.sql(spark, "ALTER TABLE %s SET TBLPROPERTIES('%s' %s)", tableName, "read.split.target-size", "10");
        SystemFunctionPushDownHelper.sql(spark, "INSERT INTO TABLE %s VALUES %s", tableName, "(0, CAST('2017-11-22T09:20:44.294658+00:00' AS TIMESTAMP), 'data-0')");
        SystemFunctionPushDownHelper.sql(spark, "INSERT INTO TABLE %s VALUES %s", tableName, "(1, CAST('2017-11-22T07:15:34.582910+00:00' AS TIMESTAMP), 'data-1')");
        SystemFunctionPushDownHelper.sql(spark, "INSERT INTO TABLE %s VALUES %s", tableName, "(2, CAST('2017-11-22T06:02:09.243857+00:00' AS TIMESTAMP), 'data-2')");
        SystemFunctionPushDownHelper.sql(spark, "INSERT INTO TABLE %s VALUES %s", tableName, "(3, CAST('2017-11-22T03:10:11.134509+00:00' AS TIMESTAMP), 'data-3')");
        SystemFunctionPushDownHelper.sql(spark, "INSERT INTO TABLE %s VALUES %s", tableName, "(4, CAST('2017-11-22T00:34:00.184671+00:00' AS TIMESTAMP), 'data-4')");
        SystemFunctionPushDownHelper.sql(spark, "INSERT INTO TABLE %s VALUES %s", tableName, "(5, CAST('2018-12-21T22:20:08.935889+00:00' AS TIMESTAMP), 'material-5')");
        SystemFunctionPushDownHelper.sql(spark, "INSERT INTO TABLE %s VALUES %s", tableName, "(6, CAST('2018-12-21T21:55:30.589712+00:00' AS TIMESTAMP), 'material-6')");
        SystemFunctionPushDownHelper.sql(spark, "INSERT INTO TABLE %s VALUES %s", tableName, "(7, CAST('2018-12-21T17:31:14.532797+00:00' AS TIMESTAMP), 'material-7')");
        SystemFunctionPushDownHelper.sql(spark, "INSERT INTO TABLE %s VALUES %s", tableName, "(8, CAST('2018-12-21T15:21:51.237521+00:00' AS TIMESTAMP), 'material-8')");
        SystemFunctionPushDownHelper.sql(spark, "INSERT INTO TABLE %s VALUES %s", tableName, "(9, CAST('2018-12-21T15:02:15.230570+00:00' AS TIMESTAMP), 'material-9')");
    }

    public static int timestampStrToYearOrdinal(String timestamp) {
        return DateTimeUtil.microsToYears((long)DateTimeUtil.isoTimestamptzToMicros((String)timestamp));
    }

    public static int timestampStrToMonthOrdinal(String timestamp) {
        return DateTimeUtil.microsToMonths((long)DateTimeUtil.isoTimestamptzToMicros((String)timestamp));
    }

    public static int timestampStrToDayOrdinal(String timestamp) {
        return DateTimeUtil.microsToDays((long)DateTimeUtil.isoTimestamptzToMicros((String)timestamp));
    }

    public static int timestampStrToHourOrdinal(String timestamp) {
        return DateTimeUtil.microsToHours((long)DateTimeUtil.isoTimestamptzToMicros((String)timestamp));
    }

    private static void sql(SparkSession spark, String sqlFormat, Object ... args) {
        spark.sql(String.format(sqlFormat, args));
    }
}

