/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.util.PropertyUtil;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestBaseWithCatalog
extends TestBase {
    protected static File warehouse = null;
    @TempDir
    protected File temp;
    @Parameter(index=0)
    protected String catalogName;
    @Parameter(index=1)
    protected String implementation;
    @Parameter(index=2)
    protected Map<String, String> catalogConfig;
    protected Catalog validationCatalog;
    protected SupportsNamespaces validationNamespaceCatalog;
    protected TableIdentifier tableIdent = TableIdentifier.of((Namespace)Namespace.of((String[])new String[]{"default"}), (String)"table");
    protected String tableName;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}")
    protected static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties()}};
    }

    @BeforeAll
    public static void createWarehouse() throws IOException {
        warehouse = File.createTempFile("warehouse", null);
        Assertions.assertThat((boolean)warehouse.delete()).isTrue();
    }

    @AfterAll
    public static void dropWarehouse() throws IOException {
        if (warehouse != null && warehouse.exists()) {
            Path warehousePath = new Path(warehouse.getAbsolutePath());
            FileSystem fs = warehousePath.getFileSystem((Configuration)hiveConf);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)fs.delete(warehousePath, true)).as("Failed to delete " + warehousePath, new Object[0])).isTrue();
        }
    }

    @BeforeEach
    public void before() {
        this.validationCatalog = this.catalogName.equals("testhadoop") ? new HadoopCatalog(spark.sessionState().newHadoopConf(), "file:" + warehouse) : catalog;
        this.validationNamespaceCatalog = (SupportsNamespaces)this.validationCatalog;
        spark.conf().set("spark.sql.catalog." + this.catalogName, this.implementation);
        this.catalogConfig.forEach((key, value) -> spark.conf().set("spark.sql.catalog." + this.catalogName + "." + key, value));
        if ("hadoop".equalsIgnoreCase(this.catalogConfig.get("type"))) {
            spark.conf().set("spark.sql.catalog." + this.catalogName + ".warehouse", "file:" + warehouse);
        }
        this.tableName = (this.catalogName.equals("spark_catalog") ? "" : this.catalogName + ".") + "default.table";
        this.sql("CREATE NAMESPACE IF NOT EXISTS default", new Object[0]);
    }

    protected String tableName(String name) {
        return (this.catalogName.equals("spark_catalog") ? "" : this.catalogName + ".") + "default." + name;
    }

    protected String commitTarget() {
        return this.tableName;
    }

    protected String selectTarget() {
        return this.tableName;
    }

    protected boolean cachingCatalogEnabled() {
        return PropertyUtil.propertyAsBoolean(this.catalogConfig, (String)"cache-enabled", (boolean)true);
    }

    protected void configurePlanningMode(PlanningMode planningMode) {
        this.configurePlanningMode(this.tableName, planningMode);
    }

    protected void configurePlanningMode(String table, PlanningMode planningMode) {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s' '%s', '%s' '%s')", table, "read.data-planning-mode", planningMode.modeName(), "read.delete-planning-mode", planningMode.modeName());
    }
}

