/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.spark.BaseCatalog;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestSparkCatalogOperations
extends CatalogTestBase {
    @BeforeEach
    public void createTable() {
        this.sql("CREATE TABLE %s (id bigint NOT NULL, data string) USING iceberg", this.tableName);
    }

    @AfterEach
    public void removeTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testAlterTable() throws NoSuchTableException {
        BaseCatalog catalog = (BaseCatalog)spark.sessionState().catalogManager().catalog(this.catalogName);
        Identifier identifier = Identifier.of((String[])this.tableIdent.namespace().levels(), (String)this.tableIdent.name());
        String fieldName = "location";
        String propsKey = "note";
        String propsValue = "jazz";
        Table table = catalog.alterTable(identifier, new TableChange[]{TableChange.addColumn((String[])new String[]{fieldName}, (DataType)DataTypes.StringType, (boolean)true), TableChange.setProperty((String)propsKey, (String)propsValue)});
        ((ObjectAssert)Assertions.assertThat((Object)table).as("Should return updated table", new Object[0])).isNotNull();
        StructField expectedField = DataTypes.createStructField((String)fieldName, (DataType)DataTypes.StringType, (boolean)true);
        ((ObjectAssert)Assertions.assertThat((Object)table.schema().fields()[2]).as("Adding a column to a table should return the updated table with the new column", new Object[0])).isEqualTo((Object)expectedField);
        ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Adding a property to a table should return the updated table with the new property with the new correct value", new Object[0])).containsEntry((Object)propsKey, (Object)propsValue);
    }

    @TestTemplate
    public void testInvalidateTable() {
        this.sql("SELECT count(1) FROM %s", this.tableName);
        Catalog anotherCatalog = this.validationCatalog;
        Schema schema = anotherCatalog.loadTable(this.tableIdent).schema();
        anotherCatalog.dropTable(this.tableIdent);
        anotherCatalog.createTable(this.tableIdent, schema);
        this.sql("REFRESH TABLE %s", this.tableName);
        this.sql("SELECT count(1) FROM %s", this.tableName);
    }
}

