/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Map;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.iceberg.spark.SparkWriteRequirements;
import org.apache.iceberg.spark.TestBaseWithCatalog;
import org.apache.spark.sql.connector.distributions.ClusteredDistribution;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.distributions.OrderedDistribution;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.SortDirection;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;

public class TestSparkDistributionAndOrderingUtil
extends TestBaseWithCatalog {
    private static final Distribution UNSPECIFIED_DISTRIBUTION = Distributions.unspecified();
    private static final Distribution FILE_CLUSTERED_DISTRIBUTION = Distributions.clustered((Expression[])new Expression[]{Expressions.column((String)MetadataColumns.FILE_PATH.name())});
    private static final Distribution SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION = Distributions.clustered((Expression[])new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition")});
    private static final Distribution SPEC_ID_PARTITION_FILE_CLUSTERED_DISTRIBUTION = Distributions.clustered((Expression[])new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.column((String)MetadataColumns.FILE_PATH.name())});
    private static final SortOrder[] EMPTY_ORDERING = new SortOrder[0];
    private static final SortOrder[] FILE_POSITION_ORDERING = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING)};
    private static final SortOrder[] SPEC_ID_PARTITION_ORDERING = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING)};
    private static final SortOrder[] SPEC_ID_PARTITION_FILE_ORDERING = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING)};
    private static final SortOrder[] SPEC_ID_PARTITION_FILE_POSITION_ORDERING = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING)};

    @AfterEach
    public void dropTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testDefaultWriteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkWriteDistributionAndOrdering(table, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashWriteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "hash").commit();
        this.checkWriteDistributionAndOrdering(table, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangeWriteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "range").commit();
        this.checkWriteDistributionAndOrdering(table, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultWriteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testHashWriteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkWriteDistributionAndOrdering(table, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testRangeWriteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultWritePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashWritePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "hash").commit();
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangeWritePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "range").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultWritePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testHashWritePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testRangeWritePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkWriteDistributionAndOrdering(table, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteDeleteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNoneCopyOnWriteDeleteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashCopyOnWriteDeleteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangeCopyOnWriteDeleteUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])FILE_POSITION_ORDERING);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteDeleteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testNoneCopyOnWriteDeleteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testHashCopyOnWriteDeleteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testRangeCopyOnWriteDeleteUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteDeletePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNoneCopyOnWriteDeletePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashCopyOnWriteDeletePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangeCopyOnWriteDeletePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteDeletePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testNoneCopyOnWriteDeletePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testHashCopyOnWriteDeletePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testRangeCopyOnWriteDeletePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNoneCopyOnWriteUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashCopyOnWriteUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangeCopyOnWriteUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])FILE_POSITION_ORDERING);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testNoneCopyOnWriteUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testHashCopyOnWriteUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testRangeCopyOnWriteUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNoneCopyOnWriteUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashCopyOnWriteUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangeCopyOnWriteUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testNoneCopyOnWriteUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testHashCopyOnWriteUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testRangeCopyOnWriteUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNoneCopyOnWriteMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashCopyOnWriteMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangeCopyOnWriteMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testNoneCopyOnWriteMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testHashCopyOnWriteMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testRangeCopyOnWriteMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNoneCopyOnWriteMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashCopyOnWriteMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangeCopyOnWriteMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultCopyOnWriteMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testNoneCopyOnWriteMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testHashCopyOnWriteMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testRangeCopyOnWriteMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedOrdering);
        this.checkCopyOnWriteDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultPositionDeltaDeleteUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.disableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_FILE_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_FILE_CLUSTERED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNonePositionDeltaDeleteUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        this.disableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashPositionDeltaDeleteUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        this.disableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_FILE_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_FILE_CLUSTERED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangePositionDeltaDeleteUnpartitionedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        this.disableFanoutWriters(table);
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])SPEC_ID_PARTITION_FILE_ORDERING);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultPositionDeltaDeletePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.disableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNonePositionDeltaDeletePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "none").commit();
        this.disableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashPositionDeltaDeletePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "hash").commit();
        this.disableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, SPEC_ID_PARTITION_CLUSTERED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangePositionDeltaDeletePartitionedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.distribution-mode", "range").commit();
        this.disableFanoutWriters(table);
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])SPEC_ID_PARTITION_ORDERING);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.DELETE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultPositionDeltaUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.disableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, SPEC_ID_PARTITION_FILE_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, SPEC_ID_PARTITION_FILE_CLUSTERED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNonePositionDeltaUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        this.disableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashPositionDeltaUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        this.disableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, SPEC_ID_PARTITION_FILE_CLUSTERED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, SPEC_ID_PARTITION_FILE_CLUSTERED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangePositionDeltaUpdateUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        this.disableFanoutWriters(table);
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])SPEC_ID_PARTITION_FILE_ORDERING);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultPositionDeltaUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, SPEC_ID_PARTITION_FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testNonePositionDeltaUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testHashPositionDeltaUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, SPEC_ID_PARTITION_FILE_CLUSTERED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testRangePositionDeltaUpdateUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        SortOrder[] expectedDistributionOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedDistributionOrdering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultPositionDeltaUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNonePositionDeltaUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashPositionDeltaUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangePositionDeltaUpdatePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedDistributionOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedDistributionOrdering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultPositionDeltaUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testNonePositionDeltaUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        table.updateProperties().set("write.update.distribution-mode", "none").commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testHashPositionDeltaUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        table.updateProperties().set("write.update.distribution-mode", "hash").commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testRangePositionDeltaUpdatePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        table.updateProperties().set("write.update.distribution-mode", "range").commit();
        SortOrder[] expectedDistributionOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedDistributionOrdering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.UPDATE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultPositionDeltaMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.column((String)MetadataColumns.FILE_PATH.name())};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNonePositionDeltaMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        this.disableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashPositionDeltaMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.column((String)MetadataColumns.FILE_PATH.name())};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangePositionDeltaMergeUnpartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedDistributionOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedDistributionOrdering);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, SPEC_ID_PARTITION_FILE_POSITION_ORDERING);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testDefaultPositionDeltaMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.column((String)MetadataColumns.FILE_PATH.name())};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testNonePositionDeltaMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testHashPositionDeltaMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.column((String)MetadataColumns.FILE_PATH.name())};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testRangePositionDeltaMergeUnpartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        ((ReplaceSortOrder)((ReplaceSortOrder)table.replaceSortOrder().asc("id")).asc("data")).commit();
        SortOrder[] expectedDistributionOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedDistributionOrdering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"data"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultPositionDeltaMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNonePositionDeltaMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testHashPositionDeltaMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        this.disableFanoutWriters(table);
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.days((String)"ts")};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testRangePositionDeltaMergePartitionedUnsortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        this.disableFanoutWriters(table);
        SortOrder[] expectedDistributionOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedDistributionOrdering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.days((String)"ts"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
        this.enableFanoutWriters(table);
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, EMPTY_ORDERING);
    }

    @TestTemplate
    public void testNonePositionDeltaMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "none").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().desc("id")).commit();
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.DESCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, UNSPECIFIED_DISTRIBUTION, expectedOrdering);
    }

    @TestTemplate
    public void testDefaultPositionDeltaMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testHashPositionDeltaMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, bucket(8, data))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "hash").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        Expression[] expectedClustering = new Expression[]{Expressions.column((String)MetadataColumns.SPEC_ID.name()), Expressions.column((String)"_partition"), Expressions.identity((String)"date"), Expressions.bucket((int)8, (String[])new String[]{"data"})};
        ClusteredDistribution expectedDistribution = Distributions.clustered((Expression[])expectedClustering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.bucket((int)8, (String[])new String[]{"data"}), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    @TestTemplate
    public void testRangePositionDeltaMergePartitionedSortedTable() {
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date)", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.merge.distribution-mode", "range").commit();
        ((ReplaceSortOrder)table.replaceSortOrder().asc("id")).commit();
        SortOrder[] expectedDistributionOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        OrderedDistribution expectedDistribution = Distributions.ordered((SortOrder[])expectedDistributionOrdering);
        SortOrder[] expectedOrdering = new SortOrder[]{Expressions.sort((Expression)Expressions.column((String)MetadataColumns.SPEC_ID.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"_partition"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.FILE_PATH.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)MetadataColumns.ROW_POSITION.name()), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"date"), (SortDirection)SortDirection.ASCENDING), Expressions.sort((Expression)Expressions.column((String)"id"), (SortDirection)SortDirection.ASCENDING)};
        this.checkPositionDeltaDistributionAndOrdering(table, RowLevelOperation.Command.MERGE, (Distribution)expectedDistribution, expectedOrdering);
    }

    private void checkWriteDistributionAndOrdering(Table table, Distribution expectedDistribution, SortOrder[] expectedOrdering) {
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        SparkWriteRequirements requirements = writeConf.writeRequirements();
        Distribution distribution = requirements.distribution();
        ((ObjectAssert)Assertions.assertThat((Object)distribution).as("Distribution must match", new Object[0])).isEqualTo((Object)expectedDistribution);
        Object[] ordering = requirements.ordering();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])ordering).as("Ordering must match", new Object[0])).isEqualTo((Object)expectedOrdering);
    }

    private void checkCopyOnWriteDistributionAndOrdering(Table table, RowLevelOperation.Command command, Distribution expectedDistribution, SortOrder[] expectedOrdering) {
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        SparkWriteRequirements requirements = writeConf.copyOnWriteRequirements(command);
        Distribution distribution = requirements.distribution();
        ((ObjectAssert)Assertions.assertThat((Object)distribution).as("Distribution must match", new Object[0])).isEqualTo((Object)expectedDistribution);
        Object[] ordering = requirements.ordering();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])ordering).as("Ordering must match", new Object[0])).isEqualTo((Object)expectedOrdering);
    }

    private void checkPositionDeltaDistributionAndOrdering(Table table, RowLevelOperation.Command command, Distribution expectedDistribution, SortOrder[] expectedOrdering) {
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        SparkWriteRequirements requirements = writeConf.positionDeltaRequirements(command);
        Distribution distribution = requirements.distribution();
        ((ObjectAssert)Assertions.assertThat((Object)distribution).as("Distribution must match", new Object[0])).isEqualTo((Object)expectedDistribution);
        Object[] ordering = requirements.ordering();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])ordering).as("Ordering must match", new Object[0])).isEqualTo((Object)expectedOrdering);
    }

    private void disableFanoutWriters(Table table) {
        table.updateProperties().set("write.spark.fanout.enabled", "false").commit();
    }

    private void enableFanoutWriters(Table table) {
        table.updateProperties().set("write.spark.fanout.enabled", "true").commit();
    }
}

