/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.io.IOException;
import java.util.List;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.MetadataAttribute;
import org.apache.spark.sql.catalyst.types.DataTypeUtils;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class TestSparkSchemaUtil {
    private static final Schema TEST_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
    private static final Schema TEST_SCHEMA_WITH_METADATA_COLS = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), MetadataColumns.FILE_PATH, MetadataColumns.ROW_POSITION});

    @Test
    public void testEstimateSizeMaxValue() throws IOException {
        ((AbstractLongAssert)Assertions.assertThat((long)SparkSchemaUtil.estimateSize(null, (long)Long.MAX_VALUE)).as("estimateSize returns Long max value", new Object[0])).isEqualTo(Long.MAX_VALUE);
    }

    @Test
    public void testEstimateSizeWithOverflow() throws IOException {
        long tableSize = SparkSchemaUtil.estimateSize((StructType)SparkSchemaUtil.convert((Schema)TEST_SCHEMA), (long)0x7FFFFFFFFFFFFFFEL);
        ((AbstractLongAssert)Assertions.assertThat((long)tableSize).as("estimateSize handles overflow", new Object[0])).isEqualTo(Long.MAX_VALUE);
    }

    @Test
    public void testEstimateSize() throws IOException {
        long tableSize = SparkSchemaUtil.estimateSize((StructType)SparkSchemaUtil.convert((Schema)TEST_SCHEMA), (long)1L);
        ((AbstractLongAssert)Assertions.assertThat((long)tableSize).as("estimateSize matches with expected approximation", new Object[0])).isEqualTo(24L);
    }

    @Test
    public void testSchemaConversionWithMetaDataColumnSchema() {
        StructType structType = SparkSchemaUtil.convert((Schema)TEST_SCHEMA_WITH_METADATA_COLS);
        List attrRefs = JavaConverters.seqAsJavaList((Seq)DataTypeUtils.toAttributes((StructType)structType));
        for (AttributeReference attrRef : attrRefs) {
            if (MetadataColumns.isMetadataColumn((String)attrRef.name())) {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)MetadataAttribute.unapply((AttributeReference)attrRef).isDefined()).as("metadata columns should have __metadata_col in attribute metadata", new Object[0])).isTrue();
                continue;
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)MetadataAttribute.unapply((AttributeReference)attrRef).isDefined()).as("non metadata columns should not have __metadata_col in attribute metadata", new Object[0])).isFalse();
        }
    }
}

