/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.SparkConfParser;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.iceberg.spark.TestBaseWithCatalog;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestSparkWriteConf
extends TestBaseWithCatalog {
    @Override
    @BeforeEach
    public void before() {
        super.before();
        this.sql("CREATE TABLE %s (id BIGINT, data STRING, date DATE, ts TIMESTAMP) USING iceberg PARTITIONED BY (date, days(ts))", this.tableName);
    }

    @AfterEach
    public void after() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testDurationConf() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        String confName = "spark.sql.iceberg.some-duration-conf";
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)confName, (Object)"10s"), () -> {
            SparkConfParser parser = new SparkConfParser(spark, table, (Map)ImmutableMap.of());
            Duration duration = ((SparkConfParser.DurationConfParser)parser.durationConf().sessionConf(confName)).parseOptional();
            Assertions.assertThat((Duration)duration).hasSeconds(10L);
        });
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)confName, (Object)"2m"), () -> {
            SparkConfParser parser = new SparkConfParser(spark, table, (Map)ImmutableMap.of());
            Duration duration = ((SparkConfParser.DurationConfParser)parser.durationConf().sessionConf(confName)).parseOptional();
            Assertions.assertThat((Duration)duration).hasMinutes(2L);
        });
    }

    @TestTemplate
    public void testDeleteGranularityDefault() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        DeleteGranularity value = writeConf.deleteGranularity();
        Assertions.assertThat((Comparable)value).isEqualTo((Object)DeleteGranularity.PARTITION);
    }

    @TestTemplate
    public void testDeleteGranularityTableProperty() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.granularity", DeleteGranularity.FILE.toString()).commit();
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        DeleteGranularity value = writeConf.deleteGranularity();
        Assertions.assertThat((Comparable)value).isEqualTo((Object)DeleteGranularity.FILE);
    }

    @TestTemplate
    public void testDeleteGranularityWriteOption() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.granularity", DeleteGranularity.PARTITION.toString()).commit();
        ImmutableMap options = ImmutableMap.of((Object)"delete-granularity", (Object)DeleteGranularity.FILE.toString());
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)options);
        DeleteGranularity value = writeConf.deleteGranularity();
        Assertions.assertThat((Comparable)value).isEqualTo((Object)DeleteGranularity.FILE);
    }

    @TestTemplate
    public void testDeleteGranularityInvalidValue() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.delete.granularity", "invalid").commit();
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((SparkWriteConf)writeConf).deleteGranularity()).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Unknown delete granularity");
    }

    @TestTemplate
    public void testAdvisoryPartitionSize() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        long value1 = writeConf.writeRequirements().advisoryPartitionSize();
        Assertions.assertThat((long)value1).isGreaterThan(0x4000000L).isLessThan(0x80000000L);
        spark.conf().set(SQLConf.ADVISORY_PARTITION_SIZE_IN_BYTES().key(), "2GB");
        long value2 = writeConf.writeRequirements().advisoryPartitionSize();
        Assertions.assertThat((long)value2).isEqualTo(0x80000000L);
        spark.conf().set(SQLConf.ADVISORY_PARTITION_SIZE_IN_BYTES().key(), "10MB");
        long value3 = writeConf.writeRequirements().advisoryPartitionSize();
        Assertions.assertThat((long)value3).isGreaterThan(0xA00000L);
    }

    @TestTemplate
    public void testSparkWriteConfDistributionDefault() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        this.checkMode(DistributionMode.HASH, writeConf);
    }

    @TestTemplate
    public void testSparkWriteConfDistributionModeWithWriteOption() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ImmutableMap writeOptions = ImmutableMap.of((Object)"distribution-mode", (Object)DistributionMode.NONE.modeName());
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)writeOptions);
        this.checkMode(DistributionMode.NONE, writeConf);
    }

    @TestTemplate
    public void testSparkWriteConfDistributionModeWithSessionConfig() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.NONE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
            this.checkMode(DistributionMode.NONE, writeConf);
        });
    }

    @TestTemplate
    public void testSparkWriteConfDistributionModeWithTableProperties() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.updateProperties().set("write.distribution-mode", "none").set("write.delete.distribution-mode", "none").set("write.update.distribution-mode", "none").set("write.merge.distribution-mode", "none").commit();
        SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
        this.checkMode(DistributionMode.NONE, writeConf);
    }

    @TestTemplate
    public void testSparkWriteConfDistributionModeWithTblPropAndSessionConfig() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.NONE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            table.updateProperties().set("write.distribution-mode", "range").set("write.delete.distribution-mode", "range").set("write.update.distribution-mode", "range").set("write.merge.distribution-mode", "range").commit();
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
            this.checkMode(DistributionMode.NONE, writeConf);
        });
    }

    @TestTemplate
    public void testSparkWriteConfDistributionModeWithWriteOptionAndSessionConfig() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.RANGE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            ImmutableMap writeOptions = ImmutableMap.of((Object)"distribution-mode", (Object)DistributionMode.NONE.modeName());
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)writeOptions);
            this.checkMode(DistributionMode.NONE, writeConf);
        });
    }

    @TestTemplate
    public void testSparkWriteConfDistributionModeWithEverything() {
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.iceberg.distribution-mode", (Object)DistributionMode.RANGE.modeName()), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            ImmutableMap writeOptions = ImmutableMap.of((Object)"distribution-mode", (Object)DistributionMode.NONE.modeName());
            table.updateProperties().set("write.distribution-mode", "hash").set("write.delete.distribution-mode", "hash").set("write.update.distribution-mode", "hash").set("write.merge.distribution-mode", "hash").commit();
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)writeOptions);
            this.checkMode(DistributionMode.NONE, writeConf);
        });
    }

    @TestTemplate
    public void testSparkConfOverride() {
        ArrayList propertiesSuites = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Map[]{ImmutableMap.of((Object)"spark.sql.iceberg.compression-codec", (Object)"zstd", (Object)"spark.sql.iceberg.compression-level", (Object)"3"), ImmutableMap.of((Object)"write.format.default", (Object)"parquet", (Object)"write.delete.format.default", (Object)"parquet", (Object)"write.parquet.compression-codec", (Object)"gzip", (Object)"write.delete.parquet.compression-codec", (Object)"snappy"), ImmutableMap.of((Object)"write.delete.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-level", (Object)"3", (Object)"write.delete.parquet.compression-level", (Object)"3")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of((Object)"spark.sql.iceberg.compression-codec", (Object)"zstd", (Object)"spark.sql.iceberg.compression-strategy", (Object)"compression"), ImmutableMap.of((Object)"write.format.default", (Object)"orc", (Object)"write.delete.format.default", (Object)"orc", (Object)"write.orc.compression-codec", (Object)"zlib", (Object)"write.delete.orc.compression-codec", (Object)"snappy"), ImmutableMap.of((Object)"write.delete.orc.compression-codec", (Object)"zstd", (Object)"write.orc.compression-codec", (Object)"zstd", (Object)"write.delete.orc.compression-strategy", (Object)"compression", (Object)"write.orc.compression-strategy", (Object)"compression")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of((Object)"spark.sql.iceberg.compression-codec", (Object)"zstd", (Object)"spark.sql.iceberg.compression-level", (Object)"9"), ImmutableMap.of((Object)"write.format.default", (Object)"avro", (Object)"write.delete.format.default", (Object)"avro", (Object)"write.avro.compression-codec", (Object)"gzip", (Object)"write.delete.avro.compression-codec", (Object)"snappy"), ImmutableMap.of((Object)"write.delete.avro.compression-codec", (Object)"zstd", (Object)"write.avro.compression-codec", (Object)"zstd", (Object)"write.avro.compression-level", (Object)"9", (Object)"write.delete.avro.compression-level", (Object)"9")})});
        for (List propertiesSuite : propertiesSuites) {
            this.testWriteProperties(propertiesSuite);
        }
    }

    @TestTemplate
    public void testDataPropsDefaultsAsDeleteProps() {
        ArrayList propertiesSuites = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"parquet", (Object)"write.delete.format.default", (Object)"parquet", (Object)"write.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-level", (Object)"5"), ImmutableMap.of((Object)"write.delete.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-level", (Object)"5", (Object)"write.delete.parquet.compression-level", (Object)"5")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"orc", (Object)"write.delete.format.default", (Object)"orc", (Object)"write.orc.compression-codec", (Object)"snappy", (Object)"write.orc.compression-strategy", (Object)"speed"), ImmutableMap.of((Object)"write.delete.orc.compression-codec", (Object)"snappy", (Object)"write.orc.compression-codec", (Object)"snappy", (Object)"write.orc.compression-strategy", (Object)"speed", (Object)"write.delete.orc.compression-strategy", (Object)"speed")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"avro", (Object)"write.delete.format.default", (Object)"avro", (Object)"write.avro.compression-codec", (Object)"snappy", (Object)"write.avro.compression-level", (Object)"9"), ImmutableMap.of((Object)"write.delete.avro.compression-codec", (Object)"snappy", (Object)"write.avro.compression-codec", (Object)"snappy", (Object)"write.avro.compression-level", (Object)"9", (Object)"write.delete.avro.compression-level", (Object)"9")})});
        for (List propertiesSuite : propertiesSuites) {
            this.testWriteProperties(propertiesSuite);
        }
    }

    @TestTemplate
    public void testDeleteFileWriteConf() {
        ArrayList propertiesSuites = Lists.newArrayList((Object[])new List[]{Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"parquet", (Object)"write.delete.format.default", (Object)"parquet", (Object)"write.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-level", (Object)"5", (Object)"write.delete.parquet.compression-level", (Object)"6"), ImmutableMap.of((Object)"write.delete.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-codec", (Object)"zstd", (Object)"write.parquet.compression-level", (Object)"5", (Object)"write.delete.parquet.compression-level", (Object)"6")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"orc", (Object)"write.delete.format.default", (Object)"orc", (Object)"write.orc.compression-codec", (Object)"snappy", (Object)"write.orc.compression-strategy", (Object)"speed", (Object)"write.delete.orc.compression-codec", (Object)"zstd", (Object)"write.delete.orc.compression-strategy", (Object)"compression"), ImmutableMap.of((Object)"write.delete.orc.compression-codec", (Object)"zstd", (Object)"write.orc.compression-codec", (Object)"snappy", (Object)"write.orc.compression-strategy", (Object)"speed", (Object)"write.delete.orc.compression-strategy", (Object)"compression")}), Lists.newArrayList((Object[])new Map[]{ImmutableMap.of(), ImmutableMap.of((Object)"write.format.default", (Object)"avro", (Object)"write.delete.format.default", (Object)"avro", (Object)"write.avro.compression-codec", (Object)"snappy", (Object)"write.avro.compression-level", (Object)"9", (Object)"write.delete.avro.compression-codec", (Object)"zstd", (Object)"write.delete.avro.compression-level", (Object)"16"), ImmutableMap.of((Object)"write.delete.avro.compression-codec", (Object)"zstd", (Object)"write.avro.compression-codec", (Object)"snappy", (Object)"write.avro.compression-level", (Object)"9", (Object)"write.delete.avro.compression-level", (Object)"16")})});
        for (List propertiesSuite : propertiesSuites) {
            this.testWriteProperties(propertiesSuite);
        }
    }

    private void testWriteProperties(List<Map<String, String>> propertiesSuite) {
        this.withSQLConf(propertiesSuite.get(0), () -> {
            Table table = this.validationCatalog.loadTable(this.tableIdent);
            Map tableProperties = (Map)propertiesSuite.get(1);
            UpdateProperties updateProperties = table.updateProperties();
            for (Map.Entry entry : tableProperties.entrySet()) {
                updateProperties.set((String)entry.getKey(), (String)entry.getValue());
            }
            updateProperties.commit();
            SparkWriteConf writeConf = new SparkWriteConf(spark, table, (Map)ImmutableMap.of());
            Map writeProperties = writeConf.writeProperties();
            Map expectedProperties = (Map)propertiesSuite.get(2);
            Assertions.assertThat((Map)writeConf.writeProperties()).hasSameSizeAs(expectedProperties);
            for (Map.Entry entry : writeProperties.entrySet()) {
                Assertions.assertThat((Map)expectedProperties).containsEntry((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
            }
            table.refresh();
            updateProperties = table.updateProperties();
            for (Map.Entry entry : tableProperties.entrySet()) {
                updateProperties.remove((String)entry.getKey());
            }
            updateProperties.commit();
        });
    }

    private void checkMode(DistributionMode expectedMode, SparkWriteConf writeConf) {
        Assertions.assertThat((Comparable)writeConf.distributionMode()).isEqualTo((Object)expectedMode);
        Assertions.assertThat((Comparable)writeConf.copyOnWriteDistributionMode(RowLevelOperation.Command.DELETE)).isEqualTo((Object)expectedMode);
        Assertions.assertThat((Comparable)writeConf.positionDeltaDistributionMode(RowLevelOperation.Command.DELETE)).isEqualTo((Object)expectedMode);
        Assertions.assertThat((Comparable)writeConf.copyOnWriteDistributionMode(RowLevelOperation.Command.UPDATE)).isEqualTo((Object)expectedMode);
        Assertions.assertThat((Comparable)writeConf.positionDeltaDistributionMode(RowLevelOperation.Command.UPDATE)).isEqualTo((Object)expectedMode);
        Assertions.assertThat((Comparable)writeConf.copyOnWriteDistributionMode(RowLevelOperation.Command.MERGE)).isEqualTo((Object)expectedMode);
        Assertions.assertThat((Comparable)writeConf.positionDeltaDistributionMode(RowLevelOperation.Command.MERGE)).isEqualTo((Object)expectedMode);
    }
}

