/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.actions.MigrateTable;
import org.apache.iceberg.actions.SnapshotTable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.spark.actions.SnapshotTableSparkAction;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import scala.Option;
import scala.Some;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class TestCreateActions
extends CatalogTestBase {
    private static final String CREATE_PARTITIONED_PARQUET = "CREATE TABLE %s (id INT, data STRING) using parquet PARTITIONED BY (id) LOCATION '%s'";
    private static final String CREATE_PARQUET = "CREATE TABLE %s (id INT, data STRING) using parquet LOCATION '%s'";
    private static final String CREATE_HIVE_EXTERNAL_PARQUET = "CREATE EXTERNAL TABLE %s (data STRING) PARTITIONED BY (id INT) STORED AS parquet LOCATION '%s'";
    private static final String CREATE_HIVE_PARQUET = "CREATE TABLE %s (data STRING) PARTITIONED BY (id INT) STORED AS parquet";
    private static final String NAMESPACE = "default";
    private String baseTableName = "baseTable";
    private File tableDir;
    private String tableLocation;
    @Parameter(index=3)
    private String type;
    private TableCatalog catalog;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}, type = {3}")
    public static Object[][] parameters() {
        return new Object[][]{{"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)NAMESPACE, (Object)"parquet-enabled", (Object)"true", (Object)"cache-enabled", (Object)"false"), "hive"}, {"spark_catalog", SparkSessionCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hadoop", (Object)"default-namespace", (Object)NAMESPACE, (Object)"parquet-enabled", (Object)"true", (Object)"cache-enabled", (Object)"false"), "hadoop"}, {"testhive", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hive", (Object)"default-namespace", (Object)NAMESPACE), "hive"}, {"testhadoop", SparkCatalog.class.getName(), ImmutableMap.of((Object)"type", (Object)"hadoop", (Object)"default-namespace", (Object)NAMESPACE), "hadoop"}};
    }

    @Override
    @BeforeEach
    public void before() {
        super.before();
        try {
            this.tableDir = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tableLocation = this.tableDir.toURI().toString();
        this.catalog = (TableCatalog)spark.sessionState().catalogManager().catalog(this.catalogName);
        spark.conf().set("hive.exec.dynamic.partition", "true");
        spark.conf().set("hive.exec.dynamic.partition.mode", "nonstrict");
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", false);
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", false);
        spark.sql(String.format("DROP TABLE IF EXISTS %s", this.baseTableName));
        ArrayList expected = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(1, "a"), new SimpleRecord(2, "b"), new SimpleRecord(3, "c")});
        Dataset df = spark.createDataFrame((List)expected, SimpleRecord.class);
        df.select("id", new String[]{"data"}).orderBy("data", new String[0]).write().mode("append").option("path", this.tableLocation).saveAsTable(this.baseTableName);
    }

    @AfterEach
    public void after() throws IOException {
        spark.sql(String.format("DROP TABLE IF EXISTS %s", this.baseTableName));
    }

    @TestTemplate
    public void testMigratePartitioned() throws Exception {
        String source;
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalog.name()).as("Can only migrate from Spark Session Catalog", new Object[0])).isEqualTo("spark_catalog");
        String dest = source = this.sourceName("test_migrate_partitioned_table");
        this.createSourceTable(CREATE_PARTITIONED_PARQUET, source);
        this.assertMigratedFileCount((MigrateTable)SparkActions.get().migrateTable(source), source, dest);
    }

    @TestTemplate
    public void testPartitionedTableWithUnRecoveredPartitions() throws Exception {
        String source;
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalog.name()).as("Can only migrate from Spark Session Catalog", new Object[0])).isEqualTo("spark_catalog");
        String dest = source = this.sourceName("test_unrecovered_partitions");
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        this.sql(CREATE_PARTITIONED_PARQUET, source, location);
        spark.range(5L).selectExpr(new String[]{"id", "cast(id as STRING) as data"}).write().partitionBy(new String[]{"id"}).mode(SaveMode.Overwrite).parquet(location.toURI().toString());
        this.sql("ALTER TABLE %s ADD PARTITION(id=0)", source);
        this.assertMigratedFileCount((MigrateTable)SparkActions.get().migrateTable(source), source, dest);
    }

    @TestTemplate
    public void testPartitionedTableWithCustomPartitions() throws Exception {
        String source;
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalog.name()).as("Can only migrate from Spark Session Catalog", new Object[0])).isEqualTo("spark_catalog");
        String dest = source = this.sourceName("test_custom_parts");
        File tblLocation = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        File partitionDataLoc = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        spark.sql(String.format(CREATE_PARTITIONED_PARQUET, source, tblLocation));
        spark.range(10L).selectExpr(new String[]{"cast(id as STRING) as data"}).write().mode(SaveMode.Overwrite).parquet(partitionDataLoc.toURI().toString());
        this.sql("ALTER TABLE %s ADD PARTITION(id=0) LOCATION '%s'", source, partitionDataLoc.toURI().toString());
        this.assertMigratedFileCount((MigrateTable)SparkActions.get().migrateTable(source), source, dest);
    }

    @TestTemplate
    public void testAddColumnOnMigratedTableAtEnd() throws Exception {
        String source;
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalog.name()).as("Can only migrate from Spark Session Catalog", new Object[0])).isEqualTo("spark_catalog");
        String dest = source = this.sourceName("test_add_column_migrated_table");
        this.createSourceTable(CREATE_PARQUET, source);
        List<Object[]> expected1 = this.sql("select *, null from %s order by id", source);
        List<Object[]> expected2 = this.sql("select *, null, null from %s order by id", source);
        SparkActions.get().migrateTable(source).execute();
        SparkTable sparkTable = this.loadTable(dest);
        Table table = sparkTable.table();
        Schema beforeSchema = table.schema();
        String newCol1 = "newCol1";
        sparkTable.table().updateSchema().addColumn(newCol1, (Type)Types.IntegerType.get()).commit();
        Schema afterSchema = table.schema();
        Assertions.assertThat((Object)beforeSchema.findField(newCol1)).isNull();
        Assertions.assertThat((Object)afterSchema.findField(newCol1)).isNotNull();
        List<Object[]> results1 = this.sql("select * from %s order by id", dest);
        Assertions.assertThat(results1).isNotEmpty();
        this.assertEquals("Output must match", results1, expected1);
        String newCol2 = "newCol2";
        this.sql("ALTER TABLE %s ADD COLUMN %s INT", dest, newCol2);
        StructType schema = spark.table(dest).schema();
        Assertions.assertThat((Object[])schema.fieldNames()).contains((Object[])new String[]{newCol2});
        List<Object[]> results2 = this.sql("select * from %s order by id", dest);
        Assertions.assertThat(results2).isNotEmpty();
        this.assertEquals("Output must match", results2, expected2);
    }

    @TestTemplate
    public void testAddColumnOnMigratedTableAtMiddle() throws Exception {
        String source;
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalog.name()).as("Can only migrate from Spark Session Catalog", new Object[0])).isEqualTo("spark_catalog");
        String dest = source = this.sourceName("test_add_column_migrated_table_middle");
        this.createSourceTable(CREATE_PARQUET, source);
        SparkActions.get().migrateTable(source).execute();
        SparkTable sparkTable = this.loadTable(dest);
        Table table = sparkTable.table();
        List<Object[]> expected = this.sql("select id, null, data from %s order by id", source);
        Schema beforeSchema = table.schema();
        String newCol1 = "newCol";
        sparkTable.table().updateSchema().addColumn("newCol", (Type)Types.IntegerType.get()).moveAfter(newCol1, "id").commit();
        Schema afterSchema = table.schema();
        Assertions.assertThat((Object)beforeSchema.findField(newCol1)).isNull();
        Assertions.assertThat((Object)afterSchema.findField(newCol1)).isNotNull();
        List<Object[]> results = this.sql("select * from %s order by id", dest);
        Assertions.assertThat(results).isNotEmpty();
        this.assertEquals("Output must match", results, expected);
    }

    @TestTemplate
    public void removeColumnsAtEnd() throws Exception {
        String source;
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalog.name()).as("Can only migrate from Spark Session Catalog", new Object[0])).isEqualTo("spark_catalog");
        String dest = source = this.sourceName("test_remove_column_migrated_table");
        String colName1 = "newCol1";
        String colName2 = "newCol2";
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        spark.range(10L).selectExpr(new String[]{"cast(id as INT)", "CAST(id as INT) " + colName1, "CAST(id as INT) " + colName2}).write().mode(SaveMode.Overwrite).saveAsTable(dest);
        List<Object[]> expected1 = this.sql("select id, %s from %s order by id", colName1, source);
        List<Object[]> expected2 = this.sql("select id from %s order by id", source);
        SparkActions.get().migrateTable(source).execute();
        SparkTable sparkTable = this.loadTable(dest);
        Table table = sparkTable.table();
        Schema beforeSchema = table.schema();
        sparkTable.table().updateSchema().deleteColumn(colName1).commit();
        Schema afterSchema = table.schema();
        Assertions.assertThat((Object)beforeSchema.findField(colName1)).isNotNull();
        Assertions.assertThat((Object)afterSchema.findField(colName1)).isNull();
        List<Object[]> results1 = this.sql("select * from %s order by id", dest);
        Assertions.assertThat(results1).isNotEmpty();
        this.assertEquals("Output must match", expected1, results1);
        this.sql("ALTER TABLE %s DROP COLUMN %s", dest, colName2);
        StructType schema = spark.table(dest).schema();
        Assertions.assertThat((Object[])schema.fieldNames()).doesNotContain((Object[])new String[]{colName2});
        List<Object[]> results2 = this.sql("select * from %s order by id", dest);
        Assertions.assertThat(results2).isNotEmpty();
        this.assertEquals("Output must match", expected2, results2);
    }

    @TestTemplate
    public void removeColumnFromMiddle() throws Exception {
        String source;
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalog.name()).as("Can only migrate from Spark Session Catalog", new Object[0])).isEqualTo("spark_catalog");
        String dest = source = this.sourceName("test_remove_column_migrated_table_from_middle");
        String dropColumnName = "col1";
        spark.range(10L).selectExpr(new String[]{"cast(id as INT)", "CAST(id as INT) as " + dropColumnName, "CAST(id as INT) as col2"}).write().mode(SaveMode.Overwrite).saveAsTable(dest);
        List<Object[]> expected = this.sql("select id, col2 from %s order by id", source);
        SparkActions.get().migrateTable(source).execute();
        this.sql("ALTER TABLE %s DROP COLUMN %s", dest, "col1");
        StructType schema = spark.table(dest).schema();
        Assertions.assertThat((Object[])schema.fieldNames()).doesNotContain((Object[])new String[]{dropColumnName});
        List<Object[]> results = this.sql("select * from %s order by id", dest);
        Assertions.assertThat(results).isNotEmpty();
        this.assertEquals("Output must match", expected, results);
    }

    @TestTemplate
    public void testMigrateUnpartitioned() throws Exception {
        String source;
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalog.name()).as("Can only migrate from Spark Session Catalog", new Object[0])).isEqualTo("spark_catalog");
        String dest = source = this.sourceName("test_migrate_unpartitioned_table");
        this.createSourceTable(CREATE_PARQUET, source);
        this.assertMigratedFileCount((MigrateTable)SparkActions.get().migrateTable(source), source, dest);
    }

    @TestTemplate
    public void testSnapshotPartitioned() throws Exception {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot snapshot with arbitrary location in a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        String source = this.sourceName("test_snapshot_partitioned_table");
        String dest = this.destName("iceberg_snapshot_partitioned");
        this.createSourceTable(CREATE_PARTITIONED_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableLocation(location.toString()), source, dest);
        this.assertIsolatedSnapshot(source, dest);
    }

    @TestTemplate
    public void testSnapshotUnpartitioned() throws Exception {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot snapshot with arbitrary location in a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        String source = this.sourceName("test_snapshot_unpartitioned_table");
        String dest = this.destName("iceberg_snapshot_unpartitioned");
        this.createSourceTable(CREATE_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableLocation(location.toString()), source, dest);
        this.assertIsolatedSnapshot(source, dest);
    }

    @TestTemplate
    public void testSnapshotHiveTable() throws Exception {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot snapshot with arbitrary location in a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        String source = this.sourceName("snapshot_hive_table");
        String dest = this.destName("iceberg_snapshot_hive_table");
        this.createSourceTable(CREATE_HIVE_EXTERNAL_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableLocation(location.toString()), source, dest);
        this.assertIsolatedSnapshot(source, dest);
    }

    @TestTemplate
    public void testMigrateHiveTable() throws Exception {
        String source;
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        String dest = source = this.sourceName("migrate_hive_table");
        this.createSourceTable(CREATE_HIVE_EXTERNAL_PARQUET, source);
        this.assertMigratedFileCount((MigrateTable)SparkActions.get().migrateTable(source), source, dest);
    }

    @TestTemplate
    public void testSnapshotManagedHiveTable() throws Exception {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        String source = this.sourceName("snapshot_managed_hive_table");
        String dest = this.destName("iceberg_snapshot_managed_hive_table");
        this.createSourceTable(CREATE_HIVE_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableLocation(location.toString()), source, dest);
        this.assertIsolatedSnapshot(source, dest);
    }

    @TestTemplate
    public void testMigrateManagedHiveTable() throws Exception {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        String source = this.sourceName("migrate_managed_hive_table");
        String dest = this.destName("iceberg_migrate_managed_hive_table");
        this.createSourceTable(CREATE_HIVE_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableLocation(location.toString()), source, dest);
    }

    @TestTemplate
    public void testProperties() throws Exception {
        String source = this.sourceName("test_properties_table");
        String dest = this.destName("iceberg_properties");
        HashMap props = Maps.newHashMap();
        props.put("city", "New Orleans");
        props.put("note", "Jazz");
        this.createSourceTable(CREATE_PARQUET, source);
        for (Map.Entry keyValue : props.entrySet()) {
            spark.sql(String.format("ALTER TABLE %s SET TBLPROPERTIES (\"%s\" = \"%s\")", source, keyValue.getKey(), keyValue.getValue()));
        }
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest).tableProperty("dogs", "sundance"), source, dest);
        SparkTable table = this.loadTable(dest);
        HashMap expectedProps = Maps.newHashMap();
        expectedProps.putAll(props);
        expectedProps.put("dogs", "sundance");
        for (Map.Entry entry : expectedProps.entrySet()) {
            ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Property value is not the expected value", new Object[0])).containsEntry((Object)((String)entry.getKey()), (Object)((String)entry.getValue()));
        }
    }

    @TestTemplate
    public void testSparkTableReservedProperties() throws Exception {
        String[] keys;
        String destTableName = "iceberg_reserved_properties";
        String source = this.sourceName("test_reserved_properties_table");
        String dest = this.destName(destTableName);
        this.createSourceTable(CREATE_PARQUET, source);
        SnapshotTableSparkAction action = SparkActions.get().snapshotTable(source).as(dest);
        action.tableProperty("format-version", "1");
        this.assertSnapshotFileCount((SnapshotTable)action, source, dest);
        SparkTable table = this.loadTable(dest);
        ((ReplaceSortOrder)((ReplaceSortOrder)table.table().replaceSortOrder().asc("id")).desc("data")).commit();
        for (String entry : keys = new String[]{"provider", "format", "current-snapshot-id", "location", "sort-order"}) {
            ((MapAssert)Assertions.assertThat((Map)table.properties()).as("Created table missing reserved property " + entry, new Object[0])).containsKey((Object)entry);
        }
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("provider"))).as("Unexpected provider", new Object[0])).isEqualTo("iceberg");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("format"))).as("Unexpected provider", new Object[0])).isEqualTo("iceberg/parquet");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("current-snapshot-id"))).as("No current-snapshot-id found", new Object[0])).isNotEqualTo((Object)"none");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("location"))).as("Location isn't correct", new Object[0])).endsWith((CharSequence)destTableName);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("format-version"))).as("Unexpected format-version", new Object[0])).isEqualTo("1");
        table.table().updateProperties().set("format-version", "2").commit();
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("format-version"))).as("Unexpected format-version", new Object[0])).isEqualTo("2");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("sort-order"))).as("Sort-order isn't correct", new Object[0])).isEqualTo("id ASC NULLS FIRST, data DESC NULLS LAST");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("identifier-fields"))).as("Identifier fields should be null", new Object[0])).isNull();
        table.table().updateSchema().allowIncompatibleChanges().requireColumn("id").setIdentifierFields(new String[]{"id"}).commit();
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("identifier-fields"))).as("Identifier fields aren't correct", new Object[0])).isEqualTo("[id]");
    }

    @TestTemplate
    public void testSnapshotDefaultLocation() throws Exception {
        String source = this.sourceName("test_snapshot_default");
        String dest = this.destName("iceberg_snapshot_default");
        this.createSourceTable(CREATE_PARTITIONED_PARQUET, source);
        this.assertSnapshotFileCount((SnapshotTable)SparkActions.get().snapshotTable(source).as(dest), source, dest);
        this.assertIsolatedSnapshot(source, dest);
    }

    @TestTemplate
    public void schemaEvolutionTestWithSparkAPI() throws Exception {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalog.name()).as("Can only migrate from Spark Session Catalog", new Object[0])).isEqualTo("spark_catalog");
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        String tblName = this.sourceName("schema_evolution_test");
        spark.range(0L, 5L).selectExpr(new String[]{"CAST(id as INT) as col0", "CAST(id AS FLOAT) col2", "CAST(id AS LONG) col3"}).write().mode(SaveMode.Append).parquet(location.toURI().toString());
        Dataset rowDataset = spark.range(6L, 10L).selectExpr(new String[]{"CAST(id as INT) as col0", "CAST(id AS STRING) col1", "CAST(id AS FLOAT) col2", "CAST(id AS LONG) col3"});
        rowDataset.write().mode(SaveMode.Append).parquet(location.toURI().toString());
        spark.read().schema(rowDataset.schema()).parquet(location.toURI().toString()).write().saveAsTable(tblName);
        List<Object[]> expectedBeforeAddColumn = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        List<Object[]> expectedAfterAddColumn = this.sql("SELECT col0, null, col1, col2, col3 FROM %s ORDER BY col0", tblName);
        SparkActions.get().migrateTable(tblName).execute();
        List<Object[]> afterMigarteBeforeAddResults = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        this.assertEquals("Output must match", expectedBeforeAddColumn, afterMigarteBeforeAddResults);
        SparkTable sparkTable = this.loadTable(tblName);
        sparkTable.table().updateSchema().addColumn("newCol", (Type)Types.IntegerType.get()).moveAfter("newCol", "col0").commit();
        List<Object[]> afterMigarteAfterAddResults = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        this.assertEquals("Output must match", expectedAfterAddColumn, afterMigarteAfterAddResults);
    }

    @TestTemplate
    public void schemaEvolutionTestWithSparkSQL() throws Exception {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.type).as("Cannot migrate to a hadoop based catalog", new Object[0])).isNotEqualTo((Object)"hadoop");
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalog.name()).as("Can only migrate from Spark Session Catalog", new Object[0])).isEqualTo("spark_catalog");
        String tblName = this.sourceName("schema_evolution_test_sql");
        spark.range(0L, 5L).selectExpr(new String[]{"CAST(id as INT) col0", "CAST(id AS FLOAT) col1", "CAST(id AS STRING) col2"}).write().mode(SaveMode.Append).saveAsTable(tblName);
        this.sql("ALTER TABLE %s ADD COLUMN col3 INT", tblName);
        spark.range(6L, 10L).selectExpr(new String[]{"CAST(id AS INT) col0", "CAST(id AS FLOAT) col1", "CAST(id AS STRING) col2", "CAST(id AS INT) col3"}).registerTempTable("tempdata");
        this.sql("INSERT INTO TABLE %s SELECT * FROM tempdata", tblName);
        List<Object[]> expectedBeforeAddColumn = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        List<Object[]> expectedAfterAddColumn = this.sql("SELECT col0, null, col1, col2, col3 FROM %s ORDER BY col0", tblName);
        SparkActions.get().migrateTable(tblName).execute();
        List<Object[]> afterMigarteBeforeAddResults = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        this.assertEquals("Output must match", expectedBeforeAddColumn, afterMigarteBeforeAddResults);
        SparkTable sparkTable = this.loadTable(tblName);
        sparkTable.table().updateSchema().addColumn("newCol", (Type)Types.IntegerType.get()).moveAfter("newCol", "col0").commit();
        List<Object[]> afterMigarteAfterAddResults = this.sql("SELECT * FROM %s ORDER BY col0", tblName);
        this.assertEquals("Output must match", expectedAfterAddColumn, afterMigarteAfterAddResults);
    }

    @TestTemplate
    public void testHiveStyleThreeLevelList() throws Exception {
        this.threeLevelList(true);
    }

    @TestTemplate
    public void testThreeLevelList() throws Exception {
        this.threeLevelList(false);
    }

    @TestTemplate
    public void testHiveStyleThreeLevelListWithNestedStruct() throws Exception {
        this.threeLevelListWithNestedStruct(true);
    }

    @TestTemplate
    public void testThreeLevelListWithNestedStruct() throws Exception {
        this.threeLevelListWithNestedStruct(false);
    }

    @TestTemplate
    public void testHiveStyleThreeLevelLists() throws Exception {
        this.threeLevelLists(true);
    }

    @TestTemplate
    public void testThreeLevelLists() throws Exception {
        this.threeLevelLists(false);
    }

    @TestTemplate
    public void testHiveStyleStructOfThreeLevelLists() throws Exception {
        this.structOfThreeLevelLists(true);
    }

    @TestTemplate
    public void testStructOfThreeLevelLists() throws Exception {
        this.structOfThreeLevelLists(false);
    }

    @TestTemplate
    public void testTwoLevelList() throws IOException {
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", true);
        String tableName = this.sourceName("testTwoLevelList");
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        StructType sparkSchema = new StructType(new StructField[]{new StructField("col1", (DataType)new ArrayType((DataType)new StructType(new StructField[]{new StructField("col2", DataTypes.IntegerType, false, Metadata.empty())}), false), true, Metadata.empty())});
        String expectedParquetSchema = "message spark_schema {\n  optional group col1 (LIST) {\n    repeated group array {\n      required int32 col2;\n    }\n  }\n}\n";
        List<String> testData = Collections.singletonList("{\"col1\": [{\"col2\": 1}]}");
        spark.read().schema(sparkSchema).json(JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext()).parallelize(testData)).coalesce(1).write().format("parquet").mode(SaveMode.Append).save(location.getPath());
        File parquetFile = Arrays.stream((File[])Preconditions.checkNotNull((Object)location.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("parquet");
            }
        }))).findAny().get();
        ParquetFileReader pqReader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)new Path(parquetFile.getPath()), (Configuration)spark.sessionState().newHadoopConf()));
        MessageType schema = pqReader.getFooter().getFileMetaData().getSchema();
        Assertions.assertThat((Object)schema).isEqualTo((Object)MessageTypeParser.parseMessageType((String)expectedParquetSchema));
        this.sql("CREATE EXTERNAL TABLE %s (col1 ARRAY<STRUCT<col2 INT>>) STORED AS parquet LOCATION '%s'", tableName, location);
        List<Object[]> expected = this.sql("select array(struct(1))", new Object[0]);
        SparkActions.get().migrateTable(tableName).execute();
        List<Object[]> results = this.sql("SELECT * FROM %s", tableName);
        Assertions.assertThat(results).isNotEmpty();
        this.assertEquals("Output must match", expected, results);
    }

    private void threeLevelList(boolean useLegacyMode) throws Exception {
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", useLegacyMode);
        String tableName = this.sourceName(String.format("threeLevelList_%s", useLegacyMode));
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        this.sql("CREATE TABLE %s (col1 ARRAY<STRUCT<col2 INT>>) STORED AS parquet LOCATION '%s'", tableName, location);
        int testValue = 12345;
        this.sql("INSERT INTO %s VALUES (ARRAY(STRUCT(%s)))", tableName, testValue);
        List<Object[]> expected = this.sql(String.format("SELECT * FROM %s", tableName), new Object[0]);
        SparkActions.get().migrateTable(tableName).execute();
        List<Object[]> results = this.sql("SELECT * FROM %s", tableName);
        Assertions.assertThat(results).isNotEmpty();
        this.assertEquals("Output must match", expected, results);
    }

    private void threeLevelListWithNestedStruct(boolean useLegacyMode) throws Exception {
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", useLegacyMode);
        String tableName = this.sourceName(String.format("threeLevelListWithNestedStruct_%s", useLegacyMode));
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        this.sql("CREATE TABLE %s (col1 ARRAY<STRUCT<col2 STRUCT<col3 INT>>>) STORED AS parquet LOCATION '%s'", tableName, location);
        int testValue = 12345;
        this.sql("INSERT INTO %s VALUES (ARRAY(STRUCT(STRUCT(%s))))", tableName, testValue);
        List<Object[]> expected = this.sql(String.format("SELECT * FROM %s", tableName), new Object[0]);
        SparkActions.get().migrateTable(tableName).execute();
        List<Object[]> results = this.sql("SELECT * FROM %s", tableName);
        Assertions.assertThat(results).isNotEmpty();
        this.assertEquals("Output must match", expected, results);
    }

    private void threeLevelLists(boolean useLegacyMode) throws Exception {
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", useLegacyMode);
        String tableName = this.sourceName(String.format("threeLevelLists_%s", useLegacyMode));
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        this.sql("CREATE TABLE %s (col1 ARRAY<STRUCT<col2 INT>>, col3 ARRAY<STRUCT<col4 INT>>) STORED AS parquet LOCATION '%s'", tableName, location);
        int testValue1 = 12345;
        int testValue2 = 987654;
        this.sql("INSERT INTO %s VALUES (ARRAY(STRUCT(%s)), ARRAY(STRUCT(%s)))", tableName, testValue1, testValue2);
        List<Object[]> expected = this.sql(String.format("SELECT * FROM %s", tableName), new Object[0]);
        SparkActions.get().migrateTable(tableName).execute();
        List<Object[]> results = this.sql("SELECT * FROM %s", tableName);
        Assertions.assertThat(results).isNotEmpty();
        this.assertEquals("Output must match", expected, results);
    }

    private void structOfThreeLevelLists(boolean useLegacyMode) throws Exception {
        spark.conf().set("spark.sql.parquet.writeLegacyFormat", useLegacyMode);
        String tableName = this.sourceName(String.format("structOfThreeLevelLists_%s", useLegacyMode));
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        this.sql("CREATE TABLE %s (col1 STRUCT<col2 ARRAY<STRUCT<col3 INT>>>) STORED AS parquet LOCATION '%s'", tableName, location);
        int testValue1 = 12345;
        this.sql("INSERT INTO %s VALUES (STRUCT(STRUCT(ARRAY(STRUCT(%s)))))", tableName, testValue1);
        List<Object[]> expected = this.sql(String.format("SELECT * FROM %s", tableName), new Object[0]);
        SparkActions.get().migrateTable(tableName).execute();
        List<Object[]> results = this.sql("SELECT * FROM %s", tableName);
        Assertions.assertThat(results).isNotEmpty();
        this.assertEquals("Output must match", expected, results);
    }

    private SparkTable loadTable(String name) throws NoSuchTableException, ParseException {
        return (SparkTable)this.catalog.loadTable(Spark3Util.catalogAndIdentifier((SparkSession)spark, (String)name).identifier());
    }

    private CatalogTable loadSessionTable(String name) throws NoSuchTableException, NoSuchDatabaseException, ParseException {
        Identifier identifier = Spark3Util.catalogAndIdentifier((SparkSession)spark, (String)name).identifier();
        Some namespace = Some.apply((Object)identifier.namespace()[0]);
        return spark.sessionState().catalog().getTableMetadata(new TableIdentifier(identifier.name(), (Option)namespace));
    }

    private void createSourceTable(String createStatement, String tableName) throws IOException, NoSuchTableException, NoSuchDatabaseException, ParseException {
        File location = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        spark.sql(String.format(createStatement, tableName, location));
        CatalogTable table = this.loadSessionTable(tableName);
        String format = (String)table.provider().get();
        spark.table(this.baseTableName).selectExpr(table.schema().names()).write().mode(SaveMode.Append).format(format).insertInto(tableName);
    }

    private void assertMigratedFileCount(MigrateTable migrateAction, String source, String dest) throws NoSuchTableException, NoSuchDatabaseException, ParseException {
        long expectedFiles = this.expectedFilesCount(source);
        MigrateTable.Result migratedFiles = (MigrateTable.Result)migrateAction.execute();
        this.validateTables(source, dest);
        ((AbstractLongAssert)Assertions.assertThat((long)migratedFiles.migratedDataFilesCount()).as("Expected number of migrated files", new Object[0])).isEqualTo(expectedFiles);
    }

    private void assertSnapshotFileCount(SnapshotTable snapshotTable, String source, String dest) throws NoSuchTableException, NoSuchDatabaseException, ParseException {
        long expectedFiles = this.expectedFilesCount(source);
        SnapshotTable.Result snapshotTableResult = (SnapshotTable.Result)snapshotTable.execute();
        this.validateTables(source, dest);
        ((AbstractLongAssert)Assertions.assertThat((long)snapshotTableResult.importedDataFilesCount()).as("Expected number of imported snapshot files", new Object[0])).isEqualTo(expectedFiles);
    }

    private void validateTables(String source, String dest) throws NoSuchTableException, ParseException {
        List expected = spark.table(source).collectAsList();
        SparkTable destTable = this.loadTable(dest);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)destTable.properties().get("provider"))).as("Provider should be iceberg", new Object[0])).isEqualTo("iceberg");
        List actual = spark.table(dest).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actual).as(String.format("Rows in migrated table did not match\nExpected :%s rows \nFound    :%s", expected, actual), new Object[0])).containsAll((Iterable)expected);
        ((ListAssert)Assertions.assertThat((List)expected).as(String.format("Rows in migrated table did not match\nExpected :%s rows \nFound    :%s", expected, actual), new Object[0])).containsAll((Iterable)actual);
    }

    private long expectedFilesCount(String source) throws NoSuchDatabaseException, NoSuchTableException, ParseException {
        List<Object> uris;
        CatalogTable sourceTable = this.loadSessionTable(source);
        if (sourceTable.partitionColumnNames().isEmpty()) {
            uris = Lists.newArrayList();
            uris.add(sourceTable.location());
        } else {
            Seq catalogTablePartitionSeq = spark.sessionState().catalog().listPartitions(sourceTable.identifier(), Option.apply(null));
            uris = JavaConverters.seqAsJavaList((Seq)catalogTablePartitionSeq).stream().map(CatalogTablePartition::location).collect(Collectors.toList());
        }
        return uris.stream().flatMap(uri -> FileUtils.listFiles((File)Paths.get(uri).toFile(), (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE).stream()).filter(file -> !file.toString().endsWith("crc") && !file.toString().contains("_SUCCESS")).count();
    }

    private void assertIsolatedSnapshot(String source, String dest) {
        List expected = spark.sql(String.format("SELECT * FROM %s", source)).collectAsList();
        ArrayList extraData = Lists.newArrayList((Object[])new SimpleRecord[]{new SimpleRecord(4, "d")});
        Dataset df = spark.createDataFrame((List)extraData, SimpleRecord.class);
        df.write().format("iceberg").mode("append").saveAsTable(dest);
        List result = spark.sql(String.format("SELECT * FROM %s", source)).collectAsList();
        ((ListAssert)Assertions.assertThat((List)result).as("No additional rows should be added to the original table", new Object[0])).hasSameSizeAs((Iterable)expected);
        List snapshot = spark.sql(String.format("SELECT * FROM %s WHERE id = 4 AND data = 'd'", dest)).collectAsList();
        ((ListAssert)Assertions.assertThat((List)snapshot).as("Added row not found in snapshot", new Object[0])).hasSize(1);
    }

    private String sourceName(String source) {
        return "default." + this.catalog.name() + "_" + this.type + "_" + source;
    }

    private String destName(String dest) {
        if (this.catalog.name().equals("spark_catalog")) {
            return "default." + this.catalog.name() + "_" + this.type + "_" + dest;
        }
        return this.catalog.name() + "." + NAMESPACE + "." + this.catalog.name() + "_" + this.type + "_" + dest;
    }
}

