/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileMetadata;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.actions.ActionsProvider;
import org.apache.iceberg.actions.DeleteOrphanFiles;
import org.apache.iceberg.actions.DeleteReachableFiles;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestDeleteReachableFilesAction
extends TestBase {
    private static final HadoopTables TABLES = new HadoopTables(new Configuration());
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"c1", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"c2", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"c3", (Type)Types.StringType.get())});
    private static final int SHUFFLE_PARTITIONS = 2;
    private static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).identity("c1").build();
    static final DataFile FILE_A = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-a.parquet").withFileSizeInBytes(10L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{0})).withRecordCount(1L).build();
    static final DataFile FILE_B = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-b.parquet").withFileSizeInBytes(10L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{1})).withRecordCount(1L).build();
    static final DataFile FILE_C = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-c.parquet").withFileSizeInBytes(10L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{2})).withRecordCount(1L).build();
    static final DataFile FILE_D = DataFiles.builder((PartitionSpec)SPEC).withPath("/path/to/data-d.parquet").withFileSizeInBytes(10L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{3})).withRecordCount(1L).build();
    static final DeleteFile FILE_A_POS_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofPositionDeletes().withPath("/path/to/data-a-pos-deletes.parquet").withFileSizeInBytes(10L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{0})).withRecordCount(1L).build();
    static final DeleteFile FILE_A_EQ_DELETES = FileMetadata.deleteFileBuilder((PartitionSpec)SPEC).ofEqualityDeletes(new int[0]).withPath("/path/to/data-a-eq-deletes.parquet").withFileSizeInBytes(10L).withPartition((StructLike)TestHelpers.Row.of((Object[])new Object[]{0})).withRecordCount(1L).build();
    @TempDir
    private Path temp;
    private Table table;

    @BeforeEach
    public void setupTableLocation() throws Exception {
        File tableDir = this.temp.resolve("junit").toFile();
        String tableLocation = tableDir.toURI().toString();
        this.table = TABLES.create(SCHEMA, SPEC, (Map)Maps.newHashMap(), tableLocation);
        spark.conf().set("spark.sql.shuffle.partitions", 2L);
    }

    private void checkRemoveFilesResults(long expectedDatafiles, long expectedPosDeleteFiles, long expectedEqDeleteFiles, long expectedManifestsDeleted, long expectedManifestListsDeleted, long expectedOtherFilesDeleted, DeleteReachableFiles.Result results) {
        ((AbstractLongAssert)Assertions.assertThat((long)results.deletedManifestsCount()).as("Incorrect number of manifest files deleted", new Object[0])).isEqualTo(expectedManifestsDeleted);
        ((AbstractLongAssert)Assertions.assertThat((long)results.deletedDataFilesCount()).as("Incorrect number of datafiles deleted", new Object[0])).isEqualTo(expectedDatafiles);
        ((AbstractLongAssert)Assertions.assertThat((long)results.deletedPositionDeleteFilesCount()).as("Incorrect number of position delete files deleted", new Object[0])).isEqualTo(expectedPosDeleteFiles);
        ((AbstractLongAssert)Assertions.assertThat((long)results.deletedEqualityDeleteFilesCount()).as("Incorrect number of equality delete files deleted", new Object[0])).isEqualTo(expectedEqDeleteFiles);
        ((AbstractLongAssert)Assertions.assertThat((long)results.deletedManifestListsCount()).as("Incorrect number of manifest lists deleted", new Object[0])).isEqualTo(expectedManifestListsDeleted);
        ((AbstractLongAssert)Assertions.assertThat((long)results.deletedOtherFilesCount()).as("Incorrect number of other lists deleted", new Object[0])).isEqualTo(expectedOtherFilesDeleted);
    }

    @Test
    public void dataFilesCleanupWithParallelTasks() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newFastAppend().appendFile(FILE_B).commit();
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_B), (Set)ImmutableSet.of((Object)FILE_D)).commit();
        this.table.newRewrite().rewriteFiles((Set)ImmutableSet.of((Object)FILE_A), (Set)ImmutableSet.of((Object)FILE_C)).commit();
        ConcurrentHashMap.KeySetView deletedFiles = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView deleteThreads = ConcurrentHashMap.newKeySet();
        AtomicInteger deleteThreadsIndex = new AtomicInteger(0);
        DeleteReachableFiles.Result result = (DeleteReachableFiles.Result)this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table)).io(this.table.io()).executeDeleteWith(Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("remove-files-" + deleteThreadsIndex.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        })).deleteWith(s -> {
            deleteThreads.add(Thread.currentThread().getName());
            deletedFiles.add(s);
        }).execute();
        Assertions.assertThat(deleteThreads).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"remove-files-0", "remove-files-1", "remove-files-2", "remove-files-3"}));
        Lists.newArrayList((Object[])new DataFile[]{FILE_A, FILE_B, FILE_C, FILE_D}).forEach(file -> {
            AbstractCollectionAssert cfr_ignored_0 = (AbstractCollectionAssert)((AbstractCollectionAssert)Assertions.assertThat((Collection)deletedFiles).as("FILE_A should be deleted", new Object[0])).contains((Object[])new String[]{FILE_A.path().toString()});
        });
        this.checkRemoveFilesResults(4L, 0L, 0L, 6L, 4L, 6L, result);
    }

    @Test
    public void testWithExpiringDanglingStageCommit() {
        this.table.location();
        this.table.newAppend().appendFile(FILE_A).commit();
        ((AppendFiles)this.table.newAppend().appendFile(FILE_B).stageOnly()).commit();
        this.table.newAppend().appendFile(FILE_C).commit();
        DeleteReachableFiles.Result result = (DeleteReachableFiles.Result)this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table)).io(this.table.io()).execute();
        this.checkRemoveFilesResults(3L, 0L, 0L, 3L, 3L, 5L, result);
    }

    @Test
    public void testRemoveFileActionOnEmptyTable() {
        DeleteReachableFiles.Result result = (DeleteReachableFiles.Result)this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table)).io(this.table.io()).execute();
        this.checkRemoveFilesResults(0L, 0L, 0L, 0L, 0L, 2L, result);
    }

    @Test
    public void testRemoveFilesActionWithReducedVersionsTable() {
        this.table.updateProperties().set("write.metadata.previous-versions-max", "2").commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newAppend().appendFile(FILE_C).commit();
        this.table.newAppend().appendFile(FILE_D).commit();
        DeleteReachableFiles baseRemoveFilesSparkAction = this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table)).io(this.table.io());
        DeleteReachableFiles.Result result = (DeleteReachableFiles.Result)baseRemoveFilesSparkAction.execute();
        this.checkRemoveFilesResults(4L, 0L, 0L, 5L, 5L, 8L, result);
    }

    @Test
    public void testRemoveFilesAction() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        DeleteReachableFiles baseRemoveFilesSparkAction = this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table)).io(this.table.io());
        this.checkRemoveFilesResults(2L, 0L, 0L, 2L, 2L, 4L, (DeleteReachableFiles.Result)baseRemoveFilesSparkAction.execute());
    }

    @Test
    public void testPositionDeleteFiles() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newRowDelta().addDeletes(FILE_A_POS_DELETES).commit();
        DeleteReachableFiles baseRemoveFilesSparkAction = this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table)).io(this.table.io());
        this.checkRemoveFilesResults(2L, 1L, 0L, 3L, 3L, 5L, (DeleteReachableFiles.Result)baseRemoveFilesSparkAction.execute());
    }

    @Test
    public void testEqualityDeleteFiles() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        this.table.newRowDelta().addDeletes(FILE_A_EQ_DELETES).commit();
        DeleteReachableFiles baseRemoveFilesSparkAction = this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table)).io(this.table.io());
        this.checkRemoveFilesResults(2L, 0L, 1L, 3L, 3L, 5L, (DeleteReachableFiles.Result)baseRemoveFilesSparkAction.execute());
    }

    @Test
    public void testRemoveFilesActionWithDefaultIO() {
        this.table.newAppend().appendFile(FILE_A).commit();
        this.table.newAppend().appendFile(FILE_B).commit();
        DeleteReachableFiles baseRemoveFilesSparkAction = this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table));
        this.checkRemoveFilesResults(2L, 0L, 0L, 2L, 2L, 4L, (DeleteReachableFiles.Result)baseRemoveFilesSparkAction.execute());
    }

    @Test
    public void testUseLocalIterator() {
        this.table.newFastAppend().appendFile(FILE_A).commit();
        this.table.newOverwrite().deleteFile(FILE_A).addFile(FILE_B).commit();
        this.table.newFastAppend().appendFile(FILE_C).commit();
        int jobsBefore = spark.sparkContext().dagScheduler().nextJobId().get();
        this.withSQLConf((Map<String, String>)ImmutableMap.of((Object)"spark.sql.adaptive.enabled", (Object)"false"), () -> {
            DeleteReachableFiles.Result results = (DeleteReachableFiles.Result)((DeleteReachableFiles)this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table)).io(this.table.io()).option("stream-results", "true")).execute();
            int jobsAfter = spark.sparkContext().dagScheduler().nextJobId().get();
            int totalJobsRun = jobsAfter - jobsBefore;
            this.checkRemoveFilesResults(3L, 0L, 0L, 4L, 3L, 5L, results);
            ((AbstractIntegerAssert)Assertions.assertThat((int)totalJobsRun).as("Expected total jobs to be equal to total number of shuffle partitions", new Object[0])).isEqualTo(2);
        });
    }

    @Test
    public void testIgnoreMetadataFilesNotFound() {
        this.table.updateProperties().set("write.metadata.previous-versions-max", "1").commit();
        this.table.newAppend().appendFile(FILE_A).commit();
        DeleteOrphanFiles.Result result = (DeleteOrphanFiles.Result)this.sparkActions().deleteOrphanFiles(this.table).olderThan(System.currentTimeMillis()).execute();
        ((IterableAssert)Assertions.assertThat((Iterable)result.orphanFileLocations()).as("Should delete 1 file", new Object[0])).hasSize(1);
        ((ListAssert)Assertions.assertThat(StreamSupport.stream(result.orphanFileLocations().spliterator(), false)).as("Should remove v1 file", new Object[0])).anyMatch(file -> file.contains("v1.metadata.json"));
        DeleteReachableFiles baseRemoveFilesSparkAction = this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table)).io(this.table.io());
        DeleteReachableFiles.Result res = (DeleteReachableFiles.Result)baseRemoveFilesSparkAction.execute();
        this.checkRemoveFilesResults(1L, 0L, 0L, 1L, 1L, 4L, res);
    }

    @Test
    public void testEmptyIOThrowsException() {
        DeleteReachableFiles baseRemoveFilesSparkAction = this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table)).io(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((DeleteReachableFiles)baseRemoveFilesSparkAction).execute()).isInstanceOf(IllegalArgumentException.class)).hasMessage("File IO cannot be null");
    }

    @Test
    public void testRemoveFilesActionWhenGarbageCollectionDisabled() {
        this.table.updateProperties().set("gc.enabled", "false").commit();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            DeleteReachableFiles.Result cfr_ignored_0 = (DeleteReachableFiles.Result)this.sparkActions().deleteReachableFiles(this.metadataLocation(this.table)).execute();
        }).isInstanceOf(ValidationException.class)).hasMessage("Cannot delete files: GC is disabled (deleting files may corrupt other tables)");
    }

    private String metadataLocation(Table tbl) {
        return ((HasTableOperations)tbl).operations().current().metadataFileLocation();
    }

    private ActionsProvider sparkActions() {
        return SparkActions.get();
    }
}

