/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.iceberg.Schema;
import org.apache.iceberg.actions.DeleteOrphanFiles;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkCatalog;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkSessionCatalog;
import org.apache.iceberg.spark.actions.SparkActions;
import org.apache.iceberg.spark.actions.TestRemoveOrphanFilesAction;
import org.apache.iceberg.spark.source.SparkTable;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.expressions.Transform;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class TestRemoveOrphanFilesAction3
extends TestRemoveOrphanFilesAction {
    @Test
    public void testSparkCatalogTable() throws Exception {
        spark.conf().set("spark.sql.catalog.mycat", "org.apache.iceberg.spark.SparkCatalog");
        spark.conf().set("spark.sql.catalog.mycat.type", "hadoop");
        spark.conf().set("spark.sql.catalog.mycat.warehouse", this.tableLocation);
        SparkCatalog cat = (SparkCatalog)spark.sessionState().catalogManager().catalog("mycat");
        String[] database = new String[]{"default"};
        Identifier id = Identifier.of((String[])database, (String)"table");
        HashMap options = Maps.newHashMap();
        Transform[] transforms = new Transform[]{};
        cat.createTable(id, SparkSchemaUtil.convert((Schema)SCHEMA), transforms, (Map)options);
        SparkTable table = (SparkTable)cat.loadTable(id);
        spark.sql("INSERT INTO mycat.default.table VALUES (1,1,1)");
        String location = table.table().location().replaceFirst("file:", "");
        new File(location + "/data/trashfile").createNewFile();
        DeleteOrphanFiles.Result results = SparkActions.get().deleteOrphanFiles(table.table()).olderThan(System.currentTimeMillis() + 1000L).execute();
        ((ListAssert)Assertions.assertThat(StreamSupport.stream(results.orphanFileLocations().spliterator(), false)).as("trash file should be removed", new Object[0])).anyMatch(file -> file.contains("file:" + location + "/data/trashfile"));
    }

    @Test
    public void testSparkCatalogNamedHadoopTable() throws Exception {
        spark.conf().set("spark.sql.catalog.hadoop", "org.apache.iceberg.spark.SparkCatalog");
        spark.conf().set("spark.sql.catalog.hadoop.type", "hadoop");
        spark.conf().set("spark.sql.catalog.hadoop.warehouse", this.tableLocation);
        SparkCatalog cat = (SparkCatalog)spark.sessionState().catalogManager().catalog("hadoop");
        String[] database = new String[]{"default"};
        Identifier id = Identifier.of((String[])database, (String)"table");
        HashMap options = Maps.newHashMap();
        Transform[] transforms = new Transform[]{};
        cat.createTable(id, SparkSchemaUtil.convert((Schema)SCHEMA), transforms, (Map)options);
        SparkTable table = (SparkTable)cat.loadTable(id);
        spark.sql("INSERT INTO hadoop.default.table VALUES (1,1,1)");
        String location = table.table().location().replaceFirst("file:", "");
        new File(location + "/data/trashfile").createNewFile();
        DeleteOrphanFiles.Result results = SparkActions.get().deleteOrphanFiles(table.table()).olderThan(System.currentTimeMillis() + 1000L).execute();
        ((ListAssert)Assertions.assertThat(StreamSupport.stream(results.orphanFileLocations().spliterator(), false)).as("trash file should be removed", new Object[0])).anyMatch(file -> file.contains("file:" + location + "/data/trashfile"));
    }

    @Test
    public void testSparkCatalogNamedHiveTable() throws Exception {
        spark.conf().set("spark.sql.catalog.hive", "org.apache.iceberg.spark.SparkCatalog");
        spark.conf().set("spark.sql.catalog.hive.type", "hadoop");
        spark.conf().set("spark.sql.catalog.hive.warehouse", this.tableLocation);
        SparkCatalog cat = (SparkCatalog)spark.sessionState().catalogManager().catalog("hive");
        String[] database = new String[]{"default"};
        Identifier id = Identifier.of((String[])database, (String)"table");
        HashMap options = Maps.newHashMap();
        Transform[] transforms = new Transform[]{};
        cat.createTable(id, SparkSchemaUtil.convert((Schema)SCHEMA), transforms, (Map)options);
        SparkTable table = (SparkTable)cat.loadTable(id);
        spark.sql("INSERT INTO hive.default.table VALUES (1,1,1)");
        String location = table.table().location().replaceFirst("file:", "");
        new File(location + "/data/trashfile").createNewFile();
        DeleteOrphanFiles.Result results = SparkActions.get().deleteOrphanFiles(table.table()).olderThan(System.currentTimeMillis() + 1000L).execute();
        ((ListAssert)Assertions.assertThat(StreamSupport.stream(results.orphanFileLocations().spliterator(), false)).as("trash file should be removed", new Object[0])).anyMatch(file -> file.contains("file:" + location + "/data/trashfile"));
    }

    @Test
    public void testSparkSessionCatalogHadoopTable() throws Exception {
        spark.conf().set("spark.sql.catalog.spark_catalog", "org.apache.iceberg.spark.SparkSessionCatalog");
        spark.conf().set("spark.sql.catalog.spark_catalog.type", "hadoop");
        spark.conf().set("spark.sql.catalog.spark_catalog.warehouse", this.tableLocation);
        SparkSessionCatalog cat = (SparkSessionCatalog)spark.sessionState().catalogManager().v2SessionCatalog();
        String[] database = new String[]{"default"};
        Identifier id = Identifier.of((String[])database, (String)"table");
        HashMap options = Maps.newHashMap();
        Transform[] transforms = new Transform[]{};
        cat.createTable(id, SparkSchemaUtil.convert((Schema)SCHEMA), transforms, (Map)options);
        SparkTable table = (SparkTable)cat.loadTable(id);
        spark.sql("INSERT INTO default.table VALUES (1,1,1)");
        String location = table.table().location().replaceFirst("file:", "");
        new File(location + "/data/trashfile").createNewFile();
        DeleteOrphanFiles.Result results = SparkActions.get().deleteOrphanFiles(table.table()).olderThan(System.currentTimeMillis() + 1000L).execute();
        ((ListAssert)Assertions.assertThat(StreamSupport.stream(results.orphanFileLocations().spliterator(), false)).as("trash file should be removed", new Object[0])).anyMatch(file -> file.contains("file:" + location + "/data/trashfile"));
    }

    @Test
    public void testSparkSessionCatalogHiveTable() throws Exception {
        spark.conf().set("spark.sql.catalog.spark_catalog", "org.apache.iceberg.spark.SparkSessionCatalog");
        spark.conf().set("spark.sql.catalog.spark_catalog.type", "hive");
        SparkSessionCatalog cat = (SparkSessionCatalog)spark.sessionState().catalogManager().v2SessionCatalog();
        String[] database = new String[]{"default"};
        Identifier id = Identifier.of((String[])database, (String)"sessioncattest");
        HashMap options = Maps.newHashMap();
        Transform[] transforms = new Transform[]{};
        cat.dropTable(id);
        cat.createTable(id, SparkSchemaUtil.convert((Schema)SCHEMA), transforms, (Map)options);
        SparkTable table = (SparkTable)cat.loadTable(id);
        spark.sql("INSERT INTO default.sessioncattest VALUES (1,1,1)");
        String location = table.table().location().replaceFirst("file:", "");
        new File(location + "/data/trashfile").createNewFile();
        DeleteOrphanFiles.Result results = SparkActions.get().deleteOrphanFiles(table.table()).olderThan(System.currentTimeMillis() + 1000L).execute();
        ((ListAssert)Assertions.assertThat(StreamSupport.stream(results.orphanFileLocations().spliterator(), false)).as("trash file should be removed", new Object[0])).anyMatch(file -> file.contains("file:" + location + "/data/trashfile"));
    }

    @AfterEach
    public void resetSparkSessionCatalog() throws Exception {
        spark.conf().unset("spark.sql.catalog.spark_catalog");
        spark.conf().unset("spark.sql.catalog.spark_catalog.type");
        spark.conf().unset("spark.sql.catalog.spark_catalog.warehouse");
    }
}

