/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.spark.data.AvroDataTest;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.SparkOrcReader;
import org.apache.iceberg.spark.data.SparkOrcWriter;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.spark.data.vectorized.VectorizedSparkOrcReaders;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IteratorAssert;
import org.junit.jupiter.api.Test;

public class TestSparkOrcReader
extends AvroDataTest {
    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        Iterable<InternalRow> expected = RandomData.generateSpark(schema, 100, 0L);
        this.writeAndValidateRecords(schema, expected);
    }

    @Test
    public void writeAndValidateRepeatingRecords() throws IOException {
        Schema structSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)101, (String)"data", (Type)Types.StringType.get())});
        List<InternalRow> expectedRepeating = Collections.nCopies(100, RandomData.generateSpark(structSchema, 1, 0L).iterator().next());
        this.writeAndValidateRecords(structSchema, expectedRepeating);
    }

    private void writeAndValidateRecords(Schema schema, Iterable<InternalRow> expected) throws IOException {
        Iterator<InternalRow> expectedRows;
        Object actualRows2;
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)testFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        try (FileAppender writer = ORC.write((OutputFile)Files.localOutput((File)testFile)).createWriterFunc(SparkOrcWriter::new).schema(schema).build();){
            writer.addAll(expected);
        }
        var5_5 = null;
        try (CloseableIterable reader = ORC.read((InputFile)Files.localInput((File)testFile)).project(schema).createReaderFunc(readOrcSchema -> new SparkOrcReader(schema, readOrcSchema)).build();){
            actualRows2 = reader.iterator();
            expectedRows = expected.iterator();
            while (expectedRows.hasNext()) {
                ((IteratorAssert)Assertions.assertThat((Iterator)actualRows2).as("Should have expected number of rows", new Object[0])).hasNext();
                TestHelpers.assertEquals(schema, expectedRows.next(), actualRows2.next());
            }
            ((IteratorAssert)Assertions.assertThat((Iterator)actualRows2).as("Should not have extra rows", new Object[0])).isExhausted();
        }
        catch (Throwable actualRows2) {
            var5_5 = actualRows2;
            throw actualRows2;
        }
        reader = ORC.read((InputFile)Files.localInput((File)testFile)).project(schema).createBatchedReaderFunc(readOrcSchema -> VectorizedSparkOrcReaders.buildReader((Schema)schema, (TypeDescription)readOrcSchema, (Map)ImmutableMap.of())).build();
        var5_5 = null;
        try {
            actualRows2 = this.batchesToRows((Iterator<ColumnarBatch>)reader.iterator());
            expectedRows = expected.iterator();
            while (expectedRows.hasNext()) {
                ((IteratorAssert)Assertions.assertThat((Iterator)actualRows2).as("Should have expected number of rows", new Object[0])).hasNext();
                TestHelpers.assertEquals(schema, expectedRows.next(), actualRows2.next());
            }
            ((IteratorAssert)Assertions.assertThat((Iterator)actualRows2).as("Should not have extra rows", new Object[0])).isExhausted();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                TestSparkOrcReader.$closeResource(var5_5, (AutoCloseable)reader);
            }
        }
    }

    private Iterator<InternalRow> batchesToRows(Iterator<ColumnarBatch> batches) {
        return Iterators.concat((Iterator)Iterators.transform(batches, ColumnarBatch::rowIterator));
    }
}

