/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data.parquet.vectorized;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.Schema;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Function;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.parquet.vectorized.TestParquetVectorizedReads;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class TestParquetDictionaryEncodedVectorizedReads
extends TestParquetVectorizedReads {
    @Override
    Iterable<GenericData.Record> generateData(Schema schema, int numRecords, long seed, float nullPercentage, Function<GenericData.Record, GenericData.Record> transform) {
        Iterable data = RandomData.generateDictionaryEncodableData(schema, numRecords, seed, nullPercentage);
        return transform == IDENTITY ? data : Iterables.transform(data, transform);
    }

    @Override
    @Test
    @Disabled
    public void testVectorizedReadsWithNewContainers() throws IOException {
    }

    @Test
    public void testMixedDictionaryNonDictionaryReads() throws IOException {
        Schema schema = new Schema(SUPPORTED_PRIMITIVES.fields());
        File dictionaryEncodedFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dictionaryEncodedFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        Iterable<GenericData.Record> dictionaryEncodableData = RandomData.generateDictionaryEncodableData(schema, 10000, 0L, 0.05f);
        try (FileAppender<GenericData.Record> writer = this.getParquetWriter(schema, dictionaryEncodedFile);){
            writer.addAll(dictionaryEncodableData);
        }
        File plainEncodingFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)plainEncodingFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        Iterable<GenericData.Record> nonDictionaryData = RandomData.generate(schema, 10000, 0L, 0.05f);
        try (FileAppender<GenericData.Record> writer = this.getParquetWriter(schema, plainEncodingFile);){
            writer.addAll(nonDictionaryData);
        }
        int rowGroupSize = 0x8000000;
        File mixedFile = File.createTempFile("junit", null, this.temp.toFile());
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)mixedFile.delete()).as("Delete should succeed", new Object[0])).isTrue();
        Parquet.concat((Iterable)ImmutableList.of((Object)dictionaryEncodedFile, (Object)plainEncodingFile, (Object)dictionaryEncodedFile), (File)mixedFile, (int)rowGroupSize, (Schema)schema, (Map)ImmutableMap.of());
        this.assertRecordsMatch(schema, 30000, (Iterable<GenericData.Record>)FluentIterable.concat(dictionaryEncodableData, nonDictionaryData, dictionaryEncodableData), mixedFile, true, 10000);
    }
}

