/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.avro.generic.GenericData;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.source.BaseReader;
import org.apache.iceberg.spark.source.TestTables;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class TestBaseReader {
    @TempDir
    private Path temp;
    private Table table;

    @Test
    public void testClosureOnDataExhaustion() throws IOException {
        Integer totalTasks = 10;
        Integer recordPerTask = 10;
        List<FileScanTask> tasks = this.createFileScanTasks(totalTasks, recordPerTask);
        ClosureTrackingReader reader = new ClosureTrackingReader(this.table, tasks);
        int countRecords = 0;
        while (reader.next()) {
            ++countRecords;
            ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)reader.get())).as("Reader should return non-null value", new Object[0])).isNotNull();
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)(totalTasks * recordPerTask)).as("Reader returned incorrect number of records", new Object[0])).isEqualTo(countRecords);
        tasks.forEach(t -> ((AbstractBooleanAssert)Assertions.assertThat((Boolean)reader.isIteratorClosed((FileScanTask)t)).as("All iterators should be closed after read exhausion", new Object[0])).isTrue());
    }

    @Test
    public void testClosureDuringIteration() throws IOException {
        Integer totalTasks = 2;
        Integer recordPerTask = 1;
        List<FileScanTask> tasks = this.createFileScanTasks(totalTasks, recordPerTask);
        Assertions.assertThat(tasks).hasSize(2);
        FileScanTask firstTask = tasks.get(0);
        FileScanTask secondTask = tasks.get(1);
        ClosureTrackingReader reader = new ClosureTrackingReader(this.table, tasks);
        Assertions.assertThat((boolean)reader.next()).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)reader.isIteratorClosed(firstTask)).as("First iter should not be closed on its last element", new Object[0])).isFalse();
        Assertions.assertThat((boolean)reader.next()).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)reader.isIteratorClosed(firstTask)).as("First iter should be closed after moving to second iter", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((Boolean)reader.isIteratorClosed(secondTask)).as("Second iter should not be closed on its last element", new Object[0])).isFalse();
        Assertions.assertThat((boolean)reader.next()).isFalse();
        Assertions.assertThat((Boolean)reader.isIteratorClosed(firstTask)).isTrue();
        Assertions.assertThat((Boolean)reader.isIteratorClosed(secondTask)).isTrue();
    }

    @Test
    public void testClosureWithoutAnyRead() throws IOException {
        Integer totalTasks = 10;
        Integer recordPerTask = 10;
        List<FileScanTask> tasks = this.createFileScanTasks(totalTasks, recordPerTask);
        ClosureTrackingReader reader = new ClosureTrackingReader(this.table, tasks);
        reader.close();
        tasks.forEach(t -> ((AbstractBooleanAssert)Assertions.assertThat((Boolean)reader.hasIterator((FileScanTask)t)).as("Iterator should not be created eagerly for tasks", new Object[0])).isFalse());
    }

    @Test
    public void testExplicitClosure() throws IOException {
        Integer totalTasks = 10;
        Integer recordPerTask = 10;
        List<FileScanTask> tasks = this.createFileScanTasks(totalTasks, recordPerTask);
        ClosureTrackingReader reader = new ClosureTrackingReader(this.table, tasks);
        Integer halfDataSize = totalTasks * recordPerTask / 2;
        for (int i = 0; i < halfDataSize; ++i) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)reader.next()).as("Reader should have some element", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)reader.get())).as("Reader should return non-null value", new Object[0])).isNotNull();
        }
        reader.close();
        tasks.forEach(t -> {
            if (reader.hasIterator((FileScanTask)t).booleanValue()) {
                ((AbstractBooleanAssert)Assertions.assertThat((Boolean)reader.isIteratorClosed((FileScanTask)t)).as("Iterator should be closed after read exhausion", new Object[0])).isTrue();
            }
        });
    }

    @Test
    public void testIdempotentExplicitClosure() throws IOException {
        Integer totalTasks = 10;
        Integer recordPerTask = 10;
        List<FileScanTask> tasks = this.createFileScanTasks(totalTasks, recordPerTask);
        ClosureTrackingReader reader = new ClosureTrackingReader(this.table, tasks);
        for (int i = 0; i < 45; ++i) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)reader.next()).as("Reader should have some element", new Object[0])).isTrue();
            ((AbstractIntegerAssert)Assertions.assertThat((Integer)((Integer)reader.get())).as("Reader should return non-null value", new Object[0])).isNotNull();
        }
        for (int closeAttempt = 0; closeAttempt < 5; ++closeAttempt) {
            int i;
            reader.close();
            for (i = 0; i < 5; ++i) {
                ((AbstractBooleanAssert)Assertions.assertThat((Boolean)reader.isIteratorClosed(tasks.get(i))).as("Iterator should be closed after read exhausion", new Object[0])).isTrue();
            }
            for (i = 5; i < 10; ++i) {
                ((AbstractBooleanAssert)Assertions.assertThat((Boolean)reader.hasIterator(tasks.get(i))).as("Iterator should not be created eagerly for tasks", new Object[0])).isFalse();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<FileScanTask> createFileScanTasks(Integer totalTasks, Integer recordPerTask) throws IOException {
        String desc = "make_scan_tasks";
        File parent = this.temp.resolve(desc).toFile();
        File location = new File(parent, "test");
        File dataFolder = new File(location, "data");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dataFolder.mkdirs()).as("mkdirs should succeed", new Object[0])).isTrue();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        try {
            this.table = TestTables.create(location, desc, schema, PartitionSpec.unpartitioned());
            Schema tableSchema = this.table.schema();
            List<GenericData.Record> expected = RandomData.generateList(tableSchema, recordPerTask, 1L);
            AppendFiles appendFiles = this.table.newAppend();
            for (int i = 0; i < totalTasks; ++i) {
                File parquetFile = new File(dataFolder, FileFormat.PARQUET.addExtension(UUID.randomUUID().toString()));
                try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)parquetFile)).schema(tableSchema).build();){
                    writer.addAll(expected);
                }
                DataFile file = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withFileSizeInBytes(parquetFile.length()).withPath(parquetFile.toString()).withRecordCount((long)recordPerTask.intValue()).build();
                appendFiles.appendFile(file);
            }
            appendFiles.commit();
            List<FileScanTask> list = StreamSupport.stream(this.table.newScan().planFiles().spliterator(), false).collect(Collectors.toList());
            return list;
        }
        finally {
            TestTables.clearTables();
        }
    }

    private static class ClosureTrackingReader
    extends BaseReader<Integer, FileScanTask> {
        private Map<String, CloseableIntegerRange> tracker = Maps.newHashMap();

        ClosureTrackingReader(Table table, List<FileScanTask> tasks) {
            super(table, (ScanTaskGroup)new BaseCombinedScanTask(tasks), null, null, false);
        }

        protected Stream<ContentFile<?>> referencedFiles(FileScanTask task) {
            return Stream.of(new ContentFile[0]);
        }

        protected CloseableIterator<Integer> open(FileScanTask task) {
            CloseableIntegerRange intRange = new CloseableIntegerRange(((DataFile)task.file()).recordCount());
            this.tracker.put(this.getKey(task), intRange);
            return intRange;
        }

        public Boolean isIteratorClosed(FileScanTask task) {
            return this.tracker.get((Object)this.getKey((FileScanTask)task)).closed;
        }

        public Boolean hasIterator(FileScanTask task) {
            return this.tracker.containsKey(this.getKey(task));
        }

        private String getKey(FileScanTask task) {
            return ((DataFile)task.file()).path().toString();
        }
    }

    private static class CloseableIntegerRange
    implements CloseableIterator<Integer> {
        boolean closed = false;
        Iterator<Integer> iter;

        CloseableIntegerRange(long range) {
            this.iter = IntStream.range(0, (int)range).iterator();
        }

        public void close() {
            this.closed = true;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Integer next() {
            return this.iter.next();
        }
    }
}

