/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Collection;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.TestBaseWithCatalog;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.internal.SQLConf;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestDataFrameWriterV2
extends TestBaseWithCatalog {
    @BeforeEach
    public void createTable() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testMergeSchemaFailsWithoutWriterOption() throws Exception {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema");
        Dataset<Row> twoColDF = this.jsonToDF("id bigint, data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        twoColDF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial 2-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b")), this.sql("select * from %s order by id", this.tableName));
        Dataset<Row> threeColDF = this.jsonToDF("id bigint, data string, new_col float", "{ \"id\": 3, \"data\": \"c\", \"new_col\": 12.06 }", "{ \"id\": 4, \"data\": \"d\", \"new_col\": 14.41 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> threeColDF.writeTo(this.tableName).append()).isInstanceOf(IllegalArgumentException.class)).hasMessage("Field new_col not found in source schema");
    }

    @TestTemplate
    public void testMergeSchemaWithoutAcceptAnySchema() throws Exception {
        Dataset<Row> twoColDF = this.jsonToDF("id bigint, data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        twoColDF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial 2-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b")), this.sql("select * from %s order by id", this.tableName));
        Dataset<Row> threeColDF = this.jsonToDF("id bigint, data string, new_col float", "{ \"id\": 3, \"data\": \"c\", \"new_col\": 12.06 }", "{ \"id\": 4, \"data\": \"d\", \"new_col\": 14.41 }");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> threeColDF.writeTo(this.tableName).option("merge-schema", "true").append()).isInstanceOf(AnalysisException.class)).hasMessageContaining("Cannot write to `testhadoop`.`default`.`table`, the reason is too many data columns");
    }

    @TestTemplate
    public void testMergeSchemaSparkProperty() throws Exception {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema");
        Dataset<Row> twoColDF = this.jsonToDF("id bigint, data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        twoColDF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial 2-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b")), this.sql("select * from %s order by id", this.tableName));
        Dataset<Row> threeColDF = this.jsonToDF("id bigint, data string, new_col float", "{ \"id\": 3, \"data\": \"c\", \"new_col\": 12.06 }", "{ \"id\": 4, \"data\": \"d\", \"new_col\": 14.41 }");
        threeColDF.writeTo(this.tableName).option("mergeSchema", "true").append();
        this.assertEquals("Should have 3-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a", null), (Object)this.row(2L, "b", null), (Object)this.row(3L, "c", Float.valueOf(12.06f)), (Object)this.row(4L, "d", Float.valueOf(14.41f))), this.sql("select * from %s order by id", this.tableName));
    }

    @TestTemplate
    public void testMergeSchemaIcebergProperty() throws Exception {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema");
        Dataset<Row> twoColDF = this.jsonToDF("id bigint, data string", "{ \"id\": 1, \"data\": \"a\" }", "{ \"id\": 2, \"data\": \"b\" }");
        twoColDF.writeTo(this.tableName).append();
        this.assertEquals("Should have initial 2-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b")), this.sql("select * from %s order by id", this.tableName));
        Dataset<Row> threeColDF = this.jsonToDF("id bigint, data string, new_col float", "{ \"id\": 3, \"data\": \"c\", \"new_col\": 12.06 }", "{ \"id\": 4, \"data\": \"d\", \"new_col\": 14.41 }");
        threeColDF.writeTo(this.tableName).option("merge-schema", "true").append();
        this.assertEquals("Should have 3-column rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a", null), (Object)this.row(2L, "b", null), (Object)this.row(3L, "c", Float.valueOf(12.06f)), (Object)this.row(4L, "d", Float.valueOf(14.41f))), this.sql("select * from %s order by id", this.tableName));
    }

    @TestTemplate
    public void testWriteWithCaseSensitiveOption() throws NoSuchTableException, ParseException {
        SparkSession sparkSession = spark.cloneSession();
        sparkSession.sql(String.format("ALTER TABLE %s SET TBLPROPERTIES ('%s'='true')", this.tableName, "write.spark.accept-any-schema")).collect();
        String schema = "ID bigint, DaTa string";
        ImmutableList records = ImmutableList.of((Object)"{ \"id\": 1, \"data\": \"a\" }", (Object)"{ \"id\": 2, \"data\": \"b\" }");
        sparkSession.sql(String.format("SET %s=false", SQLConf.CASE_SENSITIVE().key()));
        Dataset jsonDF = sparkSession.createDataset((List)ImmutableList.copyOf((Collection)records), Encoders.STRING());
        Dataset ds = sparkSession.read().schema(schema).json(jsonDF);
        ds.writeTo(this.tableName).option("merge-schema", "true").option("check-ordering", "false").append();
        List fields = Spark3Util.loadIcebergTable((SparkSession)sparkSession, (String)this.tableName).schema().asStruct().fields();
        Assertions.assertThat((List)fields).hasSize(2);
        sparkSession.sql(String.format("SET %s=true", SQLConf.CASE_SENSITIVE().key()));
        ds.writeTo(this.tableName).option("merge-schema", "true").option("check-ordering", "false").append();
        fields = Spark3Util.loadIcebergTable((SparkSession)sparkSession, (String)this.tableName).schema().asStruct().fields();
        Assertions.assertThat((List)fields).hasSize(4);
    }
}

