/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PlanningMode;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkTableUtil;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.source.LogMessage;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestIdentityPartitionData
extends TestBase {
    private static final Configuration CONF = new Configuration();
    private static final HadoopTables TABLES = new HadoopTables(CONF);
    @Parameter(index=0)
    private String format;
    @Parameter(index=1)
    private boolean vectorized;
    @Parameter(index=2)
    private Map<String, String> properties;
    private static final Schema LOG_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"date", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"level", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"message", (Type)Types.StringType.get())});
    private static final List<LogMessage> LOGS = ImmutableList.of((Object)LogMessage.debug("2020-02-02", "debug event 1"), (Object)LogMessage.info("2020-02-02", "info event 1"), (Object)LogMessage.debug("2020-02-02", "debug event 2"), (Object)LogMessage.info("2020-02-03", "info event 2"), (Object)LogMessage.debug("2020-02-03", "debug event 3"), (Object)LogMessage.info("2020-02-03", "info event 3"), (Object)LogMessage.error("2020-02-03", "error event 1"), (Object)LogMessage.debug("2020-02-04", "debug event 4"), (Object)LogMessage.warn("2020-02-04", "warn event 1"), (Object)LogMessage.debug("2020-02-04", "debug event 5"));
    @TempDir
    private Path temp;
    private PartitionSpec spec = PartitionSpec.builderFor((Schema)LOG_SCHEMA).identity("date").identity("level").build();
    private Table table = null;
    private Dataset<Row> logs = null;

    @Parameters(name="format = {0}, vectorized = {1}, properties = {2}")
    public static Object[][] parameters() {
        return new Object[][]{{"parquet", false, ImmutableMap.of((Object)"write.format.default", (Object)"parquet", (Object)"read.data-planning-mode", (Object)PlanningMode.LOCAL.modeName(), (Object)"read.delete-planning-mode", (Object)PlanningMode.LOCAL.modeName())}, {"parquet", true, ImmutableMap.of((Object)"write.format.default", (Object)"parquet", (Object)"read.data-planning-mode", (Object)PlanningMode.DISTRIBUTED.modeName(), (Object)"read.delete-planning-mode", (Object)PlanningMode.DISTRIBUTED.modeName())}, {"avro", false, ImmutableMap.of((Object)"write.format.default", (Object)"avro", (Object)"read.data-planning-mode", (Object)PlanningMode.LOCAL.modeName(), (Object)"read.delete-planning-mode", (Object)PlanningMode.LOCAL.modeName())}, {"orc", false, ImmutableMap.of((Object)"write.format.default", (Object)"orc", (Object)"read.data-planning-mode", (Object)PlanningMode.DISTRIBUTED.modeName(), (Object)"read.delete-planning-mode", (Object)PlanningMode.DISTRIBUTED.modeName())}, {"orc", true, ImmutableMap.of((Object)"write.format.default", (Object)"orc", (Object)"read.data-planning-mode", (Object)PlanningMode.LOCAL.modeName(), (Object)"read.delete-planning-mode", (Object)PlanningMode.LOCAL.modeName())}};
    }

    private void setupParquet() throws Exception {
        File location = Files.createTempDirectory(this.temp, "logs", new FileAttribute[0]).toFile();
        File hiveLocation = Files.createTempDirectory(this.temp, "hive", new FileAttribute[0]).toFile();
        String hiveTable = "hivetable";
        ((AbstractFileAssert)Assertions.assertThat((File)location).as("Temp folder should exist", new Object[0])).exists();
        this.logs = spark.createDataFrame(LOGS, LogMessage.class).select("id", new String[]{"date", "level", "message"});
        spark.sql(String.format("DROP TABLE IF EXISTS %s", hiveTable));
        this.logs.orderBy("date", new String[]{"level", "id"}).write().partitionBy(new String[]{"date", "level"}).format("parquet").option("path", hiveLocation.toString()).saveAsTable(hiveTable);
        this.table = TABLES.create(SparkSchemaUtil.schemaForTable((SparkSession)spark, (String)hiveTable), SparkSchemaUtil.specForTable((SparkSession)spark, (String)hiveTable), this.properties, location.toString());
        SparkTableUtil.importSparkTable((SparkSession)spark, (TableIdentifier)new TableIdentifier(hiveTable), (Table)this.table, (String)location.toString());
    }

    @BeforeEach
    public void setupTable() throws Exception {
        if (this.format.equals("parquet")) {
            this.setupParquet();
        } else {
            File location = Files.createTempDirectory(this.temp, "logs", new FileAttribute[0]).toFile();
            ((AbstractFileAssert)Assertions.assertThat((File)location).as("Temp folder should exist", new Object[0])).exists();
            this.table = TABLES.create(LOG_SCHEMA, this.spec, this.properties, location.toString());
            this.logs = spark.createDataFrame(LOGS, LogMessage.class).select("id", new String[]{"date", "level", "message"});
            this.logs.orderBy("date", new String[]{"level", "id"}).write().format("iceberg").mode("append").save(location.toString());
        }
    }

    @TestTemplate
    public void testFullProjection() {
        List expected = this.logs.orderBy("id", new String[0]).collectAsList();
        List actual = spark.read().format("iceberg").option("vectorization-enabled", String.valueOf(this.vectorized)).load(this.table.location()).orderBy("id", new String[0]).select("id", new String[]{"date", "level", "message"}).collectAsList();
        ((ListAssert)Assertions.assertThat((List)actual).as("Rows should match", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testProjections() {
        String[][] cases;
        for (Object[] objectArray : cases = new String[][]{{"date"}, {"level"}, {"message"}, {"date", "message"}, {"level", "message"}, {"date", "level"}, {"message", "date"}, {"message", "level"}, {"level", "date"}, {"date", "level", "message"}, {"level", "date", "message"}, {"date", "message", "level"}, {"level", "message", "date"}, {"message", "date", "level"}, {"message", "level", "date"}}) {
            List expected = this.logs.select("id", (String[])objectArray).orderBy("id", new String[0]).collectAsList();
            List actual = spark.read().format("iceberg").option("vectorization-enabled", String.valueOf(this.vectorized)).load(this.table.location()).select("id", (String[])objectArray).orderBy("id", new String[0]).collectAsList();
            ((ListAssert)Assertions.assertThat((List)actual).as("Rows should match for ordering: " + Arrays.toString(objectArray), new Object[0])).isEqualTo((Object)expected);
        }
    }
}

