/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.spark.data.ParameterizedAvroDataTest;
import org.apache.iceberg.spark.data.RandomData;
import org.apache.iceberg.spark.data.TestHelpers;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestParquetScan
extends ParameterizedAvroDataTest {
    private static final Configuration CONF = new Configuration();
    private static SparkSession spark = null;
    @TempDir
    private Path temp;
    @Parameter
    private boolean vectorized;

    @BeforeAll
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
    }

    @AfterAll
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        currentSpark.stop();
    }

    @Parameters(name="vectorized = {0}")
    public static Collection<Boolean> parameters() {
        return Arrays.asList(false, true);
    }

    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        ((ObjectAssert)Assumptions.assumeThat((Object)TypeUtil.find((Schema)schema, type -> type.isMapType() && type.asMapType().keyType() != Types.StringType.get())).as("Cannot handle non-string map keys in parquet-avro", new Object[0])).isNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.vectorized).as("should not be null", new Object[0])).isNotNull();
        Table table = this.createTable(schema);
        List<GenericData.Record> expected = RandomData.generateList(table.schema(), 100, 1L);
        this.writeRecords(table, expected);
        this.configureVectorization(table);
        Dataset df = spark.read().format("iceberg").load(table.location());
        List rows = df.collectAsList();
        ((ListAssert)Assertions.assertThat((List)rows).as("Should contain 100 rows", new Object[0])).hasSize(100);
        for (int i = 0; i < expected.size(); ++i) {
            TestHelpers.assertEqualsSafe(table.schema().asStruct(), expected.get(i), (Row)rows.get(i));
        }
    }

    @TestTemplate
    public void testEmptyTableProjection() throws IOException {
        Types.StructType structType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)102, (String)"b", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)103, (String)"i", (Type)Types.IntegerType.get())});
        Table table = this.createTable(new Schema(structType.fields()));
        List<GenericData.Record> expected = RandomData.generateList(table.schema(), 100, 1L);
        this.writeRecords(table, expected);
        this.configureVectorization(table);
        List rows = spark.read().format("iceberg").load(table.location()).select(new Column[]{functions.monotonically_increasing_id()}).collectAsList();
        Assertions.assertThat((List)rows).hasSize(100);
    }

    private Table createTable(Schema schema) throws IOException {
        File parent = this.temp.resolve("parquet").toFile();
        File location = new File(parent, "test");
        HadoopTables tables = new HadoopTables(CONF);
        return tables.create(schema, PartitionSpec.unpartitioned(), location.toString());
    }

    private void writeRecords(Table table, List<GenericData.Record> records) throws IOException {
        File dataFolder = new File(table.location(), "data");
        dataFolder.mkdirs();
        File parquetFile = new File(dataFolder, FileFormat.PARQUET.addExtension(UUID.randomUUID().toString()));
        try (FileAppender writer = Parquet.write((OutputFile)Files.localOutput((File)parquetFile)).schema(table.schema()).build();){
            writer.addAll(records);
        }
        DataFile file = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withFileSizeInBytes(parquetFile.length()).withPath(parquetFile.toString()).withRecordCount(100L).build();
        table.newAppend().appendFile(file).commit();
    }

    private void configureVectorization(Table table) {
        table.updateProperties().set("read.parquet.vectorization.enabled", String.valueOf(this.vectorized)).commit();
    }
}

