/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.HashMap;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundAggregate;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkAggregates;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.FieldReference;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.aggregate.AggregateFunc;
import org.apache.spark.sql.connector.expressions.aggregate.Count;
import org.apache.spark.sql.connector.expressions.aggregate.CountStar;
import org.apache.spark.sql.connector.expressions.aggregate.Max;
import org.apache.spark.sql.connector.expressions.aggregate.Min;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestSparkAggregates {
    @Test
    public void testAggregates() {
        HashMap attrMap = Maps.newHashMap();
        attrMap.put("id", "id");
        attrMap.put("`i.d`", "i.d");
        attrMap.put("`i``d`", "i`d");
        attrMap.put("`d`.b.`dd```", "d.b.dd`");
        attrMap.put("a.`aa```.c", "a.aa`.c");
        attrMap.forEach((quoted, unquoted) -> {
            NamedReference namedReference = FieldReference.apply((String)quoted);
            Max max = new Max((Expression)namedReference);
            UnboundAggregate expectedMax = Expressions.max((String)unquoted);
            org.apache.iceberg.expressions.Expression actualMax = SparkAggregates.convert((AggregateFunc)max);
            ((AbstractStringAssert)Assertions.assertThat((String)String.valueOf(actualMax)).as("Max must match", new Object[0])).isEqualTo(expectedMax.toString());
            Min min = new Min((Expression)namedReference);
            UnboundAggregate expectedMin = Expressions.min((String)unquoted);
            org.apache.iceberg.expressions.Expression actualMin = SparkAggregates.convert((AggregateFunc)min);
            ((AbstractStringAssert)Assertions.assertThat((String)String.valueOf(actualMin)).as("Min must match", new Object[0])).isEqualTo(expectedMin.toString());
            Count count = new Count((Expression)namedReference, false);
            UnboundAggregate expectedCount = Expressions.count((String)unquoted);
            org.apache.iceberg.expressions.Expression actualCount = SparkAggregates.convert((AggregateFunc)count);
            ((AbstractStringAssert)Assertions.assertThat((String)String.valueOf(actualCount)).as("Count must match", new Object[0])).isEqualTo(expectedCount.toString());
            Count countDistinct = new Count((Expression)namedReference, true);
            org.apache.iceberg.expressions.Expression convertedCountDistinct = SparkAggregates.convert((AggregateFunc)countDistinct);
            ((ObjectAssert)Assertions.assertThat((Object)convertedCountDistinct).as("Count Distinct is converted to null", new Object[0])).isNull();
            CountStar countStar = new CountStar();
            UnboundAggregate expectedCountStar = Expressions.countStar();
            org.apache.iceberg.expressions.Expression actualCountStar = SparkAggregates.convert((AggregateFunc)countStar);
            ((AbstractStringAssert)Assertions.assertThat((String)String.valueOf(actualCountStar)).as("CountStar must match", new Object[0])).isEqualTo(expectedCountStar.toString());
        });
    }
}

