/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestMergingMetrics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.SparkAppenderFactory;
import org.apache.iceberg.spark.source.StructInternalRow;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public class TestSparkMergingMetrics
extends TestMergingMetrics<InternalRow> {
    public TestSparkMergingMetrics(FileFormat fileFormat) {
        super(fileFormat);
    }

    protected FileAppender<InternalRow> writeAndGetAppender(List<Record> records) throws IOException {
        FileAppender appender;
        BaseTable testTable = new BaseTable(null, "dummy"){

            public Map<String, String> properties() {
                return Collections.emptyMap();
            }

            public SortOrder sortOrder() {
                return SortOrder.unsorted();
            }

            public PartitionSpec spec() {
                return PartitionSpec.unpartitioned();
            }
        };
        try (FileAppender fileAppender = appender = SparkAppenderFactory.builderFor((Table)testTable, (Schema)SCHEMA, (StructType)SparkSchemaUtil.convert((Schema)SCHEMA)).build().newAppender(Files.localOutput((File)this.temp.newFile()), this.fileFormat);){
            records.stream().map(r -> new StructInternalRow(SCHEMA.asStruct()).setStruct((StructLike)r)).forEach(arg_0 -> ((FileAppender)fileAppender).add(arg_0));
        }
        return appender;
    }
}

