/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.List;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.TestPositionDeltaWriters;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.InternalRowWrapper;
import org.apache.iceberg.spark.source.SparkFileWriterFactory;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class TestSparkPositionDeltaWriters
extends TestPositionDeltaWriters<InternalRow> {
    public TestSparkPositionDeltaWriters(FileFormat fileFormat) {
        super(fileFormat);
    }

    protected FileWriterFactory<InternalRow> newWriterFactory(Schema dataSchema, List<Integer> equalityFieldIds, Schema equalityDeleteRowSchema, Schema positionDeleteRowSchema) {
        return SparkFileWriterFactory.builderFor((Table)this.table).dataSchema(this.table.schema()).dataFileFormat(this.format()).deleteFileFormat(this.format()).equalityFieldIds(ArrayUtil.toIntArray(equalityFieldIds)).equalityDeleteRowSchema(equalityDeleteRowSchema).positionDeleteRowSchema(positionDeleteRowSchema).build();
    }

    protected InternalRow toRow(Integer id, String data) {
        GenericInternalRow row = new GenericInternalRow(2);
        row.update(0, (Object)id);
        row.update(1, (Object)UTF8String.fromString((String)data));
        return row;
    }

    protected StructLikeSet toSet(Iterable<InternalRow> rows) {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        StructType sparkType = SparkSchemaUtil.convert((Schema)this.table.schema());
        for (InternalRow row : rows) {
            InternalRowWrapper wrapper = new InternalRowWrapper(sparkType);
            set.add((StructLike)wrapper.wrap(row));
        }
        return set;
    }
}

