/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import org.apache.iceberg.spark.source.StreamingOffset;
import org.apache.iceberg.util.JsonUtil;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.Test;

public class TestStreamingOffset {
    @Test
    public void testJsonConversion() {
        StreamingOffset[] expected = new StreamingOffset[]{new StreamingOffset(System.currentTimeMillis(), 1L, false), new StreamingOffset(System.currentTimeMillis(), 2L, false), new StreamingOffset(System.currentTimeMillis(), 3L, false), new StreamingOffset(System.currentTimeMillis(), 4L, true)};
        ((ObjectArrayAssert)Assertions.assertThat((Object[])Arrays.stream(expected).map(elem -> StreamingOffset.fromJson((String)elem.json())).toArray()).as("StreamingOffsets should match", new Object[0])).isEqualTo((Object)expected);
    }

    @Test
    public void testToJson() throws Exception {
        StreamingOffset expected = new StreamingOffset(System.currentTimeMillis(), 1L, false);
        ObjectNode actual = JsonUtil.mapper().createObjectNode();
        actual.put("version", 1);
        actual.put("snapshot_id", expected.snapshotId());
        actual.put("position", 1L);
        actual.put("scan_all_files", false);
        String expectedJson = expected.json();
        String actualJson = JsonUtil.mapper().writeValueAsString((Object)actual);
        Assertions.assertThat((String)actualJson).isEqualTo(expectedJson);
    }
}

