/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.TestBase;
import org.apache.iceberg.spark.data.GenericsHelpers;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestTimestampWithoutZone
extends TestBase {
    private static final Configuration CONF = new Configuration();
    private static final HadoopTables TABLES = new HadoopTables(CONF);
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)3, (String)"data", (Type)Types.StringType.get())});
    private static SparkSession spark = null;
    @TempDir
    private Path temp;
    @Parameter(index=0)
    private String format;
    @Parameter(index=1)
    private boolean vectorized;
    private File parent = null;
    private File unpartitioned = null;
    private List<Record> records = null;

    @BeforeAll
    public static void startSpark() {
        spark = SparkSession.builder().master("local[2]").getOrCreate();
    }

    @AfterAll
    public static void stopSpark() {
        SparkSession currentSpark = spark;
        spark = null;
        currentSpark.stop();
    }

    @Parameters(name="format = {0}, vectorized = {1}")
    public static Object[][] parameters() {
        return new Object[][]{{"parquet", false}, {"parquet", true}, {"avro", false}};
    }

    @BeforeEach
    public void writeUnpartitionedTable() throws IOException {
        this.parent = this.temp.resolve("TestTimestampWithoutZone").toFile();
        this.unpartitioned = new File(this.parent, "unpartitioned");
        File dataFolder = new File(this.unpartitioned, "data");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dataFolder.mkdirs()).as("Mkdir should succeed", new Object[0])).isTrue();
        Table table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), this.unpartitioned.toString());
        Schema tableSchema = table.schema();
        FileFormat fileFormat = FileFormat.fromString((String)this.format);
        File testFile = new File(dataFolder, fileFormat.addExtension(UUID.randomUUID().toString()));
        this.records = this.testRecords(tableSchema);
        try (FileAppender writer = new GenericAppenderFactory(tableSchema).newAppender(Files.localOutput((File)testFile), fileFormat);){
            writer.addAll(this.records);
        }
        DataFile file = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withRecordCount((long)this.records.size()).withFileSizeInBytes(testFile.length()).withPath(testFile.toString()).build();
        table.newAppend().appendFile(file).commit();
    }

    @TestTemplate
    public void testUnpartitionedTimestampWithoutZone() {
        TestTimestampWithoutZone.assertEqualsSafe(SCHEMA.asStruct(), this.records, TestTimestampWithoutZone.read(this.unpartitioned.toString(), this.vectorized));
    }

    @TestTemplate
    public void testUnpartitionedTimestampWithoutZoneProjection() {
        Schema projection = SCHEMA.select(new String[]{"id", "ts"});
        TestTimestampWithoutZone.assertEqualsSafe(projection.asStruct(), this.records.stream().map(r -> TestTimestampWithoutZone.projectFlat(projection, r)).collect(Collectors.toList()), TestTimestampWithoutZone.read(this.unpartitioned.toString(), this.vectorized, "id", "ts"));
    }

    @TestTemplate
    public void testUnpartitionedTimestampWithoutZoneAppend() {
        spark.read().format("iceberg").option("vectorization-enabled", String.valueOf(this.vectorized)).load(this.unpartitioned.toString()).write().format("iceberg").mode(SaveMode.Append).save(this.unpartitioned.toString());
        TestTimestampWithoutZone.assertEqualsSafe(SCHEMA.asStruct(), Stream.concat(this.records.stream(), this.records.stream()).collect(Collectors.toList()), TestTimestampWithoutZone.read(this.unpartitioned.toString(), this.vectorized));
    }

    private static Record projectFlat(Schema projection, Record record) {
        GenericRecord result = GenericRecord.create((Schema)projection);
        List fields = projection.asStruct().fields();
        for (int i = 0; i < fields.size(); ++i) {
            Types.NestedField field = (Types.NestedField)fields.get(i);
            result.set(i, record.getField(field.name()));
        }
        return result;
    }

    public static void assertEqualsSafe(Types.StructType struct, List<Record> expected, List<Row> actual) {
        ((ListAssert)Assertions.assertThat(actual).as("Number of results should match expected", new Object[0])).hasSameSizeAs(expected);
        for (int i = 0; i < expected.size(); ++i) {
            GenericsHelpers.assertEqualsSafe(struct, expected.get(i), actual.get(i));
        }
    }

    private List<Record> testRecords(Schema schema) {
        return Lists.newArrayList((Object[])new Record[]{TestTimestampWithoutZone.record(schema, 0L, TestTimestampWithoutZone.parseToLocal("2017-12-22T09:20:44.294658"), "junction"), TestTimestampWithoutZone.record(schema, 1L, TestTimestampWithoutZone.parseToLocal("2017-12-22T07:15:34.582910"), "alligator"), TestTimestampWithoutZone.record(schema, 2L, TestTimestampWithoutZone.parseToLocal("2017-12-22T06:02:09.243857"), "forrest"), TestTimestampWithoutZone.record(schema, 3L, TestTimestampWithoutZone.parseToLocal("2017-12-22T03:10:11.134509"), "clapping"), TestTimestampWithoutZone.record(schema, 4L, TestTimestampWithoutZone.parseToLocal("2017-12-22T00:34:00.184671"), "brush"), TestTimestampWithoutZone.record(schema, 5L, TestTimestampWithoutZone.parseToLocal("2017-12-21T22:20:08.935889"), "trap"), TestTimestampWithoutZone.record(schema, 6L, TestTimestampWithoutZone.parseToLocal("2017-12-21T21:55:30.589712"), "element"), TestTimestampWithoutZone.record(schema, 7L, TestTimestampWithoutZone.parseToLocal("2017-12-21T17:31:14.532797"), "limited"), TestTimestampWithoutZone.record(schema, 8L, TestTimestampWithoutZone.parseToLocal("2017-12-21T15:21:51.237521"), "global"), TestTimestampWithoutZone.record(schema, 9L, TestTimestampWithoutZone.parseToLocal("2017-12-21T15:02:15.230570"), "goldfish")});
    }

    private static List<Row> read(String table, boolean vectorized) {
        return TestTimestampWithoutZone.read(table, vectorized, "*", new String[0]);
    }

    private static List<Row> read(String table, boolean vectorized, String select0, String ... selectN) {
        Dataset dataset = spark.read().format("iceberg").option("vectorization-enabled", String.valueOf(vectorized)).load(table).select(select0, selectN);
        return dataset.collectAsList();
    }

    private static LocalDateTime parseToLocal(String timestamp) {
        return LocalDateTime.parse(timestamp);
    }

    private static Record record(Schema schema, Object ... values) {
        GenericRecord rec = GenericRecord.create((Schema)schema);
        for (int i = 0; i < values.length; ++i) {
            rec.set(i, values[i]);
        }
        return rec;
    }
}

