/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.Arrays;
import java.util.List;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.functions;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public abstract class PartitionedWritesTestBase
extends CatalogTestBase {
    @BeforeEach
    public void createTables() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (truncate(id, 3))", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, 'a'), (2, 'b'), (3, 'c')", this.tableName);
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testInsertAppend() {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 5 rows after insert", new Object[0])).isEqualTo((Object)3L);
        this.sql("INSERT INTO %s VALUES (4, 'd'), (5, 'e')", this.commitTarget());
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 5 rows after insert", new Object[0])).isEqualTo((Object)5L);
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @TestTemplate
    public void testInsertOverwrite() {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 5 rows after insert", new Object[0])).isEqualTo((Object)3L);
        this.sql("INSERT OVERWRITE %s VALUES (4, 'd'), (5, 'e')", this.commitTarget());
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 4 rows after overwrite", new Object[0])).isEqualTo((Object)4L);
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @TestTemplate
    public void testDataFrameV2Append() throws NoSuchTableException {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 3 rows", new Object[0])).isEqualTo((Object)3L);
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.commitTarget()).append();
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 5 rows after insert", new Object[0])).isEqualTo((Object)5L);
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @TestTemplate
    public void testDataFrameV2DynamicOverwrite() throws NoSuchTableException {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 3 rows", new Object[0])).isEqualTo((Object)3L);
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.commitTarget()).overwritePartitions();
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 4 rows after overwrite", new Object[0])).isEqualTo((Object)4L);
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @TestTemplate
    public void testDataFrameV2Overwrite() throws NoSuchTableException {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 3 rows", new Object[0])).isEqualTo((Object)3L);
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.commitTarget()).overwrite(functions.col((String)"id").$less((Object)3));
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 3 rows after overwrite", new Object[0])).isEqualTo((Object)3L);
        ImmutableList expected = ImmutableList.of((Object)this.row(3L, "c"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @TestTemplate
    public void testViewsReturnRecentResults() {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 3 rows", new Object[0])).isEqualTo((Object)3L);
        Dataset query = spark.sql("SELECT * FROM " + this.commitTarget() + " WHERE id = 1");
        query.createOrReplaceTempView("tmp");
        this.assertEquals("View should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a")), this.sql("SELECT * FROM tmp", new Object[0]));
        this.sql("INSERT INTO TABLE %s VALUES (1, 'a')", this.commitTarget());
        this.assertEquals("View should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(1L, "a")), this.sql("SELECT * FROM tmp", new Object[0]));
    }

    protected void assertPartitionMetadata(String tableName, List<Object[]> expected, String ... selectPartitionColumns) {
        String[] fullyQualifiedCols = (String[])Arrays.stream(selectPartitionColumns).map(s -> "partition." + s).toArray(String[]::new);
        Dataset actualPartitionRows = spark.read().format("iceberg").load(tableName + ".partitions").select("spec_id", fullyQualifiedCols).orderBy("spec_id", fullyQualifiedCols);
        this.assertEquals("There are 3 partitions, one with the original spec ID and two with the new one", expected, this.rowsToJava(actualPartitionRows.collectAsList()));
    }

    @TestTemplate
    public void testWriteWithOutputSpec() throws NoSuchTableException {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.newDelete().deleteFromRowFilter((Expression)Expressions.alwaysTrue()).commit();
        int originalSpecId = table.spec().specId();
        table.updateSpec().addField("data").commit();
        this.sql("REFRESH TABLE %s", this.tableName);
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(10, "a"));
        spark.createDataFrame((List)data, SimpleRecord.class).toDF().writeTo(this.tableName).append();
        ImmutableList expected = ImmutableList.of((Object)this.row(10L, "a", table.spec().specId()));
        this.assertEquals("Rows must match", (List<Object[]>)expected, this.sql("SELECT id, data, _spec_id FROM %s WHERE id >= 10 ORDER BY id", this.tableName));
        data = ImmutableList.of((Object)new SimpleRecord(11, "b"), (Object)new SimpleRecord(12, "c"));
        spark.createDataFrame((List)data, SimpleRecord.class).toDF().writeTo(this.tableName).option("output-spec-id", Integer.toString(originalSpecId)).append();
        expected = ImmutableList.of((Object)this.row(10L, "a", table.spec().specId()), (Object)this.row(11L, "b", originalSpecId), (Object)this.row(12L, "c", originalSpecId));
        this.assertEquals("Rows must match", (List<Object[]>)expected, this.sql("SELECT id, data, _spec_id FROM %s WHERE id >= 10 ORDER BY id", this.tableName));
        expected = ImmutableList.of((Object)this.row(originalSpecId, 9L, null), (Object)this.row(originalSpecId, 12L, null), (Object)this.row(table.spec().specId(), 9L, "a"));
        this.assertPartitionMetadata(this.tableName, (List<Object[]>)expected, "id_trunc", "data");
        data = ImmutableList.of((Object)new SimpleRecord(13, "d"));
        spark.createDataFrame((List)data, SimpleRecord.class).toDF().writeTo(this.tableName).option("output-spec-id", Integer.toString(table.spec().specId())).append();
        expected = ImmutableList.of((Object)this.row(10L, "a", table.spec().specId()), (Object)this.row(11L, "b", originalSpecId), (Object)this.row(12L, "c", originalSpecId), (Object)this.row(13L, "d", table.spec().specId()));
        this.assertEquals("Rows must match", (List<Object[]>)expected, this.sql("SELECT id, data, _spec_id FROM %s WHERE id >= 10 ORDER BY id", this.tableName));
    }
}

