/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestTemplate;

public class TestCreateTable
extends CatalogTestBase {
    @AfterEach
    public void dropTestTable() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testTransformIgnoreCase() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE IF NOT EXISTS %s (id BIGINT NOT NULL, ts timestamp) USING iceberg partitioned by (HOURS(ts))", this.tableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should already exist", new Object[0])).isTrue();
        this.sql("CREATE TABLE IF NOT EXISTS %s (id BIGINT NOT NULL, ts timestamp) USING iceberg partitioned by (hours(ts))", this.tableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should already exist", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testTransformSingularForm() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE IF NOT EXISTS %s (id BIGINT NOT NULL, ts timestamp) USING iceberg partitioned by (hour(ts))", this.tableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should exist", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testTransformPluralForm() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE IF NOT EXISTS %s (id BIGINT NOT NULL, ts timestamp) USING iceberg partitioned by (hours(ts))", this.tableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should exist", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testCreateTable() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)table).as("Should load the new table", new Object[0])).isNotNull();
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)table.schema().asStruct()).as("Should have the expected schema", new Object[0])).isEqualTo((Object)expectedSchema);
        ((ListAssert)Assertions.assertThat((List)table.spec().fields()).as("Should not be partitioned", new Object[0])).hasSize(0);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("write.format.default"))).as("Should not have the default format set", new Object[0])).isNull();
    }

    @TestTemplate
    public void testCreateTableInRootNamespace() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalogName).as("Hadoop has no default namespace configured", new Object[0])).isEqualTo("testhadoop");
        try {
            this.sql("CREATE TABLE %s.table (id bigint) USING iceberg", this.catalogName);
        }
        catch (Throwable throwable) {
            this.sql("DROP TABLE IF EXISTS %s.table", this.catalogName);
            throw throwable;
        }
        this.sql("DROP TABLE IF EXISTS %s.table", this.catalogName);
    }

    @TestTemplate
    public void testCreateTableUsingParquet() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalogName).as("Not working with session catalog because Spark will not use v2 for a Parquet table", new Object[0])).isNotEqualTo((Object)"spark_catalog");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING parquet", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)table).as("Should load the new table", new Object[0])).isNotNull();
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)table.schema().asStruct()).as("Should have the expected schema", new Object[0])).isEqualTo((Object)expectedSchema);
        ((ListAssert)Assertions.assertThat((List)table.spec().fields()).as("Should not be partitioned", new Object[0])).hasSize(0);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("write.format.default"))).as("Should not have default format parquet", new Object[0])).isEqualTo("parquet");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("CREATE TABLE %s.default.fail (id BIGINT NOT NULL, data STRING) USING crocodile", this.catalogName)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unsupported format in USING: crocodile");
    }

    @TestTemplate
    public void testCreateTablePartitionedBy() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, created_at TIMESTAMP, category STRING, data STRING) USING iceberg PARTITIONED BY (category, bucket(8, id), days(created_at))", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)table).as("Should load the new table", new Object[0])).isNotNull();
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"created_at", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)3, (String)"category", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)table.schema().asStruct()).as("Should have the expected schema", new Object[0])).isEqualTo((Object)expectedSchema);
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)new Schema(expectedSchema.fields())).identity("category").bucket("id", 8).day("created_at").build();
        ((ObjectAssert)Assertions.assertThat((Object)table.spec()).as("Should be partitioned correctly", new Object[0])).isEqualTo((Object)expectedSpec);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("write.format.default"))).as("Should not have the default format set", new Object[0])).isNull();
    }

    @TestTemplate
    public void testCreateTableColumnComments() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL COMMENT 'Unique identifier', data STRING COMMENT 'Data value') USING iceberg", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)table).as("Should load the new table", new Object[0])).isNotNull();
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get(), (String)"Unique identifier"), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get(), (String)"Data value")});
        ((ObjectAssert)Assertions.assertThat((Object)table.schema().asStruct()).as("Should have the expected schema", new Object[0])).isEqualTo((Object)expectedSchema);
        ((ListAssert)Assertions.assertThat((List)table.spec().fields()).as("Should not be partitioned", new Object[0])).hasSize(0);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("write.format.default"))).as("Should not have the default format set", new Object[0])).isNull();
    }

    @TestTemplate
    public void testCreateTableComment() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg COMMENT 'Table doc'", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)table).as("Should load the new table", new Object[0])).isNotNull();
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)table.schema().asStruct()).as("Should have the expected schema", new Object[0])).isEqualTo((Object)expectedSchema);
        ((ListAssert)Assertions.assertThat((List)table.spec().fields()).as("Should not be partitioned", new Object[0])).hasSize(0);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("write.format.default"))).as("Should not have the default format set", new Object[0])).isNull();
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("comment"))).as("Should have the table comment set in properties", new Object[0])).isEqualTo("Table doc");
    }

    @TestTemplate
    public void testCreateTableLocation() throws Exception {
        ((ObjectAssert)Assumptions.assumeThat((Object)this.validationCatalog).as("Cannot set custom locations for Hadoop catalog tables", new Object[0])).isNotInstanceOf(HadoopCatalog.class);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        File tableLocation = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        Assertions.assertThat((boolean)tableLocation.delete()).isTrue();
        String location = "file:" + tableLocation.toString();
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg LOCATION '%s'", this.tableName, location);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)table).as("Should load the new table", new Object[0])).isNotNull();
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)table.schema().asStruct()).as("Should have the expected schema", new Object[0])).isEqualTo((Object)expectedSchema);
        ((ListAssert)Assertions.assertThat((List)table.spec().fields()).as("Should not be partitioned", new Object[0])).hasSize(0);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)table.properties().get("write.format.default"))).as("Should not have the default format set", new Object[0])).isNull();
        ((AbstractStringAssert)Assertions.assertThat((String)table.location()).as("Should have a custom table location", new Object[0])).isEqualTo(location);
    }

    @TestTemplate
    public void testCreateTableProperties() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg TBLPROPERTIES (p1=2, p2='x')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)table).as("Should load the new table", new Object[0])).isNotNull();
        Types.StructType expectedSchema = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        ((ObjectAssert)Assertions.assertThat((Object)table.schema().asStruct()).as("Should have the expected schema", new Object[0])).isEqualTo((Object)expectedSchema);
        ((ListAssert)Assertions.assertThat((List)table.spec().fields()).as("Should not be partitioned", new Object[0])).hasSize(0);
        ((MapAssert)Assertions.assertThat((Map)table.properties()).containsEntry((Object)"p1", (Object)"2")).containsEntry((Object)"p2", (Object)"x");
    }

    @TestTemplate
    public void testCreateTableWithFormatV2ThroughTableProperty() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg TBLPROPERTIES ('format-version'='2')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((BaseTable)table).operations().current().formatVersion()).as("should create table using format v2", new Object[0])).isEqualTo(2);
    }

    @TestTemplate
    public void testUpgradeTableWithFormatV2ThroughTableProperty() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg TBLPROPERTIES ('format-version'='1')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        TableOperations ops = ((BaseTable)table).operations();
        ((AbstractIntegerAssert)Assertions.assertThat((int)ops.refresh().formatVersion()).as("should create table using format v1", new Object[0])).isEqualTo(1);
        this.sql("ALTER TABLE %s SET TBLPROPERTIES ('format-version'='2')", this.tableName);
        ((AbstractIntegerAssert)Assertions.assertThat((int)ops.refresh().formatVersion()).as("should update table to use format v2", new Object[0])).isEqualTo(2);
    }

    @TestTemplate
    public void testDowngradeTableToFormatV1ThroughTablePropertyFails() {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not already exist", new Object[0])).isFalse();
        this.sql("CREATE TABLE %s (id BIGINT NOT NULL, data STRING) USING iceberg TBLPROPERTIES ('format-version'='2')", this.tableName);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        TableOperations ops = ((BaseTable)table).operations();
        ((AbstractIntegerAssert)Assertions.assertThat((int)ops.refresh().formatVersion()).as("should create table using format v2", new Object[0])).isEqualTo(2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("ALTER TABLE %s SET TBLPROPERTIES ('format-version'='1')", this.tableName)).cause().isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot downgrade v2 table to v1");
    }
}

