/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.List;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.functions;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestCreateTableAsSelect
extends CatalogTestBase {
    @Parameter(index=3)
    private String sourceName;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}, sourceName = {3}")
    protected static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HIVE.catalogName(), SparkCatalogConfig.HIVE.implementation(), SparkCatalogConfig.HIVE.properties(), SparkCatalogConfig.HIVE.catalogName() + ".default.source"}, {SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties(), SparkCatalogConfig.HADOOP.catalogName() + ".default.source"}, {SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties(), "default.source"}};
    }

    @BeforeEach
    public void createTableIfNotExists() {
        this.sql("CREATE TABLE IF NOT EXISTS %s (id bigint NOT NULL, data string) USING iceberg PARTITIONED BY (truncate(id, 3))", this.sourceName);
        this.sql("INSERT INTO %s VALUES (1, 'a'), (2, 'b'), (3, 'c'), (4, 'd'), (5, 'e')", this.sourceName);
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testUnpartitionedCTAS() {
        this.sql("CREATE TABLE %s USING iceberg AS SELECT * FROM %s", this.tableName, this.sourceName);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Table ctasTable = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)ctasTable.schema().asStruct()).as("Should have expected nullable schema", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        ((ListAssert)Assertions.assertThat((List)ctasTable.spec().fields()).as("Should be an unpartitioned table", new Object[0])).hasSize(0);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @TestTemplate
    public void testPartitionedCTAS() {
        this.sql("CREATE TABLE %s USING iceberg PARTITIONED BY (id) AS SELECT * FROM %s ORDER BY id", this.tableName, this.sourceName);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("id").build();
        Table ctasTable = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)ctasTable.schema().asStruct()).as("Should have expected nullable schema", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        ((ObjectAssert)Assertions.assertThat((Object)ctasTable.spec()).as("Should be partitioned by id", new Object[0])).isEqualTo((Object)expectedSpec);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @TestTemplate
    public void testCTASWriteDistributionModeRespected() {
        this.sql("CREATE TABLE %s USING iceberg PARTITIONED BY (bucket(2, id)) AS SELECT * FROM %s", this.tableName, this.sourceName);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).bucket("id", 2).build();
        Table ctasTable = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)ctasTable.schema().asStruct()).as("Should have expected nullable schema", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        ((ObjectAssert)Assertions.assertThat((Object)ctasTable.spec()).as("Should be partitioned by id", new Object[0])).isEqualTo((Object)expectedSpec);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @TestTemplate
    public void testRTAS() {
        this.sql("CREATE TABLE %s USING iceberg TBLPROPERTIES ('prop1'='val1', 'prop2'='val2')AS SELECT * FROM %s", this.tableName, this.sourceName);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        this.sql("REPLACE TABLE %s USING iceberg PARTITIONED BY (part) TBLPROPERTIES ('prop1'='newval1', 'prop3'='val3') AS SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY 3, 1", this.tableName, this.sourceName);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"part", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("part").withSpecId(1).build();
        Table rtasTable = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)rtasTable.schema().asStruct()).as("Should have expected nullable schema", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        ((ObjectAssert)Assertions.assertThat((Object)rtasTable.spec()).as("Should be partitioned by part", new Object[0])).isEqualTo((Object)expectedSpec);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        ((IterableAssert)Assertions.assertThat((Iterable)rtasTable.snapshots()).as("Table should have expected snapshots", new Object[0])).hasSize(2);
        ((AbstractStringAssert)Assertions.assertThat((String)((String)rtasTable.properties().get("prop1"))).as("Should have updated table property", new Object[0])).isEqualTo("newval1");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)rtasTable.properties().get("prop2"))).as("Should have preserved table property", new Object[0])).isEqualTo("val2");
        ((AbstractStringAssert)Assertions.assertThat((String)((String)rtasTable.properties().get("prop3"))).as("Should have new table property", new Object[0])).isEqualTo("val3");
    }

    @TestTemplate
    public void testCreateRTAS() {
        this.sql("CREATE OR REPLACE TABLE %s USING iceberg PARTITIONED BY (part) AS SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY 3, 1", this.tableName, this.sourceName);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        this.sql("CREATE OR REPLACE TABLE %s USING iceberg PARTITIONED BY (part) AS SELECT 2 * id as id, data, CASE WHEN ((2 * id) %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY 3, 1", this.tableName, this.sourceName);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"part", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("part").withSpecId(0).build();
        Table rtasTable = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)rtasTable.schema().asStruct()).as("Should have expected nullable schema", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        ((ObjectAssert)Assertions.assertThat((Object)rtasTable.spec()).as("Should be partitioned by part", new Object[0])).isEqualTo((Object)expectedSpec);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT 2 * id, data, CASE WHEN ((2 * id) %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        ((IterableAssert)Assertions.assertThat((Iterable)rtasTable.snapshots()).as("Table should have expected snapshots", new Object[0])).hasSize(2);
    }

    @TestTemplate
    public void testDataFrameV2Create() throws Exception {
        spark.table(this.sourceName).writeTo(this.tableName).using("iceberg").create();
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
        Table ctasTable = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)ctasTable.schema().asStruct()).as("Should have expected nullable schema", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        ((ListAssert)Assertions.assertThat((List)ctasTable.spec().fields()).as("Should be an unpartitioned table", new Object[0])).hasSize(0);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
    }

    @TestTemplate
    public void testDataFrameV2Replace() throws Exception {
        spark.table(this.sourceName).writeTo(this.tableName).using("iceberg").create();
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT * FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        spark.table(this.sourceName).select(new Column[]{functions.col((String)"id"), functions.col((String)"data"), functions.when((Column)functions.col((String)"id").mod((Object)functions.lit((Object)2)).equalTo((Object)functions.lit((Object)0)), (Object)functions.lit((Object)"even")).otherwise((Object)"odd").as("part")}).orderBy("part", new String[]{"id"}).writeTo(this.tableName).partitionedBy(functions.col((String)"part"), new Column[0]).using("iceberg").replace();
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"part", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("part").withSpecId(1).build();
        Table rtasTable = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)rtasTable.schema().asStruct()).as("Should have expected nullable schema", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        ((ObjectAssert)Assertions.assertThat((Object)rtasTable.spec()).as("Should be partitioned by part", new Object[0])).isEqualTo((Object)expectedSpec);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        ((IterableAssert)Assertions.assertThat((Iterable)rtasTable.snapshots()).as("Table should have expected snapshots", new Object[0])).hasSize(2);
    }

    @TestTemplate
    public void testDataFrameV2CreateOrReplace() {
        spark.table(this.sourceName).select(new Column[]{functions.col((String)"id"), functions.col((String)"data"), functions.when((Column)functions.col((String)"id").mod((Object)functions.lit((Object)2)).equalTo((Object)functions.lit((Object)0)), (Object)functions.lit((Object)"even")).otherwise((Object)"odd").as("part")}).orderBy("part", new String[]{"id"}).writeTo(this.tableName).partitionedBy(functions.col((String)"part"), new Column[0]).using("iceberg").createOrReplace();
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        spark.table(this.sourceName).select(new Column[]{functions.col((String)"id").multiply((Object)functions.lit((Object)2)).as("id"), functions.col((String)"data")}).select(new Column[]{functions.col((String)"id"), functions.col((String)"data"), functions.when((Column)functions.col((String)"id").mod((Object)functions.lit((Object)2)).equalTo((Object)functions.lit((Object)0)), (Object)functions.lit((Object)"even")).otherwise((Object)"odd").as("part")}).orderBy("part", new String[]{"id"}).writeTo(this.tableName).partitionedBy(functions.col((String)"part"), new Column[0]).using("iceberg").createOrReplace();
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"part", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("part").withSpecId(0).build();
        Table rtasTable = this.validationCatalog.loadTable(this.tableIdent);
        ((ObjectAssert)Assertions.assertThat((Object)rtasTable.schema().asStruct()).as("Should have expected nullable schema", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        ((ObjectAssert)Assertions.assertThat((Object)rtasTable.spec()).as("Should be partitioned by part", new Object[0])).isEqualTo((Object)expectedSpec);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT 2 * id, data, CASE WHEN ((2 * id) %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        ((IterableAssert)Assertions.assertThat((Iterable)rtasTable.snapshots()).as("Table should have expected snapshots", new Object[0])).hasSize(2);
    }

    @TestTemplate
    public void testCreateRTASWithPartitionSpecChanging() {
        this.sql("CREATE OR REPLACE TABLE %s USING iceberg PARTITIONED BY (part) AS SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY 3, 1", this.tableName, this.sourceName);
        Table rtasTable = this.validationCatalog.loadTable(this.tableIdent);
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT id, data, CASE WHEN (id %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        rtasTable.updateSpec().removeField("part").commit();
        this.sql("CREATE OR REPLACE TABLE %s USING iceberg PARTITIONED BY (part, id) AS SELECT 2 * id as id, data, CASE WHEN ((2 * id) %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY 3, 1", this.tableName, this.sourceName);
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"part", (Type)Types.StringType.get())});
        PartitionSpec expectedSpec = PartitionSpec.builderFor((Schema)expectedSchema).identity("part").identity("id").withSpecId(2).build();
        ((ObjectAssert)Assertions.assertThat((Object)rtasTable.spec()).as("Should be partitioned by part and id", new Object[0])).isEqualTo((Object)expectedSpec);
        ((ObjectAssert)Assertions.assertThat((Object)rtasTable.schema().asStruct()).as("Should have expected nullable schema", new Object[0])).isEqualTo((Object)expectedSchema.asStruct());
        this.assertEquals("Should have rows matching the source table", this.sql("SELECT 2 * id, data, CASE WHEN ((2 * id) %% 2) = 0 THEN 'even' ELSE 'odd' END AS part FROM %s ORDER BY id", this.sourceName), this.sql("SELECT * FROM %s ORDER BY id", this.tableName));
        ((IterableAssert)Assertions.assertThat((Iterable)rtasTable.snapshots()).as("Table should have expected snapshots", new Object[0])).hasSize(2);
    }
}

