/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Streams;
import org.apache.iceberg.spark.CatalogTestBase;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestDropTable
extends CatalogTestBase {
    @BeforeEach
    public void createTable() {
        this.sql("CREATE TABLE %s (id INT, name STRING) USING iceberg", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, 'test')", this.tableName);
    }

    @AfterEach
    public void removeTable() throws IOException {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testDropTable() throws IOException {
        this.dropTableInternal();
    }

    @TestTemplate
    public void testDropTableGCDisabled() throws IOException {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (gc.enabled = false)", this.tableName);
        this.dropTableInternal();
    }

    private void dropTableInternal() throws IOException {
        this.assertEquals("Should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1, "test")), this.sql("SELECT * FROM %s", this.tableName));
        List<String> manifestAndFiles = this.manifestsAndFiles();
        ((ListAssert)Assertions.assertThat(manifestAndFiles).as("There should be 2 files for manifests and files", new Object[0])).hasSize(2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.checkFilesExist(manifestAndFiles, true)).as("All files should exist", new Object[0])).isTrue();
        this.sql("DROP TABLE %s", this.tableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not exist", new Object[0])).isFalse();
        if (this.catalogName.equals("testhadoop")) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.checkFilesExist(manifestAndFiles, false)).as("All files should be deleted", new Object[0])).isTrue();
        } else {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.checkFilesExist(manifestAndFiles, true)).as("All files should not be deleted", new Object[0])).isTrue();
        }
    }

    @TestTemplate
    public void testPurgeTable() throws IOException {
        this.assertEquals("Should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1, "test")), this.sql("SELECT * FROM %s", this.tableName));
        List<String> manifestAndFiles = this.manifestsAndFiles();
        ((ListAssert)Assertions.assertThat(manifestAndFiles).as("There should be 2 files for manifests and files", new Object[0])).hasSize(2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.checkFilesExist(manifestAndFiles, true)).as("All files should exist", new Object[0])).isTrue();
        this.sql("DROP TABLE %s PURGE", this.tableName);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not exist", new Object[0])).isFalse();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.checkFilesExist(manifestAndFiles, false)).as("All files should be deleted", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testPurgeTableGCDisabled() throws IOException {
        this.sql("ALTER TABLE %s SET TBLPROPERTIES (gc.enabled = false)", this.tableName);
        this.assertEquals("Should have expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1, "test")), this.sql("SELECT * FROM %s", this.tableName));
        List<String> manifestAndFiles = this.manifestsAndFiles();
        ((ListAssert)Assertions.assertThat(manifestAndFiles).as("There should be 2 files for manifests and files", new Object[0])).hasSize(2);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.checkFilesExist(manifestAndFiles, true)).as("All files should exist", new Object[0])).isTrue();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("DROP TABLE %s PURGE", this.tableName)).isInstanceOf(ValidationException.class)).hasMessageContaining("Cannot purge table: GC is disabled (deleting files may corrupt other tables");
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.validationCatalog.tableExists(this.tableIdent)).as("Table should not been dropped", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.checkFilesExist(manifestAndFiles, true)).as("All files should not be deleted", new Object[0])).isTrue();
    }

    private List<String> manifestsAndFiles() {
        List<Object[]> files = this.sql("SELECT file_path FROM %s.%s", this.tableName, MetadataTableType.FILES);
        List<Object[]> manifests = this.sql("SELECT path FROM %s.%s", this.tableName, MetadataTableType.MANIFESTS);
        return Streams.concat((Stream[])new Stream[]{files.stream(), manifests.stream()}).map(row -> (String)row[0]).collect(Collectors.toList());
    }

    private boolean checkFilesExist(List<String> files, boolean shouldExist) throws IOException {
        boolean mask;
        boolean bl = mask = !shouldExist;
        if (files.isEmpty()) {
            return mask;
        }
        FileSystem fs = new Path(files.get(0)).getFileSystem((Configuration)hiveConf);
        return files.stream().allMatch(file -> {
            try {
                return fs.exists(new Path(file)) ^ mask;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

