/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.List;
import java.util.UUID;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.Table;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.spark.sql.PartitionedWritesTestBase;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestPartitionedWritesToWapBranch
extends PartitionedWritesTestBase {
    private static final String BRANCH = "test";

    @Override
    @BeforeEach
    public void createTables() {
        spark.conf().set("spark.wap.branch", BRANCH);
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg PARTITIONED BY (truncate(id, 3)) OPTIONS (%s = 'true')", this.tableName, "write.wap.enabled");
        this.sql("INSERT INTO %s VALUES (1, 'a'), (2, 'b'), (3, 'c')", this.tableName);
    }

    @Override
    @AfterEach
    public void removeTables() {
        super.removeTables();
        spark.conf().unset("spark.wap.branch");
        spark.conf().unset("spark.wap.id");
    }

    @Override
    protected String commitTarget() {
        return this.tableName;
    }

    @Override
    protected String selectTarget() {
        return String.format("%s VERSION AS OF '%s'", this.tableName, BRANCH);
    }

    @TestTemplate
    public void testBranchAndWapBranchCannotBothBeSetForWrite() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        table.manageSnapshots().createBranch("test2", ((SnapshotRef)table.refs().get(BRANCH)).snapshotId()).commit();
        this.sql("REFRESH TABLE " + this.tableName, new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("INSERT INTO %s.branch_test2 VALUES (4, 'd')", this.tableName)).isInstanceOf(ValidationException.class)).hasMessage("Cannot write to both branch and WAP branch, but got branch [test2] and WAP branch [%s]", new Object[]{BRANCH});
    }

    @TestTemplate
    public void testWapIdAndWapBranchCannotBothBeSetForWrite() {
        String wapId = UUID.randomUUID().toString();
        spark.conf().set("spark.wap.id", wapId);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("INSERT INTO %s VALUES (4, 'd')", this.tableName)).isInstanceOf(ValidationException.class)).hasMessage("Cannot set both WAP ID and branch, but got ID [%s] and branch [%s]", new Object[]{wapId, BRANCH});
    }

    @Override
    protected void assertPartitionMetadata(String tableName, List<Object[]> expected, String ... selectPartitionColumns) {
    }
}

