/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestRefreshTable
extends CatalogTestBase {
    @BeforeEach
    public void createTables() {
        this.sql("CREATE TABLE %s (key int, value int) USING iceberg", this.tableName);
        this.sql("INSERT INTO %s VALUES (1,1)", this.tableName);
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testRefreshCommand() {
        if (this.catalogName.equals(SparkCatalogConfig.SPARK.catalogName()) || this.catalogName.equals(SparkCatalogConfig.HADOOP.catalogName())) {
            spark.conf().set("spark.sql.catalog." + this.catalogName + ".cache-enabled", true);
            spark = spark.cloneSession();
        }
        ImmutableList originalExpected = ImmutableList.of((Object)this.row(1, 1));
        List<Object[]> originalActual = this.sql("SELECT * FROM %s", this.tableName);
        this.assertEquals("Table should start as expected", (List<Object[]>)originalExpected, originalActual);
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        DataFile file = (DataFile)table.currentSnapshot().addedDataFiles(table.io()).iterator().next();
        table.newDelete().deleteFile(file).commit();
        List<Object[]> cachedActual = this.sql("SELECT * FROM %s", this.tableName);
        this.assertEquals("Cached table should be unchanged", (List<Object[]>)originalExpected, cachedActual);
        this.sql("REFRESH TABLE %s", this.tableName);
        ImmutableList refreshedExpected = ImmutableList.of();
        List<Object[]> refreshedActual = this.sql("SELECT * FROM %s", this.tableName);
        this.assertEquals("Refreshed table should be empty", (List<Object[]>)refreshedExpected, refreshedActual);
    }
}

