/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.Table;
import org.apache.iceberg.events.Listeners;
import org.apache.iceberg.events.ScanEvent;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkCatalogConfig;
import org.apache.spark.sql.Dataset;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestSelect
extends CatalogTestBase {
    private int scanEventCount = 0;
    private ScanEvent lastScanEvent = null;
    @Parameter(index=3)
    private String binaryTableName;

    @Parameters(name="catalogName = {0}, implementation = {1}, config = {2}, binaryTableName = {3}")
    protected static Object[][] parameters() {
        return new Object[][]{{SparkCatalogConfig.HIVE.catalogName(), SparkCatalogConfig.HIVE.implementation(), SparkCatalogConfig.HIVE.properties(), SparkCatalogConfig.HIVE.catalogName() + ".default.binary_table"}, {SparkCatalogConfig.HADOOP.catalogName(), SparkCatalogConfig.HADOOP.implementation(), SparkCatalogConfig.HADOOP.properties(), SparkCatalogConfig.HADOOP.catalogName() + ".default.binary_table"}, {SparkCatalogConfig.SPARK.catalogName(), SparkCatalogConfig.SPARK.implementation(), SparkCatalogConfig.SPARK.properties(), "default.binary_table"}};
    }

    @BeforeEach
    public void createTables() {
        Listeners.register(event -> {
            ++this.scanEventCount;
            this.lastScanEvent = event;
        }, ScanEvent.class);
        this.sql("CREATE TABLE %s (id bigint, data string, float float) USING iceberg", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, 'a', 1.0), (2, 'b', 2.0), (3, 'c', float('NaN'))", this.tableName);
        this.scanEventCount = 0;
        this.lastScanEvent = null;
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
        this.sql("DROP TABLE IF EXISTS %s", this.binaryTableName);
    }

    @TestTemplate
    public void testSelect() {
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a", Float.valueOf(1.0f)), (Object)this.row(2L, "b", Float.valueOf(2.0f)), (Object)this.row(3L, "c", Float.valueOf(Float.NaN)));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT * FROM %s", this.tableName));
    }

    @TestTemplate
    public void testSelectRewrite() {
        ImmutableList expected = ImmutableList.of((Object)this.row(3L, "c", Float.valueOf(Float.NaN)));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT * FROM %s where float = float('NaN')", this.tableName));
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.scanEventCount).as("Should create only one scan", new Object[0])).isEqualTo(1);
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((Expression)this.lastScanEvent.filter())).as("Should push down expected filter", new Object[0])).isEqualTo("(float IS NOT NULL AND is_nan(float))");
    }

    @TestTemplate
    public void testProjection() {
        ImmutableList expected = ImmutableList.of((Object)this.row(1L), (Object)this.row(2L), (Object)this.row(3L));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT id FROM %s", this.tableName));
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.scanEventCount).as("Should create only one scan", new Object[0])).isEqualTo(1);
        ((ObjectAssert)Assertions.assertThat((Object)this.lastScanEvent.filter()).as("Should not push down a filter", new Object[0])).isEqualTo((Object)Expressions.alwaysTrue());
        ((ObjectAssert)Assertions.assertThat((Object)this.lastScanEvent.projection().asStruct()).as("Should project only the id column", new Object[0])).isEqualTo((Object)this.validationCatalog.loadTable(this.tableIdent).schema().select(new String[]{"id"}).asStruct());
    }

    @TestTemplate
    public void testExpressionPushdown() {
        ImmutableList expected = ImmutableList.of((Object)this.row("b"));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT data FROM %s WHERE id = 2", this.tableName));
        ((AbstractIntegerAssert)Assertions.assertThat((int)this.scanEventCount).as("Should create only one scan", new Object[0])).isEqualTo(1);
        ((AbstractStringAssert)Assertions.assertThat((String)Spark3Util.describe((Expression)this.lastScanEvent.filter())).as("Should push down expected filter", new Object[0])).isEqualTo("(id IS NOT NULL AND id = 2)");
        ((ObjectAssert)Assertions.assertThat((Object)this.lastScanEvent.projection().asStruct()).as("Should project only id and data columns", new Object[0])).isEqualTo((Object)this.validationCatalog.loadTable(this.tableIdent).schema().select(new String[]{"id", "data"}).asStruct());
    }

    @TestTemplate
    public void testMetadataTables() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalogName).as("Spark session catalog does not support metadata tables", new Object[0])).isNotEqualTo((Object)"spark_catalog");
        this.assertEquals("Snapshot metadata table", (List<Object[]>)ImmutableList.of((Object)this.row(ANY, ANY, null, "append", ANY, ANY)), this.sql("SELECT * FROM %s.snapshots", this.tableName));
    }

    @TestTemplate
    public void testSnapshotInTableName() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalogName).as("Spark session catalog does not support extended table names", new Object[0])).isNotEqualTo((Object)"spark_catalog");
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        List<Object[]> expected = this.sql("SELECT * FROM %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        String prefix = "snapshot_id_";
        List<Object[]> actual = this.sql("SELECT * FROM %s.%s", this.tableName, prefix + snapshotId);
        this.assertEquals("Snapshot at specific ID, prefix " + prefix, expected, actual);
        Dataset df = spark.read().format("iceberg").option("snapshot-id", snapshotId).load(this.tableName);
        List<Object[]> fromDF = this.rowsToJava(df.collectAsList());
        this.assertEquals("Snapshot at specific ID " + snapshotId, expected, fromDF);
    }

    @TestTemplate
    public void testTimestampInTableName() {
        ((AbstractStringAssert)Assumptions.assumeThat((String)this.catalogName).as("Spark session catalog does not support extended table names", new Object[0])).isNotEqualTo((Object)"spark_catalog");
        long snapshotTs = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().timestampMillis();
        long timestamp = this.waitUntilAfter(snapshotTs + 2L);
        List<Object[]> expected = this.sql("SELECT * FROM %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        String prefix = "at_timestamp_";
        List<Object[]> actual = this.sql("SELECT * FROM %s.%s", this.tableName, prefix + timestamp);
        this.assertEquals("Snapshot at timestamp, prefix " + prefix, expected, actual);
        Dataset df = spark.read().format("iceberg").option("as-of-timestamp", timestamp).load(this.tableName);
        List<Object[]> fromDF = this.rowsToJava(df.collectAsList());
        this.assertEquals("Snapshot at timestamp " + timestamp, expected, fromDF);
    }

    @TestTemplate
    public void testVersionAsOf() {
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        List<Object[]> expected = this.sql("SELECT * FROM %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        List<Object[]> actual1 = this.sql("SELECT * FROM %s VERSION AS OF %s", this.tableName, snapshotId);
        this.assertEquals("Snapshot at specific ID", expected, actual1);
        List<Object[]> actual2 = this.sql("SELECT * FROM %s FOR SYSTEM_VERSION AS OF %s", this.tableName, snapshotId);
        this.assertEquals("Snapshot at specific ID", expected, actual2);
        Dataset df = spark.read().format("iceberg").option("versionAsOf", snapshotId).load(this.tableName);
        List<Object[]> fromDF = this.rowsToJava(df.collectAsList());
        this.assertEquals("Snapshot at specific ID " + snapshotId, expected, fromDF);
    }

    @TestTemplate
    public void testTagReference() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createTag("test_tag", snapshotId).commit();
        List<Object[]> expected = this.sql("SELECT * FROM %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        List<Object[]> actual1 = this.sql("SELECT * FROM %s VERSION AS OF 'test_tag'", this.tableName);
        this.assertEquals("Snapshot at specific tag reference name", expected, actual1);
        List<Object[]> actual2 = this.sql("SELECT * FROM %s FOR SYSTEM_VERSION AS OF 'test_tag'", this.tableName);
        this.assertEquals("Snapshot at specific tag reference name", expected, actual2);
        if (!"spark_catalog".equals(this.catalogName)) {
            List<Object[]> actual3 = this.sql("SELECT * FROM %s.tag_test_tag", this.tableName);
            this.assertEquals("Snapshot at specific tag reference name, prefix", expected, actual3);
        }
        Dataset df = spark.read().format("iceberg").option("tag", "test_tag").load(this.tableName);
        List<Object[]> fromDF = this.rowsToJava(df.collectAsList());
        this.assertEquals("Snapshot at specific tag reference name", expected, fromDF);
    }

    @TestTemplate
    public void testUseSnapshotIdForTagReferenceAsOf() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId1 = table.currentSnapshot().snapshotId();
        List<Object[]> actual = this.sql("SELECT * FROM %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        table.refresh();
        long snapshotId2 = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createTag(Long.toString(snapshotId1), snapshotId2).commit();
        List<Object[]> travelWithStringResult = this.sql("SELECT * FROM %s VERSION AS OF '%s'", this.tableName, snapshotId1);
        this.assertEquals("Snapshot at specific tag reference name", actual, travelWithStringResult);
        List<Object[]> travelWithLongResult = this.sql("SELECT * FROM %s VERSION AS OF %s", this.tableName, snapshotId1);
        this.assertEquals("Snapshot at specific tag reference name", actual, travelWithLongResult);
    }

    @TestTemplate
    public void testBranchReference() {
        Table table = this.validationCatalog.loadTable(this.tableIdent);
        long snapshotId = table.currentSnapshot().snapshotId();
        table.manageSnapshots().createBranch("test_branch", snapshotId).commit();
        List<Object[]> expected = this.sql("SELECT * FROM %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        List<Object[]> actual1 = this.sql("SELECT * FROM %s VERSION AS OF 'test_branch'", this.tableName);
        this.assertEquals("Snapshot at specific branch reference name", expected, actual1);
        List<Object[]> actual2 = this.sql("SELECT * FROM %s FOR SYSTEM_VERSION AS OF 'test_branch'", this.tableName);
        this.assertEquals("Snapshot at specific branch reference name", expected, actual2);
        if (!"spark_catalog".equals(this.catalogName)) {
            List<Object[]> actual3 = this.sql("SELECT * FROM %s.branch_test_branch", this.tableName);
            this.assertEquals("Snapshot at specific branch reference name, prefix", expected, actual3);
        }
        Dataset df = spark.read().format("iceberg").option("branch", "test_branch").load(this.tableName);
        List<Object[]> fromDF = this.rowsToJava(df.collectAsList());
        this.assertEquals("Snapshot at specific branch reference name", expected, fromDF);
    }

    @TestTemplate
    public void testUnknownReferenceAsOf() {
        Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s VERSION AS OF 'test_unknown'", this.tableName)).hasMessageContaining("Cannot find matching snapshot ID or reference name for version").isInstanceOf(ValidationException.class);
    }

    @TestTemplate
    public void testTimestampAsOf() {
        long snapshotTs = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().timestampMillis();
        long timestamp = this.waitUntilAfter(snapshotTs + 1000L);
        this.waitUntilAfter(timestamp + 1000L);
        long timestampInSeconds = TimeUnit.MILLISECONDS.toSeconds(timestamp);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formattedDate = sdf.format(new Date(timestamp));
        List<Object[]> expected = this.sql("SELECT * FROM %s", this.tableName);
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        List<Object[]> actualWithLongFormat = this.sql("SELECT * FROM %s TIMESTAMP AS OF %s", this.tableName, timestampInSeconds);
        this.assertEquals("Snapshot at timestamp", expected, actualWithLongFormat);
        List<Object[]> actualWithDateFormat = this.sql("SELECT * FROM %s TIMESTAMP AS OF '%s'", this.tableName, formattedDate);
        this.assertEquals("Snapshot at timestamp", expected, actualWithDateFormat);
        List<Object[]> actualWithLongFormatInHiveSyntax = this.sql("SELECT * FROM %s FOR SYSTEM_TIME AS OF %s", this.tableName, timestampInSeconds);
        this.assertEquals("Snapshot at specific ID", expected, actualWithLongFormatInHiveSyntax);
        List<Object[]> actualWithDateFormatInHiveSyntax = this.sql("SELECT * FROM %s FOR SYSTEM_TIME AS OF '%s'", this.tableName, formattedDate);
        this.assertEquals("Snapshot at specific ID", expected, actualWithDateFormatInHiveSyntax);
        Dataset df = spark.read().format("iceberg").option("timestampAsOf", formattedDate).load(this.tableName);
        List<Object[]> fromDF = this.rowsToJava(df.collectAsList());
        this.assertEquals("Snapshot at timestamp " + timestamp, expected, fromDF);
    }

    @TestTemplate
    public void testInvalidTimeTravelBasedOnBothAsOfAndTableIdentifier() {
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        long timestamp = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().timestampMillis() + 2L;
        String timestampPrefix = "at_timestamp_";
        String snapshotPrefix = "snapshot_id_";
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s.%s VERSION AS OF %s", this.tableName, snapshotPrefix + snapshotId, snapshotId)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot do time-travel based on both table identifier and AS OF");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s.%s VERSION AS OF %s", this.tableName, timestampPrefix + timestamp, snapshotId)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot do time-travel based on both table identifier and AS OF");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s.%s TIMESTAMP AS OF %s", this.tableName, snapshotPrefix + snapshotId, timestamp)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot do time-travel based on both table identifier and AS OF");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s.%s TIMESTAMP AS OF %s", this.tableName, timestampPrefix + timestamp, timestamp)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot do time-travel based on both table identifier and AS OF");
    }

    @TestTemplate
    public void testInvalidTimeTravelAgainstBranchIdentifierWithAsOf() {
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        this.validationCatalog.loadTable(this.tableIdent).manageSnapshots().createBranch("b1").commit();
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("SELECT * FROM %s.branch_b1 VERSION AS OF %s", this.tableName, snapshotId)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot do time-travel based on both table identifier and AS OF");
    }

    @TestTemplate
    public void testSpecifySnapshotAndTimestamp() {
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        long timestamp = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().timestampMillis() + 2L;
        this.sql("INSERT INTO %s VALUES (4, 'd', 4.0), (5, 'e', 5.0)", this.tableName);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> spark.read().format("iceberg").option("snapshot-id", snapshotId).option("as-of-timestamp", timestamp).load(this.tableName).collectAsList()).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith(String.format("Can specify only one of snapshot-id (%s), as-of-timestamp (%s)", snapshotId, timestamp));
    }

    @TestTemplate
    public void testBinaryInFilter() {
        this.sql("CREATE TABLE %s (id bigint, binary binary) USING iceberg", this.binaryTableName);
        this.sql("INSERT INTO %s VALUES (1, X''), (2, X'1111'), (3, X'11')", this.binaryTableName);
        ImmutableList expected = ImmutableList.of((Object)this.row(2L, new byte[]{17, 17}));
        this.assertEquals("Should return all expected rows", (List<Object[]>)expected, this.sql("SELECT id, binary FROM %s where binary > X'11'", this.binaryTableName));
    }

    @TestTemplate
    public void testComplexTypeFilter() {
        String complexTypeTableName = this.tableName("complex_table");
        this.sql("CREATE TABLE %s (id INT, complex STRUCT<c1:INT,c2:STRING>) USING iceberg", complexTypeTableName);
        this.sql("INSERT INTO TABLE %s VALUES (1, named_struct(\"c1\", 3, \"c2\", \"v1\"))", complexTypeTableName);
        this.sql("INSERT INTO TABLE %s VALUES (2, named_struct(\"c1\", 2, \"c2\", \"v2\"))", complexTypeTableName);
        List<Object[]> result = this.sql("SELECT id FROM %s WHERE complex = named_struct(\"c1\", 3, \"c2\", \"v1\")", complexTypeTableName);
        this.assertEquals("Should return all expected rows", (List<Object[]>)ImmutableList.of((Object)this.row(1)), result);
        this.sql("DROP TABLE IF EXISTS %s", complexTypeTableName);
    }
}

