/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import org.apache.iceberg.spark.TestBaseWithCatalog;
import org.apache.iceberg.spark.functions.MonthsFunction;
import org.apache.spark.sql.AnalysisException;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public class TestSparkMonthsFunction
extends TestBaseWithCatalog {
    @BeforeEach
    public void useCatalog() {
        this.sql("USE %s", this.catalogName);
    }

    @TestTemplate
    public void testDates() {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT system.months(date('2017-12-01'))", new Object[0])).as("Expected to produce 47 * 12 + 11 = 575", new Object[0])).isEqualTo((Object)575);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT system.months(date('1970-01-01'))", new Object[0])).as("Expected to produce 0 * 12 + 0 = 0", new Object[0])).isEqualTo((Object)0);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT system.months(date('1969-12-31'))", new Object[0])).as("Expected to produce -1", new Object[0])).isEqualTo((Object)-1);
        Assertions.assertThat((Object)this.scalarSql("SELECT system.months(CAST(null AS DATE))", new Object[0])).isNull();
    }

    @TestTemplate
    public void testTimestamps() {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT system.months(TIMESTAMP '2017-12-01 10:12:55.038194 UTC+00:00')", new Object[0])).as("Expected to produce 47 * 12 + 11 = 575", new Object[0])).isEqualTo((Object)575);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT system.months(TIMESTAMP '1970-01-01 00:00:01.000001 UTC+00:00')", new Object[0])).as("Expected to produce 0 * 12 + 0 = 0", new Object[0])).isEqualTo((Object)0);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT system.months(TIMESTAMP '1969-12-31 23:59:58.999999 UTC+00:00')", new Object[0])).as("Expected to produce -1", new Object[0])).isEqualTo((Object)-1);
        Assertions.assertThat((Object)this.scalarSql("SELECT system.months(CAST(null AS TIMESTAMP))", new Object[0])).isNull();
    }

    @TestTemplate
    public void testTimestampNtz() {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT system.months(TIMESTAMP_NTZ '2017-12-01 10:12:55.038194 UTC')", new Object[0])).as("Expected to produce 47 * 12 + 11 = 575", new Object[0])).isEqualTo((Object)575);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT system.months(TIMESTAMP_NTZ '1970-01-01 00:00:01.000001 UTC')", new Object[0])).as("Expected to produce 0 * 12 + 0 = 0", new Object[0])).isEqualTo((Object)0);
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT system.months(TIMESTAMP_NTZ '1969-12-31 23:59:58.999999 UTC')", new Object[0])).as("Expected to produce -1", new Object[0])).isEqualTo((Object)-1);
        Assertions.assertThat((Object)this.scalarSql("SELECT system.months(CAST(null AS TIMESTAMP_NTZ))", new Object[0])).isNull();
    }

    @TestTemplate
    public void testWrongNumberOfArguments() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.months()", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'months' cannot process input: (): Wrong number of inputs");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.months(date('1969-12-31'), date('1969-12-31'))", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'months' cannot process input: (date, date): Wrong number of inputs");
    }

    @TestTemplate
    public void testInvalidInputTypes() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.months(1)", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'months' cannot process input: (int): Expected value to be date or timestamp");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scalarSql("SELECT system.months(1L)", new Object[0])).isInstanceOf(AnalysisException.class)).hasMessageStartingWith("Function 'months' cannot process input: (bigint): Expected value to be date or timestamp");
    }

    @TestTemplate
    public void testThatMagicFunctionsAreInvoked() {
        String dateValue = "date('2017-12-01')";
        String dateTransformClass = MonthsFunction.DateToMonthsFunction.class.getName();
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.months(%s)", dateValue)).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class " + dateTransformClass});
        String timestampValue = "TIMESTAMP '2017-12-01 10:12:55.038194 UTC+00:00'";
        String timestampTransformClass = MonthsFunction.TimestampToMonthsFunction.class.getName();
        ((AbstractStringAssert)Assertions.assertThat((Object)this.scalarSql("EXPLAIN EXTENDED SELECT system.months(%s)", timestampValue)).asString().isNotNull()).contains(new CharSequence[]{"staticinvoke(class " + timestampTransformClass});
    }
}

