/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.sql;

import java.util.List;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.spark.CatalogTestBase;
import org.apache.iceberg.spark.source.SimpleRecord;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.functions;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;

public abstract class UnpartitionedWritesTestBase
extends CatalogTestBase {
    @BeforeEach
    public void createTables() {
        this.sql("CREATE TABLE %s (id bigint, data string) USING iceberg", this.tableName);
        this.sql("INSERT INTO %s VALUES (1, 'a'), (2, 'b'), (3, 'c')", this.tableName);
    }

    @AfterEach
    public void removeTables() {
        this.sql("DROP TABLE IF EXISTS %s", this.tableName);
    }

    @TestTemplate
    public void testInsertAppend() {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 3 rows", new Object[0])).isEqualTo((Object)3L);
        this.sql("INSERT INTO %s VALUES (4, 'd'), (5, 'e')", this.commitTarget());
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 5 rows", new Object[0])).isEqualTo((Object)5L);
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @TestTemplate
    public void testInsertOverwrite() {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 3 rows", new Object[0])).isEqualTo((Object)3L);
        this.sql("INSERT OVERWRITE %s VALUES (4, 'd'), (5, 'e')", this.commitTarget());
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 2 rows after overwrite", new Object[0])).isEqualTo((Object)2L);
        ImmutableList expected = ImmutableList.of((Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @TestTemplate
    public void testInsertAppendAtSnapshot() {
        Assumptions.assumeThat((boolean)this.tableName.equals(this.commitTarget())).isTrue();
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        String prefix = "snapshot_id_";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("INSERT INTO %s.%s VALUES (4, 'd'), (5, 'e')", this.tableName, prefix + snapshotId)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot write to table at a specific snapshot");
    }

    @TestTemplate
    public void testInsertOverwriteAtSnapshot() {
        Assumptions.assumeThat((boolean)this.tableName.equals(this.commitTarget())).isTrue();
        long snapshotId = this.validationCatalog.loadTable(this.tableIdent).currentSnapshot().snapshotId();
        String prefix = "snapshot_id_";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.sql("INSERT OVERWRITE %s.%s VALUES (4, 'd'), (5, 'e')", this.tableName, prefix + snapshotId)).isInstanceOf(IllegalArgumentException.class)).hasMessageStartingWith("Cannot write to table at a specific snapshot");
    }

    @TestTemplate
    public void testDataFrameV2Append() throws NoSuchTableException {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 3 rows", new Object[0])).isEqualTo((Object)3L);
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.commitTarget()).append();
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 5 rows after insert", new Object[0])).isEqualTo((Object)5L);
        ImmutableList expected = ImmutableList.of((Object)this.row(1L, "a"), (Object)this.row(2L, "b"), (Object)this.row(3L, "c"), (Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @TestTemplate
    public void testDataFrameV2DynamicOverwrite() throws NoSuchTableException {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 3 rows", new Object[0])).isEqualTo((Object)3L);
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.commitTarget()).overwritePartitions();
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 2 rows after overwrite", new Object[0])).isEqualTo((Object)2L);
        ImmutableList expected = ImmutableList.of((Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }

    @TestTemplate
    public void testDataFrameV2Overwrite() throws NoSuchTableException {
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 3 rows", new Object[0])).isEqualTo((Object)3L);
        ImmutableList data = ImmutableList.of((Object)new SimpleRecord(4, "d"), (Object)new SimpleRecord(5, "e"));
        Dataset ds = spark.createDataFrame((List)data, SimpleRecord.class);
        ds.writeTo(this.commitTarget()).overwrite(functions.col((String)"id").$less$eq((Object)3));
        ((ObjectAssert)Assertions.assertThat((Object)this.scalarSql("SELECT count(*) FROM %s", this.selectTarget())).as("Should have 2 rows after overwrite", new Object[0])).isEqualTo((Object)2L);
        ImmutableList expected = ImmutableList.of((Object)this.row(4L, "d"), (Object)this.row(5L, "e"));
        this.assertEquals("Row data should match expected", (List<Object[]>)expected, this.sql("SELECT * FROM %s ORDER BY id", this.selectTarget()));
    }
}

