/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Pair;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;

class SparkCompressionUtil {
    private static final String LZ4 = "lz4";
    private static final String ZSTD = "zstd";
    private static final String GZIP = "gzip";
    private static final String ZLIB = "zlib";
    private static final String SNAPPY = "snappy";
    private static final String NONE = "none";
    private static final String SHUFFLE_COMPRESSION_ENABLED = "spark.shuffle.compress";
    private static final boolean SHUFFLE_COMPRESSION_ENABLED_DEFAULT = true;
    private static final String SPARK_COMPRESSION_CODEC = "spark.io.compression.codec";
    private static final String SPARK_COMPRESSION_CODEC_DEFAULT = "lz4";
    private static final double DEFAULT_COLUMNAR_COMPRESSION = 2.0;
    private static final Map<Pair<String, String>, Double> COLUMNAR_COMPRESSIONS = SparkCompressionUtil.initColumnarCompressions();
    private static final double DEFAULT_ROW_BASED_COMPRESSION = 1.0;
    private static final Map<Pair<String, String>, Double> ROW_BASED_COMPRESSIONS = SparkCompressionUtil.initRowBasedCompressions();

    private SparkCompressionUtil() {
    }

    public static double shuffleCompressionRatio(SparkSession spark, FileFormat outputFileFormat, String outputCodec) {
        if (outputFileFormat == FileFormat.ORC || outputFileFormat == FileFormat.PARQUET) {
            return SparkCompressionUtil.columnarCompression(SparkCompressionUtil.shuffleCodec(spark), outputCodec);
        }
        if (outputFileFormat == FileFormat.AVRO) {
            return SparkCompressionUtil.rowBasedCompression(SparkCompressionUtil.shuffleCodec(spark), outputCodec);
        }
        return 1.0;
    }

    private static String shuffleCodec(SparkSession spark) {
        SparkConf sparkConf = spark.sparkContext().conf();
        return SparkCompressionUtil.shuffleCompressionEnabled(sparkConf) ? SparkCompressionUtil.sparkCodec(sparkConf) : NONE;
    }

    private static boolean shuffleCompressionEnabled(SparkConf sparkConf) {
        return sparkConf.getBoolean(SHUFFLE_COMPRESSION_ENABLED, true);
    }

    private static String sparkCodec(SparkConf sparkConf) {
        return sparkConf.get(SPARK_COMPRESSION_CODEC, "lz4");
    }

    private static double columnarCompression(String shuffleCodec, String outputCodec) {
        Pair key = Pair.of((Object)SparkCompressionUtil.normalize(shuffleCodec), (Object)SparkCompressionUtil.normalize(outputCodec));
        return COLUMNAR_COMPRESSIONS.getOrDefault(key, 2.0);
    }

    private static double rowBasedCompression(String shuffleCodec, String outputCodec) {
        Pair key = Pair.of((Object)SparkCompressionUtil.normalize(shuffleCodec), (Object)SparkCompressionUtil.normalize(outputCodec));
        return ROW_BASED_COMPRESSIONS.getOrDefault(key, 1.0);
    }

    private static String normalize(String value) {
        return value != null ? value.toLowerCase(Locale.ROOT) : null;
    }

    private static Map<Pair<String, String>, Double> initColumnarCompressions() {
        HashMap compressions = Maps.newHashMap();
        compressions.put(Pair.of((Object)NONE, (Object)ZSTD), 4.0);
        compressions.put(Pair.of((Object)NONE, (Object)GZIP), 4.0);
        compressions.put(Pair.of((Object)NONE, (Object)ZLIB), 4.0);
        compressions.put(Pair.of((Object)NONE, (Object)SNAPPY), 3.0);
        compressions.put(Pair.of((Object)NONE, (Object)"lz4"), 3.0);
        compressions.put(Pair.of((Object)ZSTD, (Object)ZSTD), 2.0);
        compressions.put(Pair.of((Object)ZSTD, (Object)GZIP), 2.0);
        compressions.put(Pair.of((Object)ZSTD, (Object)ZLIB), 2.0);
        compressions.put(Pair.of((Object)ZSTD, (Object)SNAPPY), 1.5);
        compressions.put(Pair.of((Object)ZSTD, (Object)"lz4"), 1.5);
        compressions.put(Pair.of((Object)SNAPPY, (Object)ZSTD), 3.0);
        compressions.put(Pair.of((Object)SNAPPY, (Object)GZIP), 3.0);
        compressions.put(Pair.of((Object)SNAPPY, (Object)ZLIB), 3.0);
        compressions.put(Pair.of((Object)SNAPPY, (Object)SNAPPY), 2.0);
        compressions.put(Pair.of((Object)SNAPPY, (Object)"lz4"), 2.0);
        compressions.put(Pair.of((Object)"lz4", (Object)ZSTD), 3.0);
        compressions.put(Pair.of((Object)"lz4", (Object)GZIP), 3.0);
        compressions.put(Pair.of((Object)"lz4", (Object)ZLIB), 3.0);
        compressions.put(Pair.of((Object)"lz4", (Object)SNAPPY), 2.0);
        compressions.put(Pair.of((Object)"lz4", (Object)"lz4"), 2.0);
        return compressions;
    }

    private static Map<Pair<String, String>, Double> initRowBasedCompressions() {
        HashMap compressions = Maps.newHashMap();
        compressions.put(Pair.of((Object)NONE, (Object)ZSTD), 2.0);
        compressions.put(Pair.of((Object)NONE, (Object)GZIP), 2.0);
        compressions.put(Pair.of((Object)NONE, (Object)ZLIB), 2.0);
        compressions.put(Pair.of((Object)ZSTD, (Object)SNAPPY), 0.5);
        compressions.put(Pair.of((Object)ZSTD, (Object)"lz4"), 0.5);
        compressions.put(Pair.of((Object)SNAPPY, (Object)ZSTD), 1.5);
        compressions.put(Pair.of((Object)SNAPPY, (Object)GZIP), 1.5);
        compressions.put(Pair.of((Object)SNAPPY, (Object)ZLIB), 1.5);
        compressions.put(Pair.of((Object)"lz4", (Object)ZSTD), 1.5);
        compressions.put(Pair.of((Object)"lz4", (Object)GZIP), 1.5);
        compressions.put(Pair.of((Object)"lz4", (Object)ZLIB), 1.5);
        return compressions;
    }
}

