/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.data;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.io.Encoder;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.avro.AvroWithPartnerByStructureVisitor;
import org.apache.iceberg.avro.MetricsAwareDatumWriter;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.avro.ValueWriters;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.data.AvroWithSparkSchemaVisitor;
import org.apache.iceberg.spark.data.SparkValueWriters;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StructType;

public class SparkAvroWriter
implements MetricsAwareDatumWriter<InternalRow> {
    private final StructType dsSchema;
    private ValueWriter<InternalRow> writer = null;

    public SparkAvroWriter(StructType dsSchema) {
        this.dsSchema = dsSchema;
    }

    public void setSchema(Schema schema) {
        this.writer = (ValueWriter)AvroWithSparkSchemaVisitor.visit((Object)this.dsSchema, (Schema)schema, (AvroWithPartnerByStructureVisitor)new WriteBuilder());
    }

    public void write(InternalRow datum, Encoder out) throws IOException {
        this.writer.write((Object)datum, out);
    }

    public Stream<FieldMetrics> metrics() {
        return this.writer.metrics();
    }

    private static class WriteBuilder
    extends AvroWithSparkSchemaVisitor<ValueWriter<?>> {
        private WriteBuilder() {
        }

        public ValueWriter<?> record(DataType struct, Schema record, List<String> names, List<ValueWriter<?>> fields) {
            return SparkValueWriters.struct(fields, IntStream.range(0, names.size()).mapToObj(i -> (DataType)this.fieldNameAndType(struct, i).second()).collect(Collectors.toList()));
        }

        public ValueWriter<?> union(DataType type, Schema union, List<ValueWriter<?>> options) {
            Preconditions.checkArgument((boolean)options.contains(ValueWriters.nulls()), (String)"Cannot create writer for non-option union: %s", (Object)union);
            Preconditions.checkArgument((options.size() == 2 ? 1 : 0) != 0, (String)"Cannot create writer for non-option union: %s", (Object)union);
            if (((Schema)union.getTypes().get(0)).getType() == Schema.Type.NULL) {
                return ValueWriters.option((int)0, options.get(1));
            }
            return ValueWriters.option((int)1, options.get(0));
        }

        public ValueWriter<?> array(DataType sArray, Schema array, ValueWriter<?> elementWriter) {
            return SparkValueWriters.array(elementWriter, this.arrayElementType(sArray));
        }

        public ValueWriter<?> map(DataType sMap, Schema map, ValueWriter<?> valueReader) {
            return SparkValueWriters.map(SparkValueWriters.strings(), this.mapKeyType(sMap), valueReader, this.mapValueType(sMap));
        }

        public ValueWriter<?> map(DataType sMap, Schema map, ValueWriter<?> keyWriter, ValueWriter<?> valueWriter) {
            return SparkValueWriters.arrayMap(keyWriter, this.mapKeyType(sMap), valueWriter, this.mapValueType(sMap));
        }

        public ValueWriter<?> primitive(DataType type, Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null) {
                switch (logicalType.getName()) {
                    case "date": {
                        return ValueWriters.ints();
                    }
                    case "timestamp-micros": {
                        return ValueWriters.longs();
                    }
                    case "decimal": {
                        LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                        return SparkValueWriters.decimal(decimal.getPrecision(), decimal.getScale());
                    }
                    case "uuid": {
                        return SparkValueWriters.uuids();
                    }
                }
                throw new IllegalArgumentException("Unsupported logical type: " + logicalType);
            }
            switch (primitive.getType()) {
                case NULL: {
                    return ValueWriters.nulls();
                }
                case BOOLEAN: {
                    return ValueWriters.booleans();
                }
                case INT: {
                    if (type instanceof ByteType) {
                        return ValueWriters.tinyints();
                    }
                    if (type instanceof ShortType) {
                        return ValueWriters.shorts();
                    }
                    return ValueWriters.ints();
                }
                case LONG: {
                    return ValueWriters.longs();
                }
                case FLOAT: {
                    return ValueWriters.floats();
                }
                case DOUBLE: {
                    return ValueWriters.doubles();
                }
                case STRING: {
                    return SparkValueWriters.strings();
                }
                case FIXED: {
                    return ValueWriters.fixed((int)primitive.getFixedSize());
                }
                case BYTES: {
                    return ValueWriters.bytes();
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + primitive);
        }
    }
}

