/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.hadoop.Util;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.JavaHash;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;

class SparkPlanningUtil {
    public static final String[] NO_LOCATION_PREFERENCE = new String[0];

    private SparkPlanningUtil() {
    }

    public static String[][] fetchBlockLocations(FileIO io, List<? extends ScanTaskGroup<?>> taskGroups) {
        String[][] locations = new String[taskGroups.size()][];
        Tasks.range((int)taskGroups.size()).stopOnFailure().executeWith(ThreadPools.getWorkerPool()).run(index -> {
            locations[index.intValue()] = Util.blockLocations((FileIO)io, (ScanTaskGroup)((ScanTaskGroup)taskGroups.get((int)index)));
        });
        return locations;
    }

    public static String[][] assignExecutors(List<? extends ScanTaskGroup<?>> taskGroups, List<String> executorLocations) {
        HashMap partitionHashes = Maps.newHashMap();
        String[][] locations = new String[taskGroups.size()][];
        for (int index = 0; index < taskGroups.size(); ++index) {
            locations[index] = SparkPlanningUtil.assign(taskGroups.get(index), executorLocations, partitionHashes);
        }
        return locations;
    }

    private static String[] assign(ScanTaskGroup<?> taskGroup, List<String> executorLocations, Map<Integer, JavaHash<StructLike>> partitionHashes) {
        ArrayList locations = Lists.newArrayList();
        for (ScanTask task : taskGroup.tasks()) {
            FileScanTask fileTask;
            PartitionSpec spec;
            if (!task.isFileScanTask() || !(spec = (fileTask = task.asFileScanTask()).spec()).isPartitioned() || fileTask.deletes().isEmpty()) continue;
            JavaHash partitionHash = partitionHashes.computeIfAbsent(spec.specId(), key -> SparkPlanningUtil.partitionHash(spec));
            int partitionHashCode = partitionHash.hash((Object)fileTask.partition());
            int index = Math.floorMod(partitionHashCode, executorLocations.size());
            String executorLocation = executorLocations.get(index);
            locations.add(executorLocation);
        }
        return locations.toArray(NO_LOCATION_PREFERENCE);
    }

    private static JavaHash<StructLike> partitionHash(PartitionSpec spec) {
        return JavaHash.forType((Type)spec.partitionType());
    }
}

