/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.SparkUtil;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.iceberg.spark.source.SparkBatchQueryScan;
import org.apache.iceberg.spark.source.SparkPositionDeltaWrite;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.write.DeltaWrite;
import org.apache.spark.sql.connector.write.DeltaWriteBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.apache.spark.sql.types.StructType;

class SparkPositionDeltaWriteBuilder
implements DeltaWriteBuilder {
    private static final Schema EXPECTED_ROW_ID_SCHEMA = new Schema(new Types.NestedField[]{MetadataColumns.FILE_PATH, MetadataColumns.ROW_POSITION});
    private final SparkSession spark;
    private final Table table;
    private final RowLevelOperation.Command command;
    private final SparkBatchQueryScan scan;
    private final IsolationLevel isolationLevel;
    private final SparkWriteConf writeConf;
    private final LogicalWriteInfo info;
    private final boolean checkNullability;
    private final boolean checkOrdering;

    SparkPositionDeltaWriteBuilder(SparkSession spark, Table table, String branch, RowLevelOperation.Command command, Scan scan, IsolationLevel isolationLevel, LogicalWriteInfo info) {
        this.spark = spark;
        this.table = table;
        this.command = command;
        this.scan = (SparkBatchQueryScan)scan;
        this.isolationLevel = isolationLevel;
        this.writeConf = new SparkWriteConf(spark, table, branch, (Map<String, String>)info.options());
        this.info = info;
        this.checkNullability = this.writeConf.checkNullability();
        this.checkOrdering = this.writeConf.checkOrdering();
    }

    public DeltaWrite build() {
        Schema dataSchema = this.dataSchema();
        this.validateRowIdSchema();
        this.validateMetadataSchema();
        SparkUtil.validatePartitionTransforms(this.table.spec());
        return new SparkPositionDeltaWrite(this.spark, this.table, this.command, this.scan, this.isolationLevel, this.writeConf, this.info, dataSchema);
    }

    private Schema dataSchema() {
        if (this.info.schema() == null || this.info.schema().isEmpty()) {
            return null;
        }
        Schema dataSchema = SparkSchemaUtil.convert(this.table.schema(), this.info.schema());
        this.validateSchema("data", this.table.schema(), dataSchema);
        return dataSchema;
    }

    private void validateRowIdSchema() {
        Preconditions.checkArgument((boolean)this.info.rowIdSchema().isPresent(), (Object)"Row ID schema must be set");
        StructType rowIdSparkType = (StructType)this.info.rowIdSchema().get();
        Schema rowIdSchema = SparkSchemaUtil.convert(EXPECTED_ROW_ID_SCHEMA, rowIdSparkType);
        this.validateSchema("row ID", EXPECTED_ROW_ID_SCHEMA, rowIdSchema);
    }

    private void validateMetadataSchema() {
        Preconditions.checkArgument((boolean)this.info.metadataSchema().isPresent(), (Object)"Metadata schema must be set");
        Schema expectedMetadataSchema = new Schema(new Types.NestedField[]{MetadataColumns.SPEC_ID, MetadataColumns.metadataColumn((Table)this.table, (String)"_partition")});
        StructType metadataSparkType = (StructType)this.info.metadataSchema().get();
        Schema metadataSchema = SparkSchemaUtil.convert(expectedMetadataSchema, metadataSparkType);
        this.validateSchema("metadata", expectedMetadataSchema, metadataSchema);
    }

    private void validateSchema(String context, Schema expected, Schema actual) {
        TypeUtil.validateSchema((String)context, (Schema)expected, (Schema)actual, (boolean)this.checkNullability, (boolean)this.checkOrdering);
    }
}

