/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import org.apache.iceberg.spark.SupportsFunctions;
import org.apache.iceberg.spark.procedures.SparkProcedures;
import org.apache.iceberg.spark.source.HasIcebergCatalog;
import org.apache.spark.sql.catalyst.analysis.NoSuchProcedureException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.StagingTableCatalog;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.iceberg.catalog.Procedure;
import org.apache.spark.sql.connector.iceberg.catalog.ProcedureCatalog;

abstract class BaseCatalog
implements StagingTableCatalog,
ProcedureCatalog,
SupportsNamespaces,
HasIcebergCatalog,
SupportsFunctions {
    BaseCatalog() {
    }

    @Override
    public Procedure loadProcedure(Identifier ident) throws NoSuchProcedureException {
        SparkProcedures.ProcedureBuilder builder;
        String[] namespace = ident.namespace();
        String name = ident.name();
        if (BaseCatalog.isSystemNamespace(namespace) && (builder = SparkProcedures.newBuilder(name)) != null) {
            return builder.withTableCatalog(this).build();
        }
        throw new NoSuchProcedureException(ident);
    }

    @Override
    public boolean isFunctionNamespace(String[] namespace) {
        return namespace.length == 0 || BaseCatalog.isSystemNamespace(namespace);
    }

    @Override
    public boolean isExistingNamespace(String[] namespace) {
        return this.namespaceExists(namespace);
    }

    private static boolean isSystemNamespace(String[] namespace) {
        return namespace.length == 1 && namespace[0].equalsIgnoreCase("system");
    }
}

