/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkStructLike;
import org.apache.iceberg.spark.SparkValueConverter;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;

public abstract class SparkContentFile<F>
implements ContentFile<F> {
    private final int fileContentPosition;
    private final int filePathPosition;
    private final int fileFormatPosition;
    private final int partitionPosition;
    private final int recordCountPosition;
    private final int fileSizeInBytesPosition;
    private final int columnSizesPosition;
    private final int valueCountsPosition;
    private final int nullValueCountsPosition;
    private final int nanValueCountsPosition;
    private final int lowerBoundsPosition;
    private final int upperBoundsPosition;
    private final int keyMetadataPosition;
    private final int splitOffsetsPosition;
    private final int sortOrderIdPosition;
    private final int equalityIdsPosition;
    private final Type lowerBoundsType;
    private final Type upperBoundsType;
    private final Type keyMetadataType;
    private final SparkStructLike wrappedPartition;
    private final StructLike projectedPartition;
    private Row wrapped;

    SparkContentFile(Types.StructType type, Types.StructType projectedType, StructType sparkType) {
        this.lowerBoundsType = type.fieldType(DataFile.LOWER_BOUNDS.name());
        this.upperBoundsType = type.fieldType(DataFile.UPPER_BOUNDS.name());
        this.keyMetadataType = type.fieldType(DataFile.KEY_METADATA.name());
        Types.StructType partitionType = type.fieldType("partition").asStructType();
        this.wrappedPartition = new SparkStructLike(partitionType);
        if (projectedType != null) {
            Types.StructType projectedPartitionType = projectedType.fieldType("partition").asStructType();
            StructProjection partitionProjection = StructProjection.create((Types.StructType)partitionType, (Types.StructType)projectedPartitionType);
            this.projectedPartition = partitionProjection.wrap((StructLike)this.wrappedPartition);
        } else {
            this.projectedPartition = this.wrappedPartition;
        }
        HashMap positions = Maps.newHashMap();
        for (Types.NestedField field : type.fields()) {
            String fieldName = field.name();
            positions.put(fieldName, this.fieldPosition(fieldName, sparkType));
        }
        this.fileContentPosition = (Integer)positions.get(DataFile.CONTENT.name());
        this.filePathPosition = (Integer)positions.get(DataFile.FILE_PATH.name());
        this.fileFormatPosition = (Integer)positions.get(DataFile.FILE_FORMAT.name());
        this.partitionPosition = (Integer)positions.get("partition");
        this.recordCountPosition = (Integer)positions.get(DataFile.RECORD_COUNT.name());
        this.fileSizeInBytesPosition = (Integer)positions.get(DataFile.FILE_SIZE.name());
        this.columnSizesPosition = (Integer)positions.get(DataFile.COLUMN_SIZES.name());
        this.valueCountsPosition = (Integer)positions.get(DataFile.VALUE_COUNTS.name());
        this.nullValueCountsPosition = (Integer)positions.get(DataFile.NULL_VALUE_COUNTS.name());
        this.nanValueCountsPosition = (Integer)positions.get(DataFile.NAN_VALUE_COUNTS.name());
        this.lowerBoundsPosition = (Integer)positions.get(DataFile.LOWER_BOUNDS.name());
        this.upperBoundsPosition = (Integer)positions.get(DataFile.UPPER_BOUNDS.name());
        this.keyMetadataPosition = (Integer)positions.get(DataFile.KEY_METADATA.name());
        this.splitOffsetsPosition = (Integer)positions.get(DataFile.SPLIT_OFFSETS.name());
        this.sortOrderIdPosition = (Integer)positions.get(DataFile.SORT_ORDER_ID.name());
        this.equalityIdsPosition = (Integer)positions.get(DataFile.EQUALITY_IDS.name());
    }

    public F wrap(Row row) {
        this.wrapped = row;
        if (this.wrappedPartition.size() > 0) {
            this.wrappedPartition.wrap((Row)row.getAs(this.partitionPosition));
        }
        return this.asFile();
    }

    protected abstract F asFile();

    public Long pos() {
        return null;
    }

    public int specId() {
        return -1;
    }

    public FileContent content() {
        if (this.wrapped.isNullAt(this.fileContentPosition)) {
            return null;
        }
        return FileContent.values()[this.wrapped.getInt(this.fileContentPosition)];
    }

    public CharSequence path() {
        return (CharSequence)this.wrapped.getAs(this.filePathPosition);
    }

    public FileFormat format() {
        return FileFormat.fromString((String)this.wrapped.getString(this.fileFormatPosition));
    }

    public StructLike partition() {
        return this.projectedPartition;
    }

    public long recordCount() {
        return (Long)this.wrapped.getAs(this.recordCountPosition);
    }

    public long fileSizeInBytes() {
        return (Long)this.wrapped.getAs(this.fileSizeInBytesPosition);
    }

    public Map<Integer, Long> columnSizes() {
        return this.wrapped.isNullAt(this.columnSizesPosition) ? null : this.wrapped.getJavaMap(this.columnSizesPosition);
    }

    public Map<Integer, Long> valueCounts() {
        return this.wrapped.isNullAt(this.valueCountsPosition) ? null : this.wrapped.getJavaMap(this.valueCountsPosition);
    }

    public Map<Integer, Long> nullValueCounts() {
        if (this.wrapped.isNullAt(this.nullValueCountsPosition)) {
            return null;
        }
        return this.wrapped.getJavaMap(this.nullValueCountsPosition);
    }

    public Map<Integer, Long> nanValueCounts() {
        if (this.wrapped.isNullAt(this.nanValueCountsPosition)) {
            return null;
        }
        return this.wrapped.getJavaMap(this.nanValueCountsPosition);
    }

    public Map<Integer, ByteBuffer> lowerBounds() {
        Map lowerBounds = this.wrapped.isNullAt(this.lowerBoundsPosition) ? null : this.wrapped.getJavaMap(this.lowerBoundsPosition);
        return (Map)this.convert(this.lowerBoundsType, lowerBounds);
    }

    public Map<Integer, ByteBuffer> upperBounds() {
        Map upperBounds = this.wrapped.isNullAt(this.upperBoundsPosition) ? null : this.wrapped.getJavaMap(this.upperBoundsPosition);
        return (Map)this.convert(this.upperBoundsType, upperBounds);
    }

    public ByteBuffer keyMetadata() {
        return (ByteBuffer)this.convert(this.keyMetadataType, this.wrapped.get(this.keyMetadataPosition));
    }

    public F copy() {
        throw new UnsupportedOperationException("Not implemented: copy");
    }

    public F copyWithoutStats() {
        throw new UnsupportedOperationException("Not implemented: copyWithoutStats");
    }

    public List<Long> splitOffsets() {
        return this.wrapped.isNullAt(this.splitOffsetsPosition) ? null : this.wrapped.getList(this.splitOffsetsPosition);
    }

    public Integer sortOrderId() {
        return (Integer)this.wrapped.getAs(this.sortOrderIdPosition);
    }

    public List<Integer> equalityFieldIds() {
        return this.wrapped.isNullAt(this.equalityIdsPosition) ? null : this.wrapped.getList(this.equalityIdsPosition);
    }

    private int fieldPosition(String name, StructType sparkType) {
        try {
            return sparkType.fieldIndex(name);
        }
        catch (IllegalArgumentException e) {
            if (name.equals("partition") && this.wrappedPartition.size() == 0) {
                return -1;
            }
            throw e;
        }
    }

    private <T> T convert(Type valueType, Object value) {
        return (T)SparkValueConverter.convert(valueType, value);
    }
}

