/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.iceberg.DistributionMode;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.IsolationLevel;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableProperties;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.spark.SparkCompressionUtil;
import org.apache.iceberg.spark.SparkConfParser;
import org.apache.iceberg.spark.SparkWriteRequirements;
import org.apache.iceberg.spark.SparkWriteUtil;
import org.apache.spark.sql.RuntimeConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.write.RowLevelOperation;
import org.apache.spark.sql.internal.SQLConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkWriteConf {
    private static final Logger LOG = LoggerFactory.getLogger(SparkWriteConf.class);
    private static final long DATA_FILE_SIZE = 0x8000000L;
    private static final long DELETE_FILE_SIZE = 0x2000000L;
    private final SparkSession spark;
    private final Table table;
    private final String branch;
    private final RuntimeConfig sessionConf;
    private final Map<String, String> writeOptions;
    private final SparkConfParser confParser;

    public SparkWriteConf(SparkSession spark, Table table, Map<String, String> writeOptions) {
        this(spark, table, null, writeOptions);
    }

    public SparkWriteConf(SparkSession spark, Table table, String branch, Map<String, String> writeOptions) {
        this.spark = spark;
        this.table = table;
        this.branch = branch;
        this.sessionConf = spark.conf();
        this.writeOptions = writeOptions;
        this.confParser = new SparkConfParser(spark, table, writeOptions);
    }

    public boolean checkNullability() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("check-nullability")).sessionConf("spark.sql.iceberg.check-nullability")).defaultValue(true).parse();
    }

    public boolean checkOrdering() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("check-ordering")).sessionConf("spark.sql.iceberg.check-ordering")).defaultValue(true).parse();
    }

    public String overwriteMode() {
        String overwriteMode = this.writeOptions.get("overwrite-mode");
        return overwriteMode != null ? overwriteMode.toLowerCase(Locale.ROOT) : null;
    }

    public boolean wapEnabled() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().tableProperty("write.wap.enabled")).defaultValue("false").parse();
    }

    public String wapId() {
        return this.sessionConf.get("spark.wap.id", null);
    }

    public boolean mergeSchema() {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("merge-schema")).option("mergeSchema")).defaultValue(false).parse();
    }

    public int outputSpecId() {
        int outputSpecId = ((SparkConfParser.IntConfParser)this.confParser.intConf().option("output-spec-id")).defaultValue(this.table.spec().specId()).parse();
        Preconditions.checkArgument((boolean)this.table.specs().containsKey(outputSpecId), (String)"Output spec id %s is not a valid spec id for table", (int)outputSpecId);
        return outputSpecId;
    }

    public FileFormat dataFileFormat() {
        String valueAsString = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("write-format")).tableProperty("write.format.default")).defaultValue("parquet").parse();
        return FileFormat.fromString((String)valueAsString);
    }

    private String dataCompressionCodec() {
        switch (this.dataFileFormat()) {
            case PARQUET: {
                return this.parquetCompressionCodec();
            }
            case AVRO: {
                return this.avroCompressionCodec();
            }
            case ORC: {
                return this.orcCompressionCodec();
            }
        }
        return null;
    }

    public long targetDataFileSize() {
        return ((SparkConfParser.LongConfParser)((SparkConfParser.LongConfParser)this.confParser.longConf().option("target-file-size-bytes")).tableProperty("write.target-file-size-bytes")).defaultValue(0x20000000L).parse();
    }

    public boolean useFanoutWriter(SparkWriteRequirements writeRequirements) {
        boolean defaultValue = !writeRequirements.hasOrdering();
        return this.fanoutWriterEnabled(defaultValue);
    }

    private boolean fanoutWriterEnabled() {
        return this.fanoutWriterEnabled(true);
    }

    private boolean fanoutWriterEnabled(boolean defaultValue) {
        return ((SparkConfParser.BooleanConfParser)((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("fanout-enabled")).tableProperty("write.spark.fanout.enabled")).defaultValue(defaultValue).parse();
    }

    public FileFormat deleteFileFormat() {
        String valueAsString = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("delete-format")).tableProperty("write.delete.format.default")).parseOptional();
        return valueAsString != null ? FileFormat.fromString((String)valueAsString) : this.dataFileFormat();
    }

    private String deleteCompressionCodec() {
        switch (this.deleteFileFormat()) {
            case PARQUET: {
                return this.deleteParquetCompressionCodec();
            }
            case AVRO: {
                return this.deleteAvroCompressionCodec();
            }
            case ORC: {
                return this.deleteOrcCompressionCodec();
            }
        }
        return null;
    }

    public long targetDeleteFileSize() {
        return ((SparkConfParser.LongConfParser)((SparkConfParser.LongConfParser)this.confParser.longConf().option("target-delete-file-size-bytes")).tableProperty("write.delete.target-file-size-bytes")).defaultValue(0x4000000L).parse();
    }

    public Map<String, String> extraSnapshotMetadata() {
        HashMap extraSnapshotMetadata = Maps.newHashMap();
        this.writeOptions.forEach((key, value) -> {
            if (key.startsWith("snapshot-property.")) {
                extraSnapshotMetadata.put(key.substring("snapshot-property.".length()), value);
            }
        });
        return extraSnapshotMetadata;
    }

    public String rewrittenFileSetId() {
        return ((SparkConfParser.StringConfParser)this.confParser.stringConf().option("rewritten-file-scan-task-set-id")).parseOptional();
    }

    public SparkWriteRequirements writeRequirements() {
        if (this.ignoreTableDistributionAndOrdering()) {
            LOG.info("Skipping distribution/ordering: disabled per job configuration");
            return SparkWriteRequirements.EMPTY;
        }
        return SparkWriteUtil.writeRequirements(this.table, this.distributionMode(), this.fanoutWriterEnabled(), this.dataAdvisoryPartitionSize());
    }

    @VisibleForTesting
    DistributionMode distributionMode() {
        String modeName = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("distribution-mode")).sessionConf("spark.sql.iceberg.distribution-mode")).tableProperty("write.distribution-mode")).parseOptional();
        if (modeName != null) {
            DistributionMode mode = DistributionMode.fromName((String)modeName);
            return this.adjustWriteDistributionMode(mode);
        }
        return this.defaultWriteDistributionMode();
    }

    private DistributionMode adjustWriteDistributionMode(DistributionMode mode) {
        if (mode == DistributionMode.RANGE && this.table.spec().isUnpartitioned() && this.table.sortOrder().isUnsorted()) {
            return DistributionMode.NONE;
        }
        if (mode == DistributionMode.HASH && this.table.spec().isUnpartitioned()) {
            return DistributionMode.NONE;
        }
        return mode;
    }

    private DistributionMode defaultWriteDistributionMode() {
        if (this.table.sortOrder().isSorted()) {
            return DistributionMode.RANGE;
        }
        if (this.table.spec().isPartitioned()) {
            return DistributionMode.HASH;
        }
        return DistributionMode.NONE;
    }

    public SparkWriteRequirements copyOnWriteRequirements(RowLevelOperation.Command command) {
        if (this.ignoreTableDistributionAndOrdering()) {
            LOG.info("Skipping distribution/ordering: disabled per job configuration");
            return SparkWriteRequirements.EMPTY;
        }
        return SparkWriteUtil.copyOnWriteRequirements(this.table, command, this.copyOnWriteDistributionMode(command), this.fanoutWriterEnabled(), this.dataAdvisoryPartitionSize());
    }

    @VisibleForTesting
    DistributionMode copyOnWriteDistributionMode(RowLevelOperation.Command command) {
        switch (command) {
            case DELETE: {
                return this.deleteDistributionMode();
            }
            case UPDATE: {
                return this.updateDistributionMode();
            }
            case MERGE: {
                return this.copyOnWriteMergeDistributionMode();
            }
        }
        throw new IllegalArgumentException("Unexpected command: " + command);
    }

    public SparkWriteRequirements positionDeltaRequirements(RowLevelOperation.Command command) {
        if (this.ignoreTableDistributionAndOrdering()) {
            LOG.info("Skipping distribution/ordering: disabled per job configuration");
            return SparkWriteRequirements.EMPTY;
        }
        return SparkWriteUtil.positionDeltaRequirements(this.table, command, this.positionDeltaDistributionMode(command), this.fanoutWriterEnabled(), command == RowLevelOperation.Command.DELETE ? this.deleteAdvisoryPartitionSize() : this.dataAdvisoryPartitionSize());
    }

    @VisibleForTesting
    DistributionMode positionDeltaDistributionMode(RowLevelOperation.Command command) {
        switch (command) {
            case DELETE: {
                return this.deleteDistributionMode();
            }
            case UPDATE: {
                return this.updateDistributionMode();
            }
            case MERGE: {
                return this.positionDeltaMergeDistributionMode();
            }
        }
        throw new IllegalArgumentException("Unexpected command: " + command);
    }

    private DistributionMode deleteDistributionMode() {
        String deleteModeName = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("distribution-mode")).sessionConf("spark.sql.iceberg.distribution-mode")).tableProperty("write.delete.distribution-mode")).defaultValue("hash").parse();
        return DistributionMode.fromName((String)deleteModeName);
    }

    private DistributionMode updateDistributionMode() {
        String updateModeName = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("distribution-mode")).sessionConf("spark.sql.iceberg.distribution-mode")).tableProperty("write.update.distribution-mode")).defaultValue("hash").parse();
        return DistributionMode.fromName((String)updateModeName);
    }

    private DistributionMode copyOnWriteMergeDistributionMode() {
        String mergeModeName = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("distribution-mode")).sessionConf("spark.sql.iceberg.distribution-mode")).tableProperty("write.merge.distribution-mode")).parseOptional();
        if (mergeModeName != null) {
            DistributionMode mergeMode = DistributionMode.fromName((String)mergeModeName);
            return this.adjustWriteDistributionMode(mergeMode);
        }
        if (this.table.spec().isPartitioned()) {
            return DistributionMode.HASH;
        }
        return this.distributionMode();
    }

    private DistributionMode positionDeltaMergeDistributionMode() {
        String mergeModeName = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("distribution-mode")).sessionConf("spark.sql.iceberg.distribution-mode")).tableProperty("write.merge.distribution-mode")).defaultValue("hash").parse();
        return DistributionMode.fromName((String)mergeModeName);
    }

    private boolean ignoreTableDistributionAndOrdering() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().option("use-table-distribution-and-ordering")).defaultValue(true).negate().parse();
    }

    public Long validateFromSnapshotId() {
        return ((SparkConfParser.LongConfParser)this.confParser.longConf().option("validate-from-snapshot-id")).parseOptional();
    }

    public IsolationLevel isolationLevel() {
        String isolationLevelName = ((SparkConfParser.StringConfParser)this.confParser.stringConf().option("isolation-level")).parseOptional();
        return isolationLevelName != null ? IsolationLevel.fromName((String)isolationLevelName) : null;
    }

    public boolean caseSensitive() {
        return ((SparkConfParser.BooleanConfParser)this.confParser.booleanConf().sessionConf(SQLConf.CASE_SENSITIVE().key())).defaultValue(SQLConf.CASE_SENSITIVE().defaultValueString()).parse();
    }

    public String branch() {
        if (this.wapEnabled()) {
            String wapId = this.wapId();
            String wapBranch = ((SparkConfParser.StringConfParser)this.confParser.stringConf().sessionConf("spark.wap.branch")).parseOptional();
            ValidationException.check((wapId == null || wapBranch == null ? 1 : 0) != 0, (String)"Cannot set both WAP ID and branch, but got ID [%s] and branch [%s]", (Object[])new Object[]{wapId, wapBranch});
            if (wapBranch != null) {
                ValidationException.check((this.branch == null ? 1 : 0) != 0, (String)"Cannot write to both branch and WAP branch, but got branch [%s] and WAP branch [%s]", (Object[])new Object[]{this.branch, wapBranch});
                return wapBranch;
            }
        }
        return this.branch;
    }

    public Map<String, String> writeProperties() {
        HashMap writeProperties = Maps.newHashMap();
        writeProperties.putAll(this.dataWriteProperties());
        writeProperties.putAll(this.deleteWriteProperties());
        return writeProperties;
    }

    private Map<String, String> dataWriteProperties() {
        HashMap writeProperties = Maps.newHashMap();
        FileFormat dataFormat = this.dataFileFormat();
        switch (dataFormat) {
            case PARQUET: {
                writeProperties.put("write.parquet.compression-codec", this.parquetCompressionCodec());
                String parquetCompressionLevel = this.parquetCompressionLevel();
                if (parquetCompressionLevel == null) break;
                writeProperties.put("write.parquet.compression-level", parquetCompressionLevel);
                break;
            }
            case AVRO: {
                writeProperties.put("write.avro.compression-codec", this.avroCompressionCodec());
                String avroCompressionLevel = this.avroCompressionLevel();
                if (avroCompressionLevel == null) break;
                writeProperties.put("write.avro.compression-level", avroCompressionLevel);
                break;
            }
            case ORC: {
                writeProperties.put("write.orc.compression-codec", this.orcCompressionCodec());
                writeProperties.put("write.orc.compression-strategy", this.orcCompressionStrategy());
                break;
            }
        }
        return writeProperties;
    }

    private Map<String, String> deleteWriteProperties() {
        HashMap writeProperties = Maps.newHashMap();
        FileFormat deleteFormat = this.deleteFileFormat();
        switch (deleteFormat) {
            case PARQUET: {
                writeProperties.put("write.delete.parquet.compression-codec", this.deleteParquetCompressionCodec());
                String deleteParquetCompressionLevel = this.deleteParquetCompressionLevel();
                if (deleteParquetCompressionLevel == null) break;
                writeProperties.put("write.delete.parquet.compression-level", deleteParquetCompressionLevel);
                break;
            }
            case AVRO: {
                writeProperties.put("write.delete.avro.compression-codec", this.deleteAvroCompressionCodec());
                String deleteAvroCompressionLevel = this.deleteAvroCompressionLevel();
                if (deleteAvroCompressionLevel == null) break;
                writeProperties.put("write.delete.avro.compression-level", deleteAvroCompressionLevel);
                break;
            }
            case ORC: {
                writeProperties.put("write.delete.orc.compression-codec", this.deleteOrcCompressionCodec());
                writeProperties.put("write.delete.orc.compression-strategy", this.deleteOrcCompressionStrategy());
                break;
            }
        }
        return writeProperties;
    }

    private String parquetCompressionCodec() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-codec")).sessionConf("spark.sql.iceberg.compression-codec")).tableProperty("write.parquet.compression-codec")).defaultValue("gzip").parse();
    }

    private String deleteParquetCompressionCodec() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-codec")).sessionConf("spark.sql.iceberg.compression-codec")).tableProperty("write.delete.parquet.compression-codec")).defaultValue(this.parquetCompressionCodec()).parse();
    }

    private String parquetCompressionLevel() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-level")).sessionConf("spark.sql.iceberg.compression-level")).tableProperty("write.parquet.compression-level")).defaultValue(TableProperties.PARQUET_COMPRESSION_LEVEL_DEFAULT).parseOptional();
    }

    private String deleteParquetCompressionLevel() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-level")).sessionConf("spark.sql.iceberg.compression-level")).tableProperty("write.delete.parquet.compression-level")).defaultValue(this.parquetCompressionLevel()).parseOptional();
    }

    private String avroCompressionCodec() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-codec")).sessionConf("spark.sql.iceberg.compression-codec")).tableProperty("write.avro.compression-codec")).defaultValue("gzip").parse();
    }

    private String deleteAvroCompressionCodec() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-codec")).sessionConf("spark.sql.iceberg.compression-codec")).tableProperty("write.delete.avro.compression-codec")).defaultValue(this.avroCompressionCodec()).parse();
    }

    private String avroCompressionLevel() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-level")).sessionConf("spark.sql.iceberg.compression-level")).tableProperty("write.avro.compression-level")).defaultValue(TableProperties.AVRO_COMPRESSION_LEVEL_DEFAULT).parseOptional();
    }

    private String deleteAvroCompressionLevel() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-level")).sessionConf("spark.sql.iceberg.compression-level")).tableProperty("write.delete.avro.compression-level")).defaultValue(this.avroCompressionLevel()).parseOptional();
    }

    private String orcCompressionCodec() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-codec")).sessionConf("spark.sql.iceberg.compression-codec")).tableProperty("write.orc.compression-codec")).defaultValue("zlib").parse();
    }

    private String deleteOrcCompressionCodec() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-codec")).sessionConf("spark.sql.iceberg.compression-codec")).tableProperty("write.delete.orc.compression-codec")).defaultValue(this.orcCompressionCodec()).parse();
    }

    private String orcCompressionStrategy() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-strategy")).sessionConf("spark.sql.iceberg.compression-strategy")).tableProperty("write.orc.compression-strategy")).defaultValue("speed").parse();
    }

    private String deleteOrcCompressionStrategy() {
        return ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("compression-strategy")).sessionConf("spark.sql.iceberg.compression-strategy")).tableProperty("write.delete.orc.compression-strategy")).defaultValue(this.orcCompressionStrategy()).parse();
    }

    private long dataAdvisoryPartitionSize() {
        long defaultValue = this.advisoryPartitionSize(0x8000000L, this.dataFileFormat(), this.dataCompressionCodec());
        return this.advisoryPartitionSize(defaultValue);
    }

    private long deleteAdvisoryPartitionSize() {
        long defaultValue = this.advisoryPartitionSize(0x2000000L, this.deleteFileFormat(), this.deleteCompressionCodec());
        return this.advisoryPartitionSize(defaultValue);
    }

    private long advisoryPartitionSize(long defaultValue) {
        return ((SparkConfParser.LongConfParser)((SparkConfParser.LongConfParser)((SparkConfParser.LongConfParser)this.confParser.longConf().option("advisory-partition-size")).sessionConf("spark.sql.iceberg.advisory-partition-size")).tableProperty("write.spark.advisory-partition-size-bytes")).defaultValue(defaultValue).parse();
    }

    private long advisoryPartitionSize(long expectedFileSize, FileFormat outputFileFormat, String outputCodec) {
        double shuffleCompressionRatio = this.shuffleCompressionRatio(outputFileFormat, outputCodec);
        long suggestedAdvisoryPartitionSize = (long)((double)expectedFileSize * shuffleCompressionRatio);
        return Math.max(suggestedAdvisoryPartitionSize, this.sparkAdvisoryPartitionSize());
    }

    private long sparkAdvisoryPartitionSize() {
        return (Long)this.spark.sessionState().conf().getConf(SQLConf.ADVISORY_PARTITION_SIZE_IN_BYTES());
    }

    private double shuffleCompressionRatio(FileFormat outputFileFormat, String outputCodec) {
        return SparkCompressionUtil.shuffleCompressionRatio(this.spark, outputFileFormat, outputCodec);
    }

    public DeleteGranularity deleteGranularity() {
        String valueAsString = ((SparkConfParser.StringConfParser)((SparkConfParser.StringConfParser)this.confParser.stringConf().option("delete-granularity")).tableProperty("write.delete.granularity")).defaultValue(TableProperties.DELETE_GRANULARITY_DEFAULT).parse();
        return DeleteGranularity.fromString((String)valueAsString);
    }
}

