/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.spark.util.AccumulatorV2;

public class SetAccumulator<T>
extends AccumulatorV2<T, Set<T>> {
    private final Set<T> set = Collections.synchronizedSet(Sets.newHashSet());

    public boolean isZero() {
        return this.set.isEmpty();
    }

    public AccumulatorV2<T, Set<T>> copy() {
        SetAccumulator<T> newAccumulator = new SetAccumulator<T>();
        newAccumulator.set.addAll(this.set);
        return newAccumulator;
    }

    public void reset() {
        this.set.clear();
    }

    public void add(T v) {
        this.set.add(v);
    }

    public void merge(AccumulatorV2<T, Set<T>> other) {
        this.set.addAll((Collection)other.value());
    }

    public Set<T> value() {
        return this.set;
    }
}

