/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.ChangelogOperation;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterators;
import org.apache.iceberg.spark.ComputeUpdateIterator;
import org.apache.iceberg.spark.RemoveCarryoverIterator;
import org.apache.iceberg.spark.RemoveNetCarryoverIterator;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;

public abstract class ChangelogIterator
implements Iterator<Row> {
    protected static final String DELETE = ChangelogOperation.DELETE.name();
    protected static final String INSERT = ChangelogOperation.INSERT.name();
    protected static final String UPDATE_BEFORE = ChangelogOperation.UPDATE_BEFORE.name();
    protected static final String UPDATE_AFTER = ChangelogOperation.UPDATE_AFTER.name();
    private final Iterator<Row> rowIterator;
    private final int changeTypeIndex;
    private final StructType rowType;

    protected ChangelogIterator(Iterator<Row> rowIterator, StructType rowType) {
        this.rowIterator = rowIterator;
        this.rowType = rowType;
        this.changeTypeIndex = rowType.fieldIndex(MetadataColumns.CHANGE_TYPE.name());
    }

    protected int changeTypeIndex() {
        return this.changeTypeIndex;
    }

    protected StructType rowType() {
        return this.rowType;
    }

    protected String changeType(Row row) {
        String changeType = row.getString(this.changeTypeIndex());
        Preconditions.checkNotNull((Object)changeType, (Object)"Change type should not be null");
        return changeType;
    }

    protected Iterator<Row> rowIterator() {
        return this.rowIterator;
    }

    public static Iterator<Row> computeUpdates(Iterator<Row> rowIterator, StructType rowType, String[] identifierFields) {
        Iterator<Row> carryoverRemoveIterator = ChangelogIterator.removeCarryovers(rowIterator, rowType);
        ComputeUpdateIterator changelogIterator = new ComputeUpdateIterator(carryoverRemoveIterator, rowType, identifierFields);
        return Iterators.filter((Iterator)changelogIterator, Objects::nonNull);
    }

    public static Iterator<Row> removeCarryovers(Iterator<Row> rowIterator, StructType rowType) {
        RemoveCarryoverIterator changelogIterator = new RemoveCarryoverIterator(rowIterator, rowType);
        return Iterators.filter((Iterator)changelogIterator, Objects::nonNull);
    }

    public static Iterator<Row> removeNetCarryovers(Iterator<Row> rowIterator, StructType rowType) {
        RemoveNetCarryoverIterator changelogIterator = new RemoveNetCarryoverIterator(rowIterator, rowType);
        return Iterators.filter((Iterator)changelogIterator, Objects::nonNull);
    }

    protected boolean isSameRecord(Row currentRow, Row nextRow, int[] indicesToIdentifySameRow) {
        for (int idx : indicesToIdentifySameRow) {
            if (!this.isDifferentValue(currentRow, nextRow, idx)) continue;
            return false;
        }
        return true;
    }

    protected boolean isDifferentValue(Row currentRow, Row nextRow, int idx) {
        return !Objects.equals(nextRow.get(idx), currentRow.get(idx));
    }

    protected static int[] generateIndicesToIdentifySameRow(int totalColumnCount, Set<Integer> metadataColumnIndices) {
        int[] indices = new int[totalColumnCount - metadataColumnIndices.size()];
        int j = 0;
        for (int i = 0; i < indices.length; ++i) {
            if (metadataColumnIndices.contains(i)) continue;
            indices[j] = i;
            ++j;
        }
        return indices;
    }
}

