/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.functions;

import org.apache.iceberg.spark.functions.BaseScalarFunction;
import org.apache.iceberg.spark.functions.UnaryUnboundFunction;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.catalog.functions.BoundFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.TimestampNTZType;
import org.apache.spark.sql.types.TimestampType;

public class DaysFunction
extends UnaryUnboundFunction {
    @Override
    protected BoundFunction doBind(DataType valueType) {
        if (valueType instanceof DateType) {
            return new DateToDaysFunction();
        }
        if (valueType instanceof TimestampType) {
            return new TimestampToDaysFunction();
        }
        if (valueType instanceof TimestampNTZType) {
            return new TimestampNtzToDaysFunction();
        }
        throw new UnsupportedOperationException("Expected value to be date or timestamp: " + valueType.catalogString());
    }

    public String description() {
        return this.name() + "(col) - Call Iceberg's day transform\n  col :: source column (must be date or timestamp)";
    }

    public String name() {
        return "days";
    }

    public static class TimestampNtzToDaysFunction
    extends BaseToDaysFunction {
        public static int invoke(long micros) {
            return DateTimeUtil.microsToDays((long)micros);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.TimestampNTZType};
        }

        public String canonicalName() {
            return "iceberg.days(timestamp_ntz)";
        }

        public Integer produceResult(InternalRow input) {
            return input.isNullAt(0) ? null : Integer.valueOf(TimestampNtzToDaysFunction.invoke(input.getLong(0)));
        }
    }

    public static class TimestampToDaysFunction
    extends BaseToDaysFunction {
        public static int invoke(long micros) {
            return DateTimeUtil.microsToDays((long)micros);
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.TimestampType};
        }

        public String canonicalName() {
            return "iceberg.days(timestamp)";
        }

        public Integer produceResult(InternalRow input) {
            return input.isNullAt(0) ? null : Integer.valueOf(TimestampToDaysFunction.invoke(input.getLong(0)));
        }
    }

    public static class DateToDaysFunction
    extends BaseToDaysFunction {
        public static int invoke(int days) {
            return days;
        }

        public DataType[] inputTypes() {
            return new DataType[]{DataTypes.DateType};
        }

        public String canonicalName() {
            return "iceberg.days(date)";
        }

        public Integer produceResult(InternalRow input) {
            return input.isNullAt(0) ? null : Integer.valueOf(input.getInt(0));
        }
    }

    private static abstract class BaseToDaysFunction
    extends BaseScalarFunction<Integer> {
        private BaseToDaysFunction() {
        }

        public String name() {
            return "days";
        }

        public DataType resultType() {
            return DataTypes.DateType;
        }
    }
}

