/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.Table;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.metrics.ScanReport;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.Spark3Util;
import org.apache.iceberg.spark.SparkReadConf;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.spark.source.SparkBatch;
import org.apache.iceberg.spark.source.SparkMicroBatchStream;
import org.apache.iceberg.spark.source.Stats;
import org.apache.iceberg.spark.source.metrics.EqualityDeleteFiles;
import org.apache.iceberg.spark.source.metrics.IndexedDeleteFiles;
import org.apache.iceberg.spark.source.metrics.NumDeletes;
import org.apache.iceberg.spark.source.metrics.NumSplits;
import org.apache.iceberg.spark.source.metrics.PositionalDeleteFiles;
import org.apache.iceberg.spark.source.metrics.ResultDataFiles;
import org.apache.iceberg.spark.source.metrics.ResultDeleteFiles;
import org.apache.iceberg.spark.source.metrics.ScannedDataManifests;
import org.apache.iceberg.spark.source.metrics.ScannedDeleteManifests;
import org.apache.iceberg.spark.source.metrics.SkippedDataFiles;
import org.apache.iceberg.spark.source.metrics.SkippedDataManifests;
import org.apache.iceberg.spark.source.metrics.SkippedDeleteFiles;
import org.apache.iceberg.spark.source.metrics.SkippedDeleteManifests;
import org.apache.iceberg.spark.source.metrics.TaskEqualityDeleteFiles;
import org.apache.iceberg.spark.source.metrics.TaskIndexedDeleteFiles;
import org.apache.iceberg.spark.source.metrics.TaskPositionalDeleteFiles;
import org.apache.iceberg.spark.source.metrics.TaskResultDataFiles;
import org.apache.iceberg.spark.source.metrics.TaskResultDeleteFiles;
import org.apache.iceberg.spark.source.metrics.TaskScannedDataManifests;
import org.apache.iceberg.spark.source.metrics.TaskScannedDeleteManifests;
import org.apache.iceberg.spark.source.metrics.TaskSkippedDataFiles;
import org.apache.iceberg.spark.source.metrics.TaskSkippedDataManifests;
import org.apache.iceberg.spark.source.metrics.TaskSkippedDeleteFiles;
import org.apache.iceberg.spark.source.metrics.TaskSkippedDeleteManifests;
import org.apache.iceberg.spark.source.metrics.TaskTotalDataFileSize;
import org.apache.iceberg.spark.source.metrics.TaskTotalDataManifests;
import org.apache.iceberg.spark.source.metrics.TaskTotalDeleteFileSize;
import org.apache.iceberg.spark.source.metrics.TaskTotalDeleteManifests;
import org.apache.iceberg.spark.source.metrics.TaskTotalPlanningDuration;
import org.apache.iceberg.spark.source.metrics.TotalDataFileSize;
import org.apache.iceberg.spark.source.metrics.TotalDataManifests;
import org.apache.iceberg.spark.source.metrics.TotalDeleteFileSize;
import org.apache.iceberg.spark.source.metrics.TotalDeleteManifests;
import org.apache.iceberg.spark.source.metrics.TotalPlanningDuration;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SnapshotUtil;
import org.apache.iceberg.util.TableScanUtil;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.metric.CustomMetric;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;
import org.apache.spark.sql.connector.read.Batch;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.connector.read.Statistics;
import org.apache.spark.sql.connector.read.SupportsReportStatistics;
import org.apache.spark.sql.connector.read.streaming.MicroBatchStream;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SparkScan
implements Scan,
SupportsReportStatistics {
    private static final Logger LOG = LoggerFactory.getLogger(SparkScan.class);
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final SparkReadConf readConf;
    private final boolean caseSensitive;
    private final Schema expectedSchema;
    private final List<Expression> filterExpressions;
    private final String branch;
    private final Supplier<ScanReport> scanReportSupplier;
    private StructType readSchema;

    SparkScan(SparkSession spark, Table table, SparkReadConf readConf, Schema expectedSchema, List<Expression> filters, Supplier<ScanReport> scanReportSupplier) {
        Schema snapshotSchema = SnapshotUtil.schemaFor((Table)table, (String)readConf.branch());
        SparkSchemaUtil.validateMetadataColumnReferences(snapshotSchema, expectedSchema);
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        this.table = table;
        this.readConf = readConf;
        this.caseSensitive = readConf.caseSensitive();
        this.expectedSchema = expectedSchema;
        this.filterExpressions = filters != null ? filters : Collections.emptyList();
        this.branch = readConf.branch();
        this.scanReportSupplier = scanReportSupplier;
    }

    protected Table table() {
        return this.table;
    }

    protected String branch() {
        return this.branch;
    }

    protected boolean caseSensitive() {
        return this.caseSensitive;
    }

    protected Schema expectedSchema() {
        return this.expectedSchema;
    }

    protected List<Expression> filterExpressions() {
        return this.filterExpressions;
    }

    protected Types.StructType groupingKeyType() {
        return Types.StructType.of((Types.NestedField[])new Types.NestedField[0]);
    }

    protected abstract List<? extends ScanTaskGroup<?>> taskGroups();

    public Batch toBatch() {
        return new SparkBatch(this.sparkContext, this.table, this.readConf, this.groupingKeyType(), this.taskGroups(), this.expectedSchema, this.hashCode());
    }

    public MicroBatchStream toMicroBatchStream(String checkpointLocation) {
        return new SparkMicroBatchStream(this.sparkContext, this.table, this.readConf, this.expectedSchema, checkpointLocation);
    }

    public StructType readSchema() {
        if (this.readSchema == null) {
            this.readSchema = SparkSchemaUtil.convert(this.expectedSchema);
        }
        return this.readSchema;
    }

    public Statistics estimateStatistics() {
        return this.estimateStatistics(SnapshotUtil.latestSnapshot((Table)this.table, (String)this.branch));
    }

    protected Statistics estimateStatistics(Snapshot snapshot) {
        if (snapshot == null) {
            return new Stats(0L, 0L);
        }
        if (!this.table.spec().isUnpartitioned() && this.filterExpressions.isEmpty()) {
            LOG.debug("Using snapshot {} metadata to estimate statistics for table {}", (Object)snapshot.snapshotId(), (Object)this.table.name());
            long totalRecords = this.totalRecords(snapshot);
            return new Stats(SparkSchemaUtil.estimateSize(this.readSchema(), totalRecords), totalRecords);
        }
        long rowsCount = this.taskGroups().stream().mapToLong(ScanTaskGroup::estimatedRowsCount).sum();
        long sizeInBytes = SparkSchemaUtil.estimateSize(this.readSchema(), rowsCount);
        return new Stats(sizeInBytes, rowsCount);
    }

    private long totalRecords(Snapshot snapshot) {
        Map summary = snapshot.summary();
        return PropertyUtil.propertyAsLong((Map)summary, (String)"total-records", (long)Long.MAX_VALUE);
    }

    public String description() {
        String groupingKeyFieldNamesAsString = this.groupingKeyType().fields().stream().map(Types.NestedField::name).collect(Collectors.joining(", "));
        return String.format("%s (branch=%s) [filters=%s, groupedBy=%s]", this.table(), this.branch(), Spark3Util.describe(this.filterExpressions), groupingKeyFieldNamesAsString);
    }

    public CustomTaskMetric[] reportDriverMetrics() {
        ScanReport scanReport;
        ScanReport scanReport2 = scanReport = this.scanReportSupplier != null ? this.scanReportSupplier.get() : null;
        if (scanReport == null) {
            return new CustomTaskMetric[0];
        }
        ArrayList driverMetrics = Lists.newArrayList();
        driverMetrics.add(TaskTotalPlanningDuration.from(scanReport));
        driverMetrics.add(TaskTotalDataManifests.from(scanReport));
        driverMetrics.add(TaskScannedDataManifests.from(scanReport));
        driverMetrics.add(TaskSkippedDataManifests.from(scanReport));
        driverMetrics.add(TaskResultDataFiles.from(scanReport));
        driverMetrics.add(TaskSkippedDataFiles.from(scanReport));
        driverMetrics.add(TaskTotalDataFileSize.from(scanReport));
        driverMetrics.add(TaskTotalDeleteManifests.from(scanReport));
        driverMetrics.add(TaskScannedDeleteManifests.from(scanReport));
        driverMetrics.add(TaskSkippedDeleteManifests.from(scanReport));
        driverMetrics.add(TaskTotalDeleteFileSize.from(scanReport));
        driverMetrics.add(TaskResultDeleteFiles.from(scanReport));
        driverMetrics.add(TaskEqualityDeleteFiles.from(scanReport));
        driverMetrics.add(TaskIndexedDeleteFiles.from(scanReport));
        driverMetrics.add(TaskPositionalDeleteFiles.from(scanReport));
        driverMetrics.add(TaskSkippedDeleteFiles.from(scanReport));
        return driverMetrics.toArray(new CustomTaskMetric[0]);
    }

    public CustomMetric[] supportedCustomMetrics() {
        return new CustomMetric[]{new NumSplits(), new NumDeletes(), new TotalPlanningDuration(), new TotalDataManifests(), new ScannedDataManifests(), new SkippedDataManifests(), new ResultDataFiles(), new SkippedDataFiles(), new TotalDataFileSize(), new TotalDeleteManifests(), new ScannedDeleteManifests(), new SkippedDeleteManifests(), new TotalDeleteFileSize(), new ResultDeleteFiles(), new EqualityDeleteFiles(), new IndexedDeleteFiles(), new PositionalDeleteFiles(), new SkippedDeleteFiles()};
    }

    protected long adjustSplitSize(List<? extends ScanTask> tasks, long splitSize) {
        if (this.readConf.splitSizeOption() == null && this.readConf.adaptiveSplitSizeEnabled()) {
            long scanSize = tasks.stream().mapToLong(ScanTask::sizeBytes).sum();
            int parallelism = this.readConf.parallelism();
            return TableScanUtil.adjustSplitSize((long)scanSize, (int)parallelism, (long)splitSize);
        }
        return splitSize;
    }
}

