/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.util.Map;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.spark.SparkSchemaUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.view.BaseView;
import org.apache.iceberg.view.SQLViewRepresentation;
import org.apache.iceberg.view.ViewOperations;
import org.apache.spark.sql.connector.catalog.View;
import org.apache.spark.sql.types.StructType;

public class SparkView
implements View {
    public static final String QUERY_COLUMN_NAMES = "spark.query-column-names";
    public static final Set<String> RESERVED_PROPERTIES = ImmutableSet.of((Object)"provider", (Object)"location", (Object)"format-version", (Object)"spark.query-column-names");
    private final org.apache.iceberg.view.View icebergView;
    private final String catalogName;
    private StructType lazySchema = null;

    public SparkView(String catalogName, org.apache.iceberg.view.View icebergView) {
        this.catalogName = catalogName;
        this.icebergView = icebergView;
    }

    public org.apache.iceberg.view.View view() {
        return this.icebergView;
    }

    public String name() {
        return this.icebergView.name();
    }

    public String query() {
        SQLViewRepresentation sqlRepr = this.icebergView.sqlFor("spark");
        Preconditions.checkState((sqlRepr != null ? 1 : 0) != 0, (String)"Cannot load SQL for view %s", (Object)this.name());
        return sqlRepr.sql();
    }

    public String currentCatalog() {
        return this.icebergView.currentVersion().defaultCatalog() != null ? this.icebergView.currentVersion().defaultCatalog() : this.catalogName;
    }

    public String[] currentNamespace() {
        return this.icebergView.currentVersion().defaultNamespace().levels();
    }

    public StructType schema() {
        if (null == this.lazySchema) {
            this.lazySchema = SparkSchemaUtil.convert(this.icebergView.schema());
        }
        return this.lazySchema;
    }

    public String[] queryColumnNames() {
        return this.icebergView.properties().containsKey(QUERY_COLUMN_NAMES) ? ((String)this.icebergView.properties().get(QUERY_COLUMN_NAMES)).split(",") : new String[]{};
    }

    public String[] columnAliases() {
        return (String[])this.icebergView.schema().columns().stream().map(Types.NestedField::name).toArray(String[]::new);
    }

    public String[] columnComments() {
        return (String[])this.icebergView.schema().columns().stream().map(Types.NestedField::doc).toArray(String[]::new);
    }

    public Map<String, String> properties() {
        ImmutableMap.Builder propsBuilder = ImmutableMap.builder();
        propsBuilder.put((Object)"provider", (Object)"iceberg");
        propsBuilder.put((Object)"location", (Object)this.icebergView.location());
        if (this.icebergView instanceof BaseView) {
            ViewOperations ops = ((BaseView)this.icebergView).operations();
            propsBuilder.put((Object)"format-version", (Object)String.valueOf(ops.current().formatVersion()));
        }
        this.icebergView.properties().entrySet().stream().filter(entry -> !RESERVED_PROPERTIES.contains(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)propsBuilder).put(arg_0));
        return propsBuilder.build();
    }

    public String toString() {
        return this.icebergView.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SparkView that = (SparkView)other;
        return this.icebergView.name().equals(that.icebergView.name());
    }

    public int hashCode() {
        return this.icebergView.name().hashCode();
    }
}

