/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source.metrics;

import org.apache.iceberg.metrics.ScanReport;
import org.apache.iceberg.metrics.TimerResult;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;

public class TaskTotalPlanningDuration
implements CustomTaskMetric {
    private final long value;

    private TaskTotalPlanningDuration(long value) {
        this.value = value;
    }

    public String name() {
        return "totalPlanningDuration";
    }

    public long value() {
        return this.value;
    }

    public static TaskTotalPlanningDuration from(ScanReport scanReport) {
        TimerResult timerResult = scanReport.scanMetrics().totalPlanningDuration();
        long value = timerResult != null ? timerResult.totalDuration().toMillis() : -1L;
        return new TaskTotalPlanningDuration(value);
    }
}

