/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.io.ClusteredPositionDeleteWriter;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.spark.PositionDeletesRewriteCoordinator;
import org.apache.iceberg.spark.SparkWriteConf;
import org.apache.iceberg.spark.source.SerializableTableWithSize;
import org.apache.iceberg.spark.source.SparkCleanupUtil;
import org.apache.iceberg.spark.source.SparkFileWriterFactory;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.DataWriter;
import org.apache.spark.sql.connector.write.DataWriterFactory;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class SparkPositionDeletesRewrite
implements Write {
    private final JavaSparkContext sparkContext;
    private final Table table;
    private final String queryId;
    private final FileFormat format;
    private final long targetFileSize;
    private final DeleteGranularity deleteGranularity;
    private final Schema writeSchema;
    private final StructType dsSchema;
    private final String fileSetId;
    private final int specId;
    private final StructLike partition;
    private final Map<String, String> writeProperties;

    SparkPositionDeletesRewrite(SparkSession spark, Table table, SparkWriteConf writeConf, LogicalWriteInfo writeInfo, Schema writeSchema, StructType dsSchema, int specId, StructLike partition) {
        this.sparkContext = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        this.table = table;
        this.queryId = writeInfo.queryId();
        this.format = writeConf.deleteFileFormat();
        this.targetFileSize = writeConf.targetDeleteFileSize();
        this.deleteGranularity = writeConf.deleteGranularity();
        this.writeSchema = writeSchema;
        this.dsSchema = dsSchema;
        this.fileSetId = writeConf.rewrittenFileSetId();
        this.specId = specId;
        this.partition = partition;
        this.writeProperties = writeConf.writeProperties();
    }

    public BatchWrite toBatch() {
        return new PositionDeleteBatchWrite();
    }

    public static class DeleteTaskCommit
    implements WriterCommitMessage {
        private final DeleteFile[] taskFiles;

        DeleteTaskCommit(List<DeleteFile> deleteFiles) {
            this.taskFiles = deleteFiles.toArray(new DeleteFile[0]);
        }

        DeleteFile[] files() {
            return this.taskFiles;
        }
    }

    private static class DeleteWriter
    implements DataWriter<InternalRow> {
        private final SparkFileWriterFactory writerFactoryWithRow;
        private final SparkFileWriterFactory writerFactoryWithoutRow;
        private final OutputFileFactory deleteFileFactory;
        private final long targetFileSize;
        private final DeleteGranularity deleteGranularity;
        private final PositionDelete<InternalRow> positionDelete;
        private final FileIO io;
        private final PartitionSpec spec;
        private final int fileOrdinal;
        private final int positionOrdinal;
        private final int rowOrdinal;
        private final int rowSize;
        private final StructLike partition;
        private ClusteredPositionDeleteWriter<InternalRow> writerWithRow;
        private ClusteredPositionDeleteWriter<InternalRow> writerWithoutRow;
        private boolean closed = false;

        DeleteWriter(Table table, SparkFileWriterFactory writerFactoryWithRow, SparkFileWriterFactory writerFactoryWithoutRow, OutputFileFactory deleteFileFactory, long targetFileSize, DeleteGranularity deleteGranularity, StructType dsSchema, int specId, StructLike partition) {
            this.deleteFileFactory = deleteFileFactory;
            this.targetFileSize = targetFileSize;
            this.deleteGranularity = deleteGranularity;
            this.writerFactoryWithRow = writerFactoryWithRow;
            this.writerFactoryWithoutRow = writerFactoryWithoutRow;
            this.positionDelete = PositionDelete.create();
            this.io = table.io();
            this.spec = (PartitionSpec)table.specs().get(specId);
            this.partition = partition;
            this.fileOrdinal = dsSchema.fieldIndex(MetadataColumns.DELETE_FILE_PATH.name());
            this.positionOrdinal = dsSchema.fieldIndex(MetadataColumns.DELETE_FILE_POS.name());
            this.rowOrdinal = dsSchema.fieldIndex("row");
            DataType type = dsSchema.apply("row").dataType();
            Preconditions.checkArgument((boolean)(type instanceof StructType), (String)"Expected row as struct type but was %s", (Object)type);
            this.rowSize = ((StructType)type).size();
        }

        public void write(InternalRow record) throws IOException {
            String file = record.getString(this.fileOrdinal);
            long position = record.getLong(this.positionOrdinal);
            InternalRow row = record.getStruct(this.rowOrdinal, this.rowSize);
            if (row != null) {
                this.positionDelete.set((CharSequence)file, position, (Object)row);
                this.lazyWriterWithRow().write(this.positionDelete, this.spec, this.partition);
            } else {
                this.positionDelete.set((CharSequence)file, position, null);
                this.lazyWriterWithoutRow().write(this.positionDelete, this.spec, this.partition);
            }
        }

        public WriterCommitMessage commit() throws IOException {
            this.close();
            return new DeleteTaskCommit(this.allDeleteFiles());
        }

        public void abort() throws IOException {
            this.close();
            SparkCleanupUtil.deleteTaskFiles(this.io, this.allDeleteFiles());
        }

        public void close() throws IOException {
            if (!this.closed) {
                if (this.writerWithRow != null) {
                    this.writerWithRow.close();
                }
                if (this.writerWithoutRow != null) {
                    this.writerWithoutRow.close();
                }
                this.closed = true;
            }
        }

        private ClusteredPositionDeleteWriter<InternalRow> lazyWriterWithRow() {
            if (this.writerWithRow == null) {
                this.writerWithRow = new ClusteredPositionDeleteWriter((FileWriterFactory)this.writerFactoryWithRow, this.deleteFileFactory, this.io, this.targetFileSize, this.deleteGranularity);
            }
            return this.writerWithRow;
        }

        private ClusteredPositionDeleteWriter<InternalRow> lazyWriterWithoutRow() {
            if (this.writerWithoutRow == null) {
                this.writerWithoutRow = new ClusteredPositionDeleteWriter((FileWriterFactory)this.writerFactoryWithoutRow, this.deleteFileFactory, this.io, this.targetFileSize, this.deleteGranularity);
            }
            return this.writerWithoutRow;
        }

        private List<DeleteFile> allDeleteFiles() {
            ArrayList allDeleteFiles = Lists.newArrayList();
            if (this.writerWithRow != null) {
                allDeleteFiles.addAll(((DeleteWriteResult)this.writerWithRow.result()).deleteFiles());
            }
            if (this.writerWithoutRow != null) {
                allDeleteFiles.addAll(((DeleteWriteResult)this.writerWithoutRow.result()).deleteFiles());
            }
            return allDeleteFiles;
        }
    }

    static class PositionDeletesWriterFactory
    implements DataWriterFactory {
        private final Broadcast<Table> tableBroadcast;
        private final String queryId;
        private final FileFormat format;
        private final Long targetFileSize;
        private final DeleteGranularity deleteGranularity;
        private final Schema writeSchema;
        private final StructType dsSchema;
        private final int specId;
        private final StructLike partition;
        private final Map<String, String> writeProperties;

        PositionDeletesWriterFactory(Broadcast<Table> tableBroadcast, String queryId, FileFormat format, long targetFileSize, DeleteGranularity deleteGranularity, Schema writeSchema, StructType dsSchema, int specId, StructLike partition, Map<String, String> writeProperties) {
            this.tableBroadcast = tableBroadcast;
            this.queryId = queryId;
            this.format = format;
            this.targetFileSize = targetFileSize;
            this.deleteGranularity = deleteGranularity;
            this.writeSchema = writeSchema;
            this.dsSchema = dsSchema;
            this.specId = specId;
            this.partition = partition;
            this.writeProperties = writeProperties;
        }

        public DataWriter<InternalRow> createWriter(int partitionId, long taskId) {
            Table table = (Table)this.tableBroadcast.value();
            OutputFileFactory deleteFileFactory = OutputFileFactory.builderFor((Table)table, (int)partitionId, (long)taskId).format(this.format).operationId(this.queryId).suffix("deletes").build();
            Schema positionDeleteRowSchema = this.positionDeleteRowSchema();
            StructType deleteSparkType = this.deleteSparkType();
            StructType deleteSparkTypeWithoutRow = this.deleteSparkTypeWithoutRow();
            SparkFileWriterFactory writerFactoryWithRow = SparkFileWriterFactory.builderFor(table).deleteFileFormat(this.format).positionDeleteRowSchema(positionDeleteRowSchema).positionDeleteSparkType(deleteSparkType).writeProperties(this.writeProperties).build();
            SparkFileWriterFactory writerFactoryWithoutRow = SparkFileWriterFactory.builderFor(table).deleteFileFormat(this.format).positionDeleteSparkType(deleteSparkTypeWithoutRow).writeProperties(this.writeProperties).build();
            return new DeleteWriter(table, writerFactoryWithRow, writerFactoryWithoutRow, deleteFileFactory, this.targetFileSize, this.deleteGranularity, this.dsSchema, this.specId, this.partition);
        }

        private Schema positionDeleteRowSchema() {
            return new Schema(this.writeSchema.findField("row").type().asStructType().fields());
        }

        private StructType deleteSparkType() {
            return new StructType(new StructField[]{this.dsSchema.apply(MetadataColumns.DELETE_FILE_PATH.name()), this.dsSchema.apply(MetadataColumns.DELETE_FILE_POS.name()), this.dsSchema.apply("row")});
        }

        private StructType deleteSparkTypeWithoutRow() {
            return new StructType(new StructField[]{this.dsSchema.apply(MetadataColumns.DELETE_FILE_PATH.name()), this.dsSchema.apply(MetadataColumns.DELETE_FILE_POS.name())});
        }
    }

    class PositionDeleteBatchWrite
    implements BatchWrite {
        PositionDeleteBatchWrite() {
        }

        public DataWriterFactory createBatchWriterFactory(PhysicalWriteInfo info) {
            Broadcast tableBroadcast = SparkPositionDeletesRewrite.this.sparkContext.broadcast((Object)SerializableTableWithSize.copyOf(SparkPositionDeletesRewrite.this.table));
            return new PositionDeletesWriterFactory((Broadcast<Table>)tableBroadcast, SparkPositionDeletesRewrite.this.queryId, SparkPositionDeletesRewrite.this.format, SparkPositionDeletesRewrite.this.targetFileSize, SparkPositionDeletesRewrite.this.deleteGranularity, SparkPositionDeletesRewrite.this.writeSchema, SparkPositionDeletesRewrite.this.dsSchema, SparkPositionDeletesRewrite.this.specId, SparkPositionDeletesRewrite.this.partition, SparkPositionDeletesRewrite.this.writeProperties);
        }

        public boolean useCommitCoordinator() {
            return false;
        }

        public void commit(WriterCommitMessage[] messages) {
            PositionDeletesRewriteCoordinator coordinator = PositionDeletesRewriteCoordinator.get();
            coordinator.stageRewrite(SparkPositionDeletesRewrite.this.table, SparkPositionDeletesRewrite.this.fileSetId, (Set)ImmutableSet.copyOf(this.files(messages)));
        }

        public void abort(WriterCommitMessage[] messages) {
            SparkCleanupUtil.deleteFiles("job abort", SparkPositionDeletesRewrite.this.table.io(), this.files(messages));
        }

        private List<DeleteFile> files(WriterCommitMessage[] messages) {
            ArrayList files = Lists.newArrayList();
            for (WriterCommitMessage message : messages) {
                if (message == null) continue;
                DeleteTaskCommit taskCommit = (DeleteTaskCommit)message;
                files.addAll(Arrays.asList(taskCommit.files()));
            }
            return files;
        }
    }
}

