/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.spark.source.metrics;

import org.apache.iceberg.metrics.CounterResult;
import org.apache.iceberg.metrics.ScanReport;
import org.apache.spark.sql.connector.metric.CustomTaskMetric;

public class TaskTotalDataFileSize
implements CustomTaskMetric {
    private final long value;

    private TaskTotalDataFileSize(long value) {
        this.value = value;
    }

    public String name() {
        return "totalDataFileSize";
    }

    public long value() {
        return this.value;
    }

    public static TaskTotalDataFileSize from(ScanReport scanReport) {
        CounterResult counter = scanReport.scanMetrics().totalFileSizeInBytes();
        long value = counter != null ? counter.value() : 0L;
        return new TaskTotalDataFileSize(value);
    }
}

